/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.GlobalLogWriter;
import graphical.IniFile;
import graphical.ParameterHelper;
import helper.OSHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import util.utils;

public class FileHelper {
    private static boolean m_bDebugTextShown = false;

    public FileHelper() {
        String sOSName = System.getProperty("os.name");
        String sOSArch = System.getProperty("os.arch");
        String sOSVersion = System.getProperty("os.version");
        GlobalLogWriter.get().println(sOSName);
        GlobalLogWriter.get().println(sOSArch);
        GlobalLogWriter.get().println(sOSVersion);
    }

    public static void MessageBox(String _sStr) {
        String sVersion = System.getProperty("java.version");
        String sOSName = System.getProperty("os.name");
        JOptionPane.showMessageDialog(null, _sStr, sVersion + " " + sOSName + " Hello World Debugger", 1);
    }

    public static boolean exists(String _sFile) {
        if (_sFile == null) {
            return false;
        }
        File aFile = new File(_sFile);
        return aFile.exists();
    }

    public static boolean isDir(String _sDir) {
        if (_sDir == null) {
            return false;
        }
        try {
            File aFile = new File(_sDir);
            if (aFile.exists() && aFile.isDirectory()) {
                return true;
            }
        }
        catch (NullPointerException e) {
            GlobalLogWriter.get().println("Exception caught. FileHelper.isDir('" + _sDir + "')");
            e.printStackTrace();
        }
        return false;
    }

    public static String getBasename(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        int nIdx = _sFilename.lastIndexOf("\\");
        if (nIdx == -1) {
            nIdx = _sFilename.lastIndexOf("/");
        }
        if (nIdx > 0) {
            return _sFilename.substring(nIdx + 1);
        }
        return _sFilename;
    }

    public static String getNameNoSuffix(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        int nIdx = _sFilename.lastIndexOf(".");
        if (nIdx > 0) {
            return _sFilename.substring(0, nIdx);
        }
        return _sFilename;
    }

    public static String getSuffix(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        int nIdx = _sFilename.lastIndexOf(".");
        if (nIdx > 0) {
            return _sFilename.substring(nIdx);
        }
        return "";
    }

    public static String getPath(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        int nIdx = _sFilename.lastIndexOf("\\");
        if (nIdx == -1) {
            nIdx = _sFilename.lastIndexOf("/");
        }
        if (nIdx > 0) {
            return _sFilename.substring(0, nIdx);
        }
        return "";
    }

    public static void makeDirectories(String first, String path) {
        FileHelper.makeDirectories(first, path, "0777");
    }

    public static void makeDirectories(String first, String path, String _sMode) {
        String fs = System.getProperty("file.separator");
        if (path.startsWith(fs + fs)) {
            int n = path.indexOf(fs, 2);
            n = path.indexOf(fs, n + 1);
            first = path.substring(0, n);
            path = path.substring(n + 1);
        }
        String already_done = null;
        StringTokenizer path_tokenizer = new StringTokenizer(path, fs, false);
        already_done = first;
        while (path_tokenizer.hasMoreTokens()) {
            String part = path_tokenizer.nextToken();
            File new_dir = new File(already_done + File.separatorChar + part);
            already_done = new_dir.toString();
            new_dir.mkdirs();
            if (!OSHelper.isUnix() || _sMode.length() <= 0) continue;
            try {
                FileHelper.chmod(new_dir, _sMode);
            }
            catch (IOException e) {
                GlobalLogWriter.get().println("Exception caught. FileHelper.makeDirectories('" + new_dir.getAbsolutePath() + "')");
            }
        }
    }

    public static void chmod(File file, String mode) throws IOException {
        Runtime.getRuntime().exec(new String[]{"chmod", mode, file.getAbsolutePath()});
    }

    public static String removeFirstDirectorysAndBasenameFrom(String _sName, String _sRemovePath) {
        String fs = System.getProperty("file.separator");
        String sBasename = FileHelper.getBasename(_sName);
        String sSubDirs = "";
        if (_sName.startsWith(_sRemovePath)) {
            int nBasenameIndex;
            int nRemovePathIndex = _sRemovePath.length();
            if (!_sRemovePath.endsWith(fs)) {
                ++nRemovePathIndex;
            }
            if (nRemovePathIndex < (nBasenameIndex = _sName.length() - sBasename.length() - 1)) {
                sSubDirs = _sName.substring(nRemovePathIndex, nBasenameIndex);
            }
        } else {
            sSubDirs = FileHelper.getPath(_sName);
            if (sSubDirs.startsWith(fs)) {
                sSubDirs = sSubDirs.substring(1);
            }
        }
        return sSubDirs;
    }

    public static void test_removeFirstDirectorysAndBasenameFrom() {
        String a = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/a/b/c");
        String b = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/a/b/c/");
        String c = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/b/c");
    }

    public static String getSystemPathFromFileURL(String _sFileURL) {
        String sSystemFile = null;
        if (_sFileURL.startsWith("file:///")) {
            sSystemFile = OSHelper.isWindows() ? _sFileURL.substring(8) : _sFileURL.substring(7);
        } else if (_sFileURL.startsWith("file://")) {
            sSystemFile = _sFileURL.substring(5);
        }
        String fs = System.getProperty("file.separator");
        if (!fs.equals("/")) {
            sSystemFile = sSystemFile.replace('/', fs.toCharArray()[0]);
        }
        return sSystemFile;
    }

    public static boolean isDebugEnabled() {
        boolean bDebug = false;
        String sTmpPath = utils.getUsersTempDir();
        String fs = System.getProperty("file.separator");
        String sName = sTmpPath + fs + "DOC_COMPARATOR_DEBUG";
        File aFile = new File(sName);
        if (aFile.exists()) {
            if (!m_bDebugTextShown) {
                GlobalLogWriter.get().println("Found file: " + sName);
                GlobalLogWriter.get().println("Activate debug mode.");
                GlobalLogWriter.get().println("If debug mode is no longer necessary, remove the above file.");
                m_bDebugTextShown = true;
            }
            bDebug = true;
        }
        return bDebug;
    }

    private static void copyStream(InputStream _aIn, OutputStream _aOut) throws IOException {
        int len;
        byte[] aBuffer = new byte[65535];
        while ((len = _aIn.read(aBuffer)) != -1) {
            _aOut.write(aBuffer, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(String _sSource, String _sDestination) {
        FileInputStream aFIS = null;
        FileOutputStream aFOS = null;
        try {
            aFIS = new FileInputStream(_sSource);
            aFOS = new FileOutputStream(_sDestination);
            FileHelper.copyStream(aFIS, aFOS);
        }
        catch (IOException e) {
            System.out.println("Error: caught Exception: " + e.getMessage());
        }
        finally {
            if (aFIS != null) {
                try {
                    aFIS.close();
                }
                catch (IOException e) {
                    System.out.println("Error: caught Exception: " + e.getMessage());
                }
            }
            if (aFOS != null) {
                try {
                    aFOS.close();
                }
                catch (IOException e) {
                    System.out.println("Error: caught Exception: " + e.getMessage());
                }
            }
        }
    }

    public static FileFilter getFileFilter() {
        FileFilter aFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith("~$")) {
                    return false;
                }
                if (pathname.getName().endsWith(".prn")) {
                    return false;
                }
                if (pathname.getName().endsWith(".ps")) {
                    return false;
                }
                if (pathname.getName().endsWith(".zip")) {
                    return false;
                }
                return !pathname.getName().endsWith("_");
            }
        };
        return aFileFilter;
    }

    public static FileFilter getFileFilterPSorPDF() {
        FileFilter aFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().endsWith(".ps")) {
                    return true;
                }
                return pathname.getName().endsWith(".pdf");
            }
        };
        return aFileFilter;
    }

    public static FileFilter getFileFilterJPEG() {
        FileFilter aFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().toLowerCase().endsWith(".jpg")) {
                    return true;
                }
                return pathname.getName().toLowerCase().endsWith(".jpeg");
            }
        };
        return aFileFilter;
    }

    public static FileFilter getFileFilterINI() {
        FileFilter aFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String sPathname = pathname.getName().toLowerCase();
                if (sPathname.endsWith("index.ini")) {
                    return false;
                }
                return sPathname.endsWith(".ini");
            }
        };
        return aFileFilter;
    }

    public static String appendPath(String _sPath, String _sRelativePathToAdd) {
        String sNewPath = _sPath;
        String fs = System.getProperty("file.separator");
        if (_sPath.startsWith("file:")) {
            fs = "/";
        }
        if (!sNewPath.endsWith("/") && !sNewPath.endsWith("\\")) {
            sNewPath = sNewPath + fs;
        }
        sNewPath = sNewPath + _sRelativePathToAdd;
        return sNewPath;
    }

    public static void createInfoFile(String _sFile, ParameterHelper _aGTA) {
        FileHelper.createInfoFile(_sFile, _aGTA, "");
    }

    public static void createInfoFile(String _sFile, ParameterHelper _aGTA, String _sSpecial) {
        String sFilename;
        if (_sFile.startsWith("file://")) {
            sFilename = FileHelper.getSystemPathFromFileURL(_sFile);
            GlobalLogWriter.get().println("CreateInfoFile: '" + sFilename + "'");
        } else {
            sFilename = _sFile;
        }
        String sFileDir = FileHelper.getPath(sFilename);
        String sBasename = FileHelper.getBasename(sFilename);
        String sNameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
        String sIniFile = FileHelper.appendPath(sFileDir, sBasename + ".ini");
        IniFile aIniFile = new IniFile(sIniFile);
        String ls = System.getProperty("line.separator");
        String sInfoFilename = FileHelper.appendPath(sFileDir, sNameNoSuffix + ".info");
        File aInfoFile = new File(sInfoFilename);
        String sBuildID = "";
        try {
            FileOutputStream out2 = new FileOutputStream(aInfoFile.toString());
            PrintStream out = new PrintStream(out2);
            out.println("# automatically created file by graphical compare");
            if (_aGTA != null) {
                if (_sSpecial != null && _sSpecial.equals("msoffice")) {
                    out.println("# buildid from wordloadfile");
                    sBuildID = _aGTA.getPerformance().getMSOfficeVersion();
                    out.println("buildid=" + sBuildID);
                } else {
                    out.println("# buildid is read out of the bootstrap file");
                    sBuildID = _aGTA.getBuildID();
                    out.println("buildid=" + sBuildID);
                }
                aIniFile.insertValue("global", "buildid", sBuildID);
                out.println();
                out.println("# resolution given in DPI");
                out.println("resolution=" + _aGTA.getResolutionInDPI());
                aIniFile.insertValue("global", "resolution", _aGTA.getResolutionInDPI());
            } else {
                out.println("buildid=" + _sSpecial);
                aIniFile.insertValue("global", "buildid", _sSpecial);
            }
            out.println();
            out.println("# Values out of System.getProperty(...)");
            out.println("os.name=" + System.getProperty("os.name"));
            out.println("os.arch=" + System.getProperty("os.arch"));
            out.println("os.version=" + System.getProperty("os.version"));
            aIniFile.insertValue("global", "os.name", System.getProperty("os.name"));
            aIniFile.insertValue("global", "os.arch", System.getProperty("os.arch"));
            aIniFile.insertValue("global", "os.version", System.getProperty("os.version"));
            if (_aGTA != null) {
                out.println();
                out.println("# Performance output, values are given in milli sec.");
                _aGTA.getPerformance().print(out);
                _aGTA.getPerformance().print(aIniFile, "global");
            }
            out.flush();
            out.close();
            out2.close();
        }
        catch (IOException e) {
            GlobalLogWriter.get().println("can't create Info file.");
            e.printStackTrace();
        }
        aIniFile.close();
    }

    public static void addBasenameToFile(String _sIndexFilename, String _sBasename, String _sCreator, String _sType, String _sSource) {
        String sPath = _sIndexFilename.startsWith("file:") ? FileHelper.getSystemPathFromFileURL(_sIndexFilename) : _sIndexFilename;
        String sIndexFilename = sPath;
        IniFile aIniFile = new IniFile(sIndexFilename);
        aIniFile.insertValue(_sBasename, "creator", _sCreator);
        aIniFile.insertValue(_sBasename, "type", _sType);
        aIniFile.insertValue(_sBasename, "source", _sSource);
        aIniFile.close();
    }

    public static void addBasenameToPostscript(String _sOutputFilename) {
        String sIndexFilename = FileHelper.appendPath(_sOutputFilename, "postscript.ini");
        String sBasename = FileHelper.getBasename(_sOutputFilename);
        FileHelper.addBasenameToFile(sIndexFilename, sBasename, "", "", "");
    }

    public static void addBasenameToIndex(String _sOutputFilename, String _sBasename, String _sCreator, String _sType, String _sSource) {
        String sIndexFilename = FileHelper.appendPath(_sOutputFilename, "index.ini");
        FileHelper.addBasenameToFile(sIndexFilename, _sBasename, _sCreator, _sType, _sSource);
    }
}

