/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.FileHelper;
import graphical.GlobalLogWriter;
import graphical.IniFile;
import helper.OSHelper;
import java.io.File;

public class BuildID {
    public static String getBuildID(String _sApp) {
        int nIdx;
        String sOfficePath = "";
        if (_sApp.startsWith("\"")) {
            nIdx = _sApp.indexOf("\"", 1);
            if (nIdx != -1) {
                sOfficePath = _sApp.substring(1, nIdx);
            }
        } else {
            nIdx = _sApp.indexOf(" ", 1);
            sOfficePath = nIdx == -1 ? _sApp : _sApp.substring(0, nIdx);
        }
        GlobalLogWriter.get().println("Office path: " + sOfficePath);
        String sBuildID = "";
        File aSOfficeFile = new File(sOfficePath);
        if (aSOfficeFile.exists()) {
            sBuildID = BuildID.getBuildIDFromBootstrap(sOfficePath = FileHelper.getPath(sOfficePath));
            if (sBuildID.length() == 0) {
                sBuildID = BuildID.getBuildIDFromVersion(sOfficePath);
            }
        } else {
            GlobalLogWriter.get().println("soffice executable not found.");
        }
        return sBuildID;
    }

    private static String getBuildIDFromBootstrap(String _sOfficePath) {
        String sBuildID = "";
        String sOfficePath = OSHelper.isWindows() ? FileHelper.appendPath(_sOfficePath, "bootstrap.ini") : FileHelper.appendPath(_sOfficePath, "bootstraprc");
        IniFile aIniFile = new IniFile(sOfficePath);
        if (aIniFile.is()) {
            sBuildID = aIniFile.getValue("Bootstrap", "buildid");
        } else {
            GlobalLogWriter.get().println("Property Build, can't open file '" + sOfficePath + "', please check.");
        }
        return sBuildID;
    }

    private static String getBuildIDFromVersion(String _sOfficePath) {
        String sBuildID = "";
        String sOfficePath = OSHelper.isWindows() ? FileHelper.appendPath(_sOfficePath, "version.ini") : FileHelper.appendPath(_sOfficePath, "versionrc");
        IniFile aIniFile = new IniFile(sOfficePath);
        if (aIniFile.is()) {
            sBuildID = aIniFile.getValue("Version", "buildid");
        } else {
            GlobalLogWriter.get().println("Property Build, can't open file '" + sOfficePath + "', please check.");
        }
        return sBuildID;
    }
}

