/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DB;
import convwatch.DirectoryHelper;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalDifferenceCheck;
import convwatch.GraphicalTestArguments;
import helper.OfficeProvider;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class ReferenceBuilder
extends EnhancedComplexTestCase {
    private String m_sInputPath = "";
    private String m_sReferencePath = "";
    private boolean m_bIncludeSubdirectories = true;

    @Override
    public String getTestObjectName() {
        return "ReferenceBuilder runner";
    }

    @Override
    public String[] getTestMethodNames() {
        return new String[]{"buildreference"};
    }

    public void before() {
    }

    public void after() {
    }

    void initMember() {
        String sINPATH = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
        boolean bQuit = false;
        String sError = "";
        if (sINPATH == null || sINPATH.length() == 0) {
            log.println("Please set input path (path to documents) DOC_COMPARATOR_INPUT_PATH=path.");
            bQuit = true;
        } else {
            log.println("found DOC_COMPARATOR_INPUT_PATH " + sINPATH);
            this.m_sInputPath = sINPATH;
        }
        String sREF = (String)param.get("DOC_COMPARATOR_REFERENCE_PATH");
        if (sREF == null || sREF.length() == 0) {
            log.println("Please set output path (path to a directory, where the references should stay) DOC_COMPARATOR_REFERENCE_PATH=path.");
            bQuit = true;
        } else {
            log.println("found DOC_COMPARATOR_REFERENCE_PATH " + sREF);
            this.m_sReferencePath = sREF;
        }
        if (bQuit) {
            this.assure("Must quit, Parameter problems.", false);
        }
        if (this.m_sInputPath.startsWith("file:") || this.m_sReferencePath.startsWith("file:")) {
            this.assure("We can't handle file: URL right, use system path instead.", false);
        }
    }

    @Override
    protected Object[] mustInstalledSoftware() {
        ArrayList<String> aList = new ArrayList<String>();
        aList.add("perl -version");
        return aList.toArray();
    }

    public void buildreference() {
        GlobalLogWriter.set(log);
        String sDBConnection = (String)param.get("DB_CONNECTION_STRING");
        this.checkEnvironment(this.mustInstalledSoftware());
        GraphicalTestArguments aGTA = this.getGraphicalTestArguments();
        if (aGTA == null) {
            this.assure("Must quit", false);
        }
        if (aGTA.cancelRequest()) {
            return;
        }
        this.initMember();
        DB.init(aGTA.getDBInfoString() + "," + sDBConnection);
        File aInputPath = new File(this.m_sInputPath);
        if (aInputPath.isDirectory()) {
            String fs = System.getProperty("file.separator");
            String sRemovePath = aInputPath.getAbsolutePath();
            FileFilter aFileFilter = FileHelper.getFileFilter();
            Object[] aList = DirectoryHelper.traverse(this.m_sInputPath, aFileFilter, aGTA.includeSubDirectories());
            for (int i = 0; i < aList.length; ++i) {
                String sEntry = (String)aList[i];
                String sNewReferencePath = this.m_sReferencePath + fs + FileHelper.removeFirstDirectorysAndBasenameFrom(sEntry, this.m_sInputPath);
                log.println("- next file is: ------------------------------");
                log.println(sEntry);
                log.println(sNewReferencePath);
                if (aGTA.checkIfUsableDocumentType(sEntry)) {
                    this.runGDC(sEntry, sNewReferencePath);
                }
                if (!aGTA.cancelRequest()) {
                    continue;
                }
                break;
            }
        } else if (aGTA.checkIfUsableDocumentType(this.m_sInputPath)) {
            this.runGDC(this.m_sInputPath, this.m_sReferencePath);
        }
    }

    void runGDC(String _sInputPath, String _sReferencePath) {
        GraphicalTestArguments aGTA = this.getGraphicalTestArguments();
        if (!GraphicalDifferenceCheck.isReferenceExists(_sInputPath, _sReferencePath, aGTA)) {
            OfficeProvider aProvider = null;
            if (aGTA.shouldOfficeStart()) {
                aGTA.getPerformance().startTime(3);
                aProvider = new OfficeProvider();
                XMultiServiceFactory xMSF = (XMultiServiceFactory)aProvider.getManager(param);
                param.put("ServiceFactory", xMSF);
                aGTA.getPerformance().stopTime(3);
                long nStartTime = aGTA.getPerformance().getTime(3);
                aGTA = this.getGraphicalTestArguments();
                aGTA.getPerformance().setTime(3, nStartTime);
            }
            GlobalLogWriter.get().println("Set office watcher");
            Object aWatcher = param.get("Watcher");
            GlobalLogWriter.get().setWatcher(aWatcher);
            try {
                log.println("Reference type is " + aGTA.getReferenceType());
                DB.source_start();
                GraphicalDifferenceCheck.createOneReferenceFile(_sInputPath, _sReferencePath, aGTA);
                DB.source_finished();
            }
            catch (ConvWatchCancelException e) {
                this.assure(e.getMessage(), false);
                DB.source_failed(e.getMessage());
            }
            catch (ConvWatchException e) {
                this.assure(e.getMessage(), false);
                DB.source_failed(e.getMessage());
            }
            catch (DisposedException e) {
                this.assure(e.getMessage(), false, true);
                DB.source_failed(e.getMessage());
            }
            if (aProvider != null) {
                boolean bClosed = aProvider.closeExistingOffice(param, true);
                this.assure("Office closed", bClosed, true);
            }
        } else {
            DB.source_finished();
        }
    }
}

