/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.BorderRemover;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.PixelCounter;
import convwatch.StatusHelper;
import convwatch.TriState;
import helper.OSHelper;
import helper.ProcessHandler;
import helper.StringHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import util.utils;

public class PRNCompare {
    String fs = System.getProperty("file.separator");
    String m_sInputPath;
    String m_sReferencePath;
    String m_sOutputPath;
    String m_sDocFile;
    String m_sReferenceFile;
    String m_sPostScriptFile;
    int m_nMaxPages = 0;
    int m_nResolutionInDPI = 0;
    TriState m_tUseBorderMove;
    String m_sDocumentType;

    String executeSynchronously(String _sCommand) {
        ProcessHandler aHandler = new ProcessHandler(_sCommand);
        boolean bBackValue = aHandler.executeSynchronously();
        String sText = aHandler.getOutputText();
        GlobalLogWriter.get().println("Exitcode: " + String.valueOf(aHandler.getExitCode()));
        return sText;
    }

    int getMaxNumOfFileEntry(String _sDirectory, String _sBasename) {
        File aDirectory = new File(_sDirectory);
        File[] aDirList = aDirectory.listFiles();
        int nMaxNumber = 0;
        for (int n = 0; n < aDirList.length; ++n) {
            String sDirEntry = aDirList[n].getName();
            if (!sDirEntry.endsWith(".jpg")) continue;
            int nNum = nMaxNumber;
            if (sDirEntry.startsWith(_sBasename)) {
                int nJpgIdx = sDirEntry.lastIndexOf(".jpg");
                String sValue = sDirEntry.substring(_sBasename.length(), nJpgIdx);
                int nValue = 0;
                try {
                    nValue = Integer.valueOf(sValue);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                nNum = nValue;
            }
            if (nNum <= nMaxNumber) continue;
            nMaxNumber = nNum;
        }
        return nMaxNumber;
    }

    public void setInputPath(String _sInputPath) {
        this.m_sInputPath = _sInputPath;
    }

    public void setReferencePath(String _sReferencePath) {
        this.m_sReferencePath = _sReferencePath;
    }

    public void setOutputPath(String _sOutPath) {
        this.m_sOutputPath = _sOutPath;
    }

    public void setDocFile(String _sDocFile) {
        this.m_sDocFile = _sDocFile;
    }

    public void setReferenceFile(String _sPRNFile) {
        this.m_sReferenceFile = _sPRNFile;
    }

    public void setPostScriptFile(String _sPSFile) {
        this.m_sPostScriptFile = _sPSFile;
    }

    public void setBorderMove(TriState _b) {
        this.m_tUseBorderMove = _b;
    }

    public TriState getBorderMove() {
        return this.m_tUseBorderMove;
    }

    public void setMaxPages(int _n) {
        this.m_nMaxPages = _n;
    }

    int getMaxPages() {
        return this.m_nMaxPages;
    }

    public void setResolutionInDPI(int _n) {
        this.m_nResolutionInDPI = _n;
    }

    int getResolutionInDPI() {
        return this.m_nResolutionInDPI;
    }

    public void setDocumentType(String _sTypeName) {
        this.m_sDocumentType = _sTypeName;
    }

    public StatusHelper[] compare() {
        PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sReferencePath, this.m_sReferenceFile, this.getResolutionInDPI());
        PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sOutputPath, this.m_sPostScriptFile, this.getResolutionInDPI());
        StatusHelper[] aList = this.createDiffs(this.m_sOutputPath, this.m_sOutputPath, this.m_sReferenceFile, this.m_sOutputPath, this.m_sPostScriptFile, this.getMaxPages(), this.m_tUseBorderMove);
        return aList;
    }

    public StatusHelper[] compare_new() {
        String[] aRefList = PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sReferencePath, this.m_sReferenceFile, this.getResolutionInDPI());
        String[] aPSList = PRNCompare.createJPEGFromPostscript(this.m_sOutputPath, this.m_sOutputPath, this.m_sPostScriptFile, this.getResolutionInDPI());
        StatusHelper[] aList = this.createDiffs(this.m_sOutputPath, aRefList, aPSList, this.getMaxPages(), this.m_tUseBorderMove);
        return aList;
    }

    static String getJPEGName(String _sOutputPath, String _sBasename, String _sGS_PageOutput) {
        String fs = System.getProperty("file.separator");
        String sJPEGName = _sOutputPath + fs + _sBasename + _sGS_PageOutput + ".jpg";
        return sJPEGName;
    }

    public static String[] createJPEGFromPostscript(String _sOutputPath, String _sSourcePath, String _sSourceFile, int _nResolutionInDPI) {
        String sNewJPEGFilename;
        String sGS_PageOutput = "%04d";
        FileHelper.makeDirectories("", _sOutputPath);
        String fs = System.getProperty("file.separator");
        String sJPGFilename = PRNCompare.getJPEGName(_sOutputPath, _sSourceFile, sGS_PageOutput);
        String sOriginalFile = _sSourcePath + fs + _sSourceFile;
        String sGS = "gs";
        if (OSHelper.isWindows()) {
            sGS = "gswin32c.exe";
        }
        String sCommand = sGS + " -dNOPROMPT -dBATCH -sDEVICE=jpeg -r" + String.valueOf(_nResolutionInDPI) + " -dNOPAUSE -sOutputFile=" + StringHelper.doubleQuoteIfNeed(sJPGFilename) + " " + StringHelper.doubleQuoteIfNeed(sOriginalFile);
        String[] sCommandArray = new String[]{sGS, "-dNOPROMPT", "-dBATCH", "-sDEVICE=jpeg", "-r" + String.valueOf(_nResolutionInDPI), "-dNOPAUSE", "-sOutputFile=" + sJPGFilename, sOriginalFile};
        ProcessHandler aHandler = new ProcessHandler(sCommandArray);
        boolean bBackValue = aHandler.executeSynchronously();
        ArrayList<String> m_aFileList = new ArrayList<String>();
        for (int i = 1; i < 9999 && FileHelper.exists(sNewJPEGFilename = utils.replaceAll13(sJPGFilename, sGS_PageOutput, StringHelper.createValueString(i, 4))); ++i) {
            m_aFileList.add(sNewJPEGFilename);
        }
        String[] aList = new String[m_aFileList.size()];
        aList = m_aFileList.toArray(aList);
        return aList;
    }

    public StatusHelper[] createDiffs(String _sOutputPath, String _sSourcePath1, String _sSourceFile1, String _sSourcePath2, String _sSourceFile2, int _nMaxDiffs, TriState _tUseBorderMove) {
        if (_nMaxDiffs < 1) {
            _nMaxDiffs = 1;
        }
        String sS1Basename = FileHelper.getBasename(_sSourceFile1);
        String sS2Basename = FileHelper.getBasename(_sSourceFile2);
        int nS1_Files = this.getMaxNumOfFileEntry(_sSourcePath1, sS1Basename);
        int nS2_Files = this.getMaxNumOfFileEntry(_sSourcePath2, sS2Basename);
        int nMin = Math.min(nS1_Files, nS2_Files);
        nMin = Math.min(nMin, _nMaxDiffs);
        StatusHelper[] aList = new StatusHelper[nMin];
        int nStatusIndex = 0;
        for (int i = 1; i <= nMin; ++i) {
            StatusHelper aStatus;
            block10: {
                String sOldGfx = PRNCompare.getJPEGName(_sSourcePath1, sS1Basename, StringHelper.createValueString(i, 4));
                String sNewGfx = PRNCompare.getJPEGName(_sSourcePath2, sS2Basename, StringHelper.createValueString(i, 4));
                String sDiffGfx_ = PRNCompare.getJPEGName(_sOutputPath, sS1Basename + ".diff", StringHelper.createValueString(i, 4));
                String sDiffGfx = PRNCompare.compareJPEGs(sOldGfx, sNewGfx, sDiffGfx_);
                aStatus = new StatusHelper(sOldGfx, sNewGfx, sDiffGfx);
                if (sDiffGfx.length() > 0) {
                    int nResult = this.identify(sDiffGfx);
                    if (nResult == 1) {
                        aStatus.nDiffStatus = 2;
                    } else {
                        try {
                            int nPercent = this.estimateGfx(sOldGfx, sNewGfx, sDiffGfx);
                            aStatus.nDiffStatus = 3;
                            aStatus.nPercent = nPercent;
                            if (nPercent <= 75 || _tUseBorderMove != TriState.TRUE && (_tUseBorderMove != TriState.UNSET || this.m_sDocumentType.indexOf("MS PowerPoint") <= 0)) break block10;
                            this.setBorderMove(TriState.TRUE);
                            String sOld_BM_Gfx = PRNCompare.getJPEGName(_sSourcePath1, sS1Basename + ".BM", StringHelper.createValueString(i, 4));
                            String sNew_BM_Gfx = PRNCompare.getJPEGName(_sSourcePath2, sS2Basename + ".BM", StringHelper.createValueString(i, 4));
                            String sDiff_BM_Gfx_ = PRNCompare.getJPEGName(_sOutputPath, sS1Basename + ".diff.BM", StringHelper.createValueString(i, 4));
                            aStatus.setFilesForBorderMove(sOld_BM_Gfx, sNew_BM_Gfx, sDiff_BM_Gfx_);
                            try {
                                BorderRemover a = new BorderRemover();
                                a.createNewImageWithoutBorder(sOldGfx, sOld_BM_Gfx);
                                a.createNewImageWithoutBorder(sNewGfx, sNew_BM_Gfx);
                                String sDiff_BM_Gfx = PRNCompare.compareJPEGs(sOld_BM_Gfx, sNew_BM_Gfx, sDiff_BM_Gfx_);
                                if (sDiff_BM_Gfx.length() <= 0) break block10;
                                nResult = this.identify(sDiff_BM_Gfx);
                                if (nResult == 1) {
                                    aStatus.nDiffStatus = 4;
                                    aStatus.nPercent2 = 0;
                                    break block10;
                                }
                                nPercent = this.estimateGfx(sOld_BM_Gfx, sNew_BM_Gfx, sDiff_BM_Gfx);
                                aStatus.nDiffStatus = 5;
                                aStatus.nPercent2 = nPercent;
                            }
                            catch (IOException e) {
                                GlobalLogWriter.get().println("Exception caught. At border remove: " + e.getMessage());
                            }
                        }
                        catch (IOException e) {
                            GlobalLogWriter.get().println(e.getMessage());
                        }
                    }
                }
            }
            aList[nStatusIndex++] = aStatus;
        }
        return aList;
    }

    public StatusHelper[] createDiffs(String _sOutputPath, String[] _aRefList, String[] _aPSList, int _nMaxDiffs, TriState _tUseBorderMove) {
        if (_nMaxDiffs < 1) {
            _nMaxDiffs = 1;
        }
        int nMin = Math.min(_aRefList.length, _aPSList.length);
        nMin = Math.min(nMin, _nMaxDiffs);
        StatusHelper[] aList = new StatusHelper[nMin];
        int nStatusIndex = 0;
        for (int i = 1; i <= nMin; ++i) {
            StatusHelper aStatus;
            block10: {
                String sOldGfx = _aRefList[i];
                String sNewGfx = _aPSList[i];
                String sDiffGfx = PRNCompare.compareJPEGs(sOldGfx, sNewGfx);
                aStatus = new StatusHelper(sOldGfx, sNewGfx, sDiffGfx);
                if (sDiffGfx.length() > 0) {
                    int nResult = this.identify(sDiffGfx);
                    if (nResult == 1) {
                        aStatus.nDiffStatus = 2;
                    } else {
                        try {
                            int nPercent = this.estimateGfx(sOldGfx, sNewGfx, sDiffGfx);
                            aStatus.nDiffStatus = 3;
                            aStatus.nPercent = nPercent;
                            if (nPercent <= 75 || _tUseBorderMove != TriState.TRUE && (_tUseBorderMove != TriState.UNSET || this.m_sDocumentType.indexOf("MS PowerPoint") <= 0)) break block10;
                            _tUseBorderMove = TriState.TRUE;
                            String sBasename1 = FileHelper.getBasename(sOldGfx);
                            String sNameNoSuffix1 = FileHelper.getNameNoSuffix(sBasename1);
                            String sBasename2 = FileHelper.getBasename(sNewGfx);
                            String sNameNoSuffix2 = FileHelper.getNameNoSuffix(sBasename2);
                            String sTmpDir = utils.getUsersTempDir();
                            String fs = System.getProperty("file.separator");
                            String sOld_BM_Gfx = sTmpDir + fs + sNameNoSuffix1 + "-BM-" + StringHelper.createValueString(i, 4) + ".jpg";
                            String sNew_BM_Gfx = sTmpDir + fs + sNameNoSuffix2 + "-BM-" + StringHelper.createValueString(i, 4) + ".jpg";
                            try {
                                BorderRemover a = new BorderRemover();
                                a.createNewImageWithoutBorder(sOldGfx, sOld_BM_Gfx);
                                a.createNewImageWithoutBorder(sNewGfx, sNew_BM_Gfx);
                                String sDiff_BM_Gfx = PRNCompare.compareJPEGs(sOld_BM_Gfx, sNew_BM_Gfx);
                                aStatus.setFilesForBorderMove(sOld_BM_Gfx, sNew_BM_Gfx, sDiff_BM_Gfx);
                                if (sDiff_BM_Gfx.length() <= 0) break block10;
                                nResult = this.identify(sDiff_BM_Gfx);
                                if (nResult == 1) {
                                    aStatus.nDiffStatus = 4;
                                    aStatus.nPercent2 = 0;
                                    break block10;
                                }
                                nPercent = this.estimateGfx(sOld_BM_Gfx, sNew_BM_Gfx, sDiff_BM_Gfx);
                                aStatus.nDiffStatus = 5;
                                aStatus.nPercent2 = nPercent;
                            }
                            catch (IOException e) {
                                GlobalLogWriter.get().println("Exception caught. At border remove: " + e.getMessage());
                            }
                        }
                        catch (IOException e) {
                            GlobalLogWriter.get().println(e.getMessage());
                        }
                    }
                }
            }
            aList[nStatusIndex++] = aStatus;
        }
        return aList;
    }

    public static String compareJPEGs(String _sOldGfx, String _sNewGfx) {
        String sBasename1 = FileHelper.getBasename(_sOldGfx);
        String sNameNoSuffix1 = FileHelper.getNameNoSuffix(sBasename1);
        String sBasename2 = FileHelper.getBasename(_sNewGfx);
        String sNameNoSuffix2 = FileHelper.getNameNoSuffix(sBasename2);
        String sTmpDir = utils.getUsersTempDir();
        String fs = System.getProperty("file.separator");
        String sDiffName = sTmpDir + fs + sNameNoSuffix1 + "-" + sNameNoSuffix2 + "-diff.jpg";
        return PRNCompare.compareJPEGs(_sOldGfx, _sNewGfx, sDiffName);
    }

    public static String compareJPEGs(String _sOldGfx, String _sNewGfx, String _sDiffGfx) {
        String sComposite = "composite";
        if (OSHelper.isWindows()) {
            sComposite = "composite.exe";
        }
        String[] sCommandArray = new String[]{sComposite, "-compose", "difference", _sOldGfx, _sNewGfx, _sDiffGfx};
        ProcessHandler aHandler = new ProcessHandler(sCommandArray);
        boolean bBackValue = aHandler.executeSynchronously();
        String sBack = aHandler.getOutputText();
        GlobalLogWriter.get().println("'" + sBack + "'");
        if (FileHelper.exists(_sDiffGfx)) {
            return _sDiffGfx;
        }
        return "";
    }

    int identify(String _sDiffGfx) {
        int nResult = 0;
        String sIM_Format = "%k";
        String sIdentify = "identify";
        if (OSHelper.isWindows()) {
            sIdentify = "identify.exe";
        }
        String[] sCommandArray = new String[]{sIdentify, "-format", sIM_Format, _sDiffGfx};
        ProcessHandler aHandler = new ProcessHandler(sCommandArray);
        boolean bBackValue = aHandler.executeSynchronously();
        String sBack = aHandler.getOutputText();
        GlobalLogWriter.get().println("'" + sBack + "'");
        try {
            int nIdx = sBack.indexOf("\n");
            if (nIdx > 0) {
                sBack = sBack.substring(0, nIdx);
            }
            nResult = Integer.valueOf(sBack);
        }
        catch (NumberFormatException e) {
            GlobalLogWriter.get().println("Number format exception");
            nResult = 0;
        }
        return nResult;
    }

    public StatusHelper checkDiffDiff(String _sOutputPath, String _sSourcePath1, String _sSourceFile1, String _sSourcePath2, String _sSourceFile2) {
        String sNewGfx = _sSourcePath1 + this.fs + _sSourceFile1;
        String sOldGfx = _sSourcePath2 + this.fs + _sSourceFile2;
        int nNumber = 1;
        String sDiffGfx = PRNCompare.getJPEGName(_sOutputPath, _sSourceFile1 + ".diff", StringHelper.createValueString(nNumber, 4));
        StatusHelper aCurrentStatus = new StatusHelper(sOldGfx, sNewGfx, sDiffGfx);
        PRNCompare.compareJPEGs(sOldGfx, sNewGfx, sDiffGfx);
        if (FileHelper.exists(sDiffGfx)) {
            int nResult = this.identify(sDiffGfx);
            if (nResult == 1) {
                aCurrentStatus.nDiffStatus = 2;
            } else {
                aCurrentStatus.nDiffStatus = 3;
                try {
                    aCurrentStatus.nPercent = this.estimateGfx(sOldGfx, sNewGfx, sDiffGfx);
                }
                catch (IOException e) {
                    GlobalLogWriter.get().println(e.getMessage());
                    aCurrentStatus.nPercent = -1;
                }
            }
        } else {
            GlobalLogWriter.get().println("composite can't create the diffdiff file.");
        }
        return aCurrentStatus;
    }

    public int estimateGfx(String _sOldGfx, String _sNewGfx, String _sDiffGfx) throws IOException {
        int nNotWhiteCount_OldGraphic = PixelCounter.countNotWhitePixelsFromImage(_sOldGfx);
        int nNotWhiteCount_NewGraphic = PixelCounter.countNotWhitePixelsFromImage(_sNewGfx);
        int nNotBlackCount_DiffGraphic = PixelCounter.countNotBlackPixelsFromImage(_sDiffGfx);
        int nMinNotWhiteCount = Math.min(nNotWhiteCount_NewGraphic, nNotWhiteCount_OldGraphic);
        if (nMinNotWhiteCount == 0 && (nMinNotWhiteCount = Math.max(nNotWhiteCount_NewGraphic, nNotWhiteCount_OldGraphic)) == 0) {
            nMinNotWhiteCount = 1;
        }
        int nPercent = Math.abs(nNotBlackCount_DiffGraphic * 100 / nMinNotWhiteCount);
        GlobalLogWriter.get().println("Graphics check, pixel based:" + String.valueOf(nPercent) + "% pixel differ ");
        return nPercent;
    }
}

