/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ConvWatchCancelException;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.OfficePrint;
import convwatch.TimeHelper;
import helper.OSHelper;
import helper.ProcessHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import util.utils;

public class MSOfficePrint {
    private String m_sPrinterName;

    public void setPrinterName(String _s) {
        this.m_sPrinterName = _s;
    }

    static boolean isWordDocument(String _sSuffix) {
        return _sSuffix.toLowerCase().endsWith(".doc") || _sSuffix.toLowerCase().endsWith(".rtf") || _sSuffix.toLowerCase().endsWith(".dot");
    }

    static boolean isExcelDocument(String _sSuffix) {
        return _sSuffix.toLowerCase().endsWith(".xls");
    }

    static boolean isPowerPointDocument(String _sSuffix) {
        return _sSuffix.toLowerCase().endsWith(".pps") || _sSuffix.toLowerCase().endsWith(".ppt");
    }

    public static boolean isMSOfficeDocumentFormat(String _sFile) {
        String sDocumentSuffix = FileHelper.getSuffix(_sFile);
        if (MSOfficePrint.isWordDocument(sDocumentSuffix)) {
            return true;
        }
        if (MSOfficePrint.isExcelDocument(sDocumentSuffix)) {
            return true;
        }
        if (MSOfficePrint.isPowerPointDocument(sDocumentSuffix)) {
            return true;
        }
        return sDocumentSuffix.toLowerCase().endsWith(".xml");
    }

    public void storeToFileWithMSOffice(GraphicalTestArguments _aGTA, String _sInputFile, String _sOutputFile) throws ConvWatchCancelException, IOException {
        String sDocumentSuffix = FileHelper.getSuffix(_sInputFile);
        String sFilterName = _aGTA.getExportFilterName();
        ArrayList aStartCommand = new ArrayList();
        if (MSOfficePrint.isWordDocument(sDocumentSuffix)) {
            aStartCommand = this.createWordStoreHelper();
        } else if (MSOfficePrint.isExcelDocument(sDocumentSuffix)) {
            aStartCommand = this.createExcelStoreHelper();
        } else if (!MSOfficePrint.isPowerPointDocument(sDocumentSuffix)) {
            if (sDocumentSuffix.toLowerCase().equals(".xml")) {
                if (_aGTA.getDefaultXMLFormatApp().toLowerCase().equals("excel")) {
                    aStartCommand = this.createExcelStoreHelper();
                }
            } else {
                GlobalLogWriter.get().println("No Microsoft Office document format found.");
                throw new ConvWatchCancelException("No MS office document format found.");
            }
        }
        if (aStartCommand != null) {
            if (sFilterName == null) {
                sFilterName = "";
            }
            aStartCommand.add(_sInputFile);
            aStartCommand.add(sFilterName);
            aStartCommand.add(_sOutputFile);
            this.realStartCommand(aStartCommand);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void printToFileWithMSOffice(GraphicalTestArguments _aGTA, String _sInputFile, String _sPrintFilename) throws ConvWatchCancelException, IOException {
        String fs;
        String sUserDir;
        String sDocumentSuffix = FileHelper.getSuffix(_sInputFile);
        this.setPrinterName(_aGTA.getPrinterName());
        ArrayList aStartCommand = new ArrayList();
        if (MSOfficePrint.isWordDocument(sDocumentSuffix)) {
            aStartCommand = this.createWordPrintHelper();
        } else if (MSOfficePrint.isExcelDocument(sDocumentSuffix)) {
            aStartCommand = this.createExcelPrintHelper();
        } else if (MSOfficePrint.isPowerPointDocument(sDocumentSuffix)) {
            aStartCommand = this.createPowerPointPrintHelper();
        } else if (sDocumentSuffix.toLowerCase().equals(".xml")) {
            String sOfficeType = this.getOfficeType(_sInputFile);
            if (sOfficeType.equals("excel")) {
                aStartCommand = this.createExcelPrintHelper();
            } else {
                if (!sOfficeType.equals("word")) return;
                aStartCommand = this.createWordPrintHelper();
            }
        } else {
            GlobalLogWriter.get().println("No Microsoft Office document format found.");
            throw new ConvWatchCancelException("No Mircosoft Office document format found.");
        }
        if (!aStartCommand.isEmpty()) {
            String sPrinterName = this.m_sPrinterName;
            if (sPrinterName == null) {
                sPrinterName = "";
            }
            aStartCommand.add(_sInputFile);
            aStartCommand.add(this.m_sPrinterName);
            aStartCommand.add(_sPrintFilename);
            this.realStartCommand(aStartCommand);
        }
        if (!(sUserDir = System.getProperty("user.home")).endsWith(fs = System.getProperty("file.separator"))) {
            sUserDir = sUserDir + fs;
        }
        _aGTA.getPerformance().readWordValuesFromFile(sUserDir + "msofficeloadtimes.txt");
        OfficePrint.createInfoFile(_sPrintFilename, _aGTA, "msoffice");
        TimeHelper.waitInSeconds(2, "Give Microsoft Office some time to print.");
    }

    public void realStartCommand(ArrayList _aStartCommand) throws ConvWatchCancelException {
        if (_aStartCommand.isEmpty()) {
            throw new ConvWatchCancelException("Given list is empty.");
        }
        try {
            int nValues = _aStartCommand.size();
            String[] aList = new String[nValues];
            for (int i = 0; i < nValues; ++i) {
                String aStr = (String)_aStartCommand.get(i);
                if (aStr == null) {
                    aStr = "";
                }
                if (aStr.length() == 0) {
                    aStr = "\"\"";
                }
                aList[i] = new String(aStr);
            }
            if (!OSHelper.isWindows()) {
                throw new ConvWatchCancelException("We doesn't work within windows environment.");
            }
            ProcessHandler aHandler = new ProcessHandler(aList);
            boolean bBackValue = aHandler.executeSynchronously();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConvWatchCancelException("Given list is too short.");
        }
    }

    ArrayList createWordPrintHelper() throws IOException {
        String sTmpPath = utils.getUsersTempDir();
        String ls = System.getProperty("line.separator");
        String fs = System.getProperty("file.separator");
        String sPrintViaWord = "printViaWord.pl";
        ArrayList aList = this.searchLocalFile(sPrintViaWord);
        if (!aList.isEmpty()) {
            return aList;
        }
        String sName = sTmpPath + fs + sPrintViaWord;
        File aFile = new File(sName);
        FileWriter out = new FileWriter(aFile.toString());
        out.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                          " + ls);
        out.write("   if 0;                                                                                     " + ls);
        out.write("use strict;                                                                                  " + ls);
        out.write("use Time::HiRes;                                                                             " + ls);
        out.write("if ( $^O ne \"MSWin32\")                                                                     " + ls);
        out.write("{                                                                                            " + ls);
        out.write("   print 'Windows only.\\n';                                                                  " + ls);
        out.write("   print_usage();                                                                            " + ls);
        out.write("   exit(1);                                                                                  " + ls);
        out.write("}                                                                                            " + ls);
        out.write("                                                                                             " + ls);
        out.write("use Win32::OLE;                                                                              " + ls);
        out.write("use Win32::OLE::Const 'Microsoft Word';                                                      " + ls);
        out.write("                                                                                             " + ls);
        out.write("# ------ usage ------                                                                        " + ls);
        out.write("sub print_usage()                                                                            " + ls);
        out.write("{                                                                                            " + ls);
        out.write("    print STDERR \"Usage: word_print.pl  <Word file> <name of printer> <output file> .\\n     " + ls);
        out.write("                  Please use the same string for the name of the printer as you can find \\n  " + ls);
        out.write("                  under Start-Control Panel-Printer and Faxes  \\n                        " + ls);
        out.write("                  The name could look like the the following line: \\n                        " + ls);
        out.write("                  Apple LaserWriter II NT v47.0 \\n                                           " + ls);
        out.write("                  Sample command line: \\n                                                    " + ls);
        out.write("                  execl_print.pl  c:\\book1.doc Apple LaserWriter II NT v47.0 c:\\output\\book1.ps \\n\";  " + ls);
        out.write("}                                                                                            " + ls);
        out.write("                                                                                             " + ls);
        out.write("                                                                                             " + ls);
        out.write("if ($#ARGV != 2)                                                                             " + ls);
        out.write("{                                                                                            " + ls);
        out.write("   print 'Too less arguments.\\n';                                                            " + ls);
        out.write("   print_usage();                                                                            " + ls);
        out.write("   exit(1);                                                                                  " + ls);
        out.write("}                                                                                            " + ls);
        out.write("                                                                                             " + ls);
        out.write("my $startWordTime = Time::HiRes::time(); " + ls);
        out.write("my $Word = Win32::OLE->new('Word.Application');                                              " + ls);
        out.write("my $stopWordTime = Time::HiRes::time() - $startWordTime; " + ls);
        out.write("# $Word->{'Visible'} = 1;         # if you want to see what's going on                       " + ls);
        out.write("# , ReadOnly => 1})" + ls);
        out.write(ls);
        out.write("my $startLoadWordTime = Time::HiRes::time(); " + ls);
        out.write("$Word->Documents->Open({Filename => $ARGV[0]})                                               " + ls);
        out.write("    || die('Unable to open document ', Win32::OLE->LastError());                             " + ls);
        out.write("my $stopLoadWordTime = Time::HiRes::time() - $startLoadWordTime; " + ls);
        out.write(ls);
        out.write("my $startPrintWordTime = Time::HiRes::time(); " + ls);
        out.write("my $oldActivePrinte = $Word->{ActivePrinter} ;                                               " + ls);
        out.write("$Word->{ActivePrinter} = $ARGV[1];                                                           " + ls);
        out.write("$Word->ActiveDocument->PrintOut({                                                            " + ls);
        out.write("                                 Background => 0,                                            " + ls);
        out.write("                                 Append     => 0,                                            " + ls);
        out.write("                                 Range      => wdPrintAllDocument,                           " + ls);
        out.write("                                 Item       => wdPrintDocumentContent,                       " + ls);
        out.write("                                 Copies     => 1,                                            " + ls);
        out.write("                                 PageType   => wdPrintAllPages,                              " + ls);
        out.write("                                 PrintToFile => 1,                                           " + ls);
        out.write("                                 OutputFileName => $ARGV[2]                                  " + ls);
        out.write("  });                                                                                        " + ls);
        out.write("$Word->{ActivePrinter} = $oldActivePrinte;                                                   " + ls);
        out.write("my $stopPrintWordTime = Time::HiRes::time() - $startPrintWordTime;" + ls);
        out.write("# ActiveDocument.Close(SaveChanges:=WdSaveOptions.wdDoNotSaveChanges)" + ls);
        out.write("my $sVersion = $Word->Application->Version();" + ls);
        out.write("$Word->ActiveDocument->Close({SaveChanges => 0});                                                           " + ls);
        out.write("$Word->Quit();                                                                               " + ls);
        out.write("local *FILE;" + ls);
        out.write("if (open(FILE, \">$ENV{HOME}/msofficeloadtimes.txt\"))" + ls);
        out.write("{" + ls);
        out.write("   print FILE \"name=$ARGV[0]\\n\";" + ls);
        out.write("   print FILE \"WordVersion=$sVersion\\n\";" + ls);
        out.write("   print FILE \"WordStartTime=$stopWordTime\\n\";" + ls);
        out.write("   print FILE \"WordLoadTime=$stopLoadWordTime\\n\";" + ls);
        out.write("   print FILE \"WordPrintTime=$stopPrintWordTime\\n\";" + ls);
        out.write("   close(FILE);" + ls);
        out.write("}" + ls);
        out.close();
        aList.add("perl");
        aList.add(sName);
        return aList;
    }

    ArrayList searchLocalFile(String _sScriptName) {
        String userdir = System.getProperty("user.dir");
        String fs = System.getProperty("file.separator");
        ArrayList<String> aList = new ArrayList<String>();
        File aPerlScript = new File(userdir + fs + _sScriptName);
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("Search for local existance of " + aPerlScript.getAbsolutePath());
        }
        if (aPerlScript.exists()) {
            if (FileHelper.isDebugEnabled()) {
                GlobalLogWriter.get().println("OK, found it, use this instead the internal one.");
            }
            String sName = aPerlScript.getAbsolutePath();
            aList.add("perl");
            aList.add(sName);
            return aList;
        }
        return aList;
    }

    ArrayList createWordStoreHelper() throws IOException {
        String sTmpPath = utils.getUsersTempDir();
        String ls = System.getProperty("line.separator");
        String fs = System.getProperty("file.separator");
        String sSaveViaWord = "saveViaWord.pl";
        ArrayList aList = this.searchLocalFile(sSaveViaWord);
        if (!aList.isEmpty()) {
            return aList;
        }
        String sName = sTmpPath + fs + sSaveViaWord;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a perl script: " + sName);
        }
        File aFile = new File(sName);
        FileWriter out = new FileWriter(aFile.toString());
        out.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                          " + ls);
        out.write("   if 0;                                                                                     " + ls);
        out.write("use strict;                                                                                  " + ls);
        out.write("                                                                                             " + ls);
        out.write("if ( $^O ne \"MSWin32\")                                                                     " + ls);
        out.write("{                                                                                            " + ls);
        out.write("   print 'Windows only.\\n';                                                                  " + ls);
        out.write("   print_usage();                                                                            " + ls);
        out.write("   exit(1);                                                                                  " + ls);
        out.write("}                                                                                            " + ls);
        out.write("                                                                                             " + ls);
        out.write("use Win32::OLE;                                                                              " + ls);
        out.write("use Win32::OLE::Const 'Microsoft Word';                                                      " + ls);
        out.write("                                                                                             " + ls);
        out.write("# ------ usage ------                                                                        " + ls);
        out.write("sub print_usage()                                                                            " + ls);
        out.write("{                                                                                            " + ls);
        out.write("    print STDERR \"Usage: storeViaWord.pl  <Word file> <output filer> <output file> \\n\"     " + ls);
        out.write("}                                                                                            " + ls);
        out.write("                                                                                             " + ls);
        out.write("                                                                                             " + ls);
        out.write("if ($#ARGV != 2)                                                                             " + ls);
        out.write("{                                                                                            " + ls);
        out.write("   print 'Too less arguments.\\n';                                                            " + ls);
        out.write("   print_usage();                                                                            " + ls);
        out.write("   exit(1);                                                                                  " + ls);
        out.write("}                                                                                            " + ls);
        out.write("                                                                                             " + ls);
        out.write("                                                                                             " + ls);
        out.write("my $Word = Win32::OLE->new('Word.Application');                                              " + ls);
        out.write("# $Word->{'Visible'} = 1;         # if you want to see what's going on                       " + ls);
        out.write("my $Book = $Word->Documents->Open($ARGV[0])                                                             " + ls);
        out.write("    || die('Unable to open document ', Win32::OLE->LastError());                             " + ls);
        out.write("# my $oldActivePrinte = $Word->{ActivePrinter} ;                                               " + ls);
        out.write("# $Word->{ActivePrinter} = $ARGV[1];                                                           " + ls);
        out.write("# $Word->ActiveDocument->PrintOut({                                                            " + ls);
        out.write("#                                  Background => 0,                                            " + ls);
        out.write("#                                  Append     => 0,                                            " + ls);
        out.write("#                                  Range      => wdPrintAllDocument,                           " + ls);
        out.write("#                                  Item       => wdPrintDocumentContent,                       " + ls);
        out.write("#                                  Copies     => 1,                                            " + ls);
        out.write("#                                  PageType   => wdPrintAllPages,                              " + ls);
        out.write("#                                  PrintToFile => 1,                                           " + ls);
        out.write("#                                  OutputFileName => $ARGV[2]                                  " + ls);
        out.write("#   });                                                                                        " + ls);
        out.write("# $Word->{ActivePrinter} = $oldActivePrinte;                                                   " + ls);
        out.write("$Book->savaAs($ARGV[2], $ARGV[1]);                                                             " + ls);
        out.write("# ActiveDocument.Close(SaveChanges:=WdSaveOptions.wdDoNotSaveChanges)" + ls);
        out.write("$Book->Close({SaveChanges => 0});                                                           " + ls);
        out.write("$Word->Quit();                                                                               " + ls);
        out.close();
        aList.add("perl");
        aList.add(sName);
        return aList;
    }

    ArrayList createExcelPrintHelper() throws IOException {
        String sTmpPath = utils.getUsersTempDir();
        String ls = System.getProperty("line.separator");
        String fs = System.getProperty("file.separator");
        String sPrintViaExcel = "printViaExcel.pl";
        ArrayList aList = this.searchLocalFile(sPrintViaExcel);
        if (!aList.isEmpty()) {
            return aList;
        }
        String sName = sTmpPath + fs + sPrintViaExcel;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a perl script: " + sName);
        }
        File aFile = new File(sName);
        FileWriter out = new FileWriter(aFile.toString());
        out.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                                                " + ls);
        out.write("   if 0;                                                                                                         " + ls);
        out.write("use strict;                                                                                                      " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("if ( $^O ne \"MSWin32\")                                                                                         " + ls);
        out.write("{                                                                                                                " + ls);
        out.write("   print \"Windows only.\\n\";                                                                                    " + ls);
        out.write("   print_usage();                                                                                                " + ls);
        out.write("   exit(1);                                                                                                      " + ls);
        out.write("}                                                                                                                " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("use Win32::OLE qw(in with);                                                                                      " + ls);
        out.write("use Win32::OLE::Const 'Microsoft Excel';                                                                         " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("# ------ usage ------                                                                                            " + ls);
        out.write("sub print_usage()                                                                                                " + ls);
        out.write("{                                                                                                                " + ls);
        out.write("    print STDERR \"Usage: printViaExcel.pl  <Excel file> <name of printer> <output file> .\\n                       " + ls);
        out.write("                  Please use the same string for the name of the printer as you can find \\n                      " + ls);
        out.write("                  under Start-Control Panel-Printer and Faxes  \\n                                            " + ls);
        out.write("                  The name could look like the the following line: \\n                                            " + ls);
        out.write("                  Apple LaserWriter II NT v47.0 \\n                                                               " + ls);
        out.write("                  Sample command line: \\n                                                                        " + ls);
        out.write("                  execl_print.pl  c:\\book1.xls Apple LaserWriter II NT v47.0 c:\\output\\book1.ps \\n\";     " + ls);
        out.write("}                                                                                                                " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("$Win32::OLE::Warn = 3;                                # die on errors...                                         " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("if ($#ARGV != 2)                                                                                                 " + ls);
        out.write("{                                                                                                                " + ls);
        out.write("   print STDERR \"Too less arguments.\\n\";                                                                      " + ls);
        out.write("   print STDERR \"ARGV[0] $ARGV[0]\\n\";                                                                         " + ls);
        out.write("   print STDERR \"ARGV[1] $ARGV[1]\\n\";                                                                         " + ls);
        out.write("   print STDERR \"ARGV[2] $ARGV[2]\\n\";                                                                         " + ls);
        out.write("   print_usage();                                                                                                " + ls);
        out.write("   exit(1);                                                                                                      " + ls);
        out.write("}                                                                                                                " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("my $Excel = Win32::OLE->GetActiveObject('Excel.Application')                                                     " + ls);
        out.write("    || Win32::OLE->new('Excel.Application', 'Quit');  # get already active Excel                                 " + ls);
        out.write("                                                      # application or open new                                  " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("my $Book = $Excel->Workbooks->Open( $ARGV[0] );                                                                  " + ls);
        out.write("   $Book->PrintOut({Copies => 1,                                                                                 " + ls);
        out.write("                    ActivePrinter => $ARGV[1],                                                                   " + ls);
        out.write("                    PrToFileName => $ARGV[2],                                                                    " + ls);
        out.write("                    Collate => 1                                                                                 " + ls);
        out.write("                    });                                                                                          " + ls);
        out.write("# Close worksheets without store changes" + ls);
        out.write("# $Book->Close({SaveChanges => 0});                                                           " + ls);
        out.write("my $sVersion = $Excel->Application->Version();" + ls);
        out.write("$Excel->Quit();                                                                                                     " + ls);
        out.write("local *FILE;" + ls);
        out.write("if (open(FILE, \">$ENV{HOME}/msofficeloadtimes.txt\"))" + ls);
        out.write("{" + ls);
        out.write("   print FILE \"name=$ARGV[0]\\n\";" + ls);
        out.write("   print FILE \"ExcelVersion=$sVersion\\n\";" + ls);
        out.write("   close(FILE);" + ls);
        out.write("}" + ls);
        out.close();
        aList.add("perl");
        aList.add(sName);
        return aList;
    }

    ArrayList createExcelStoreHelper() throws IOException {
        String sTmpPath = utils.getUsersTempDir();
        String ls = System.getProperty("line.separator");
        String fs = System.getProperty("file.separator");
        String sSaveViaExcel = "saveViaExcel.pl";
        ArrayList aList = this.searchLocalFile(sSaveViaExcel);
        if (!aList.isEmpty()) {
            return aList;
        }
        String sName = sTmpPath + fs + sSaveViaExcel;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a script: " + sName);
        }
        File aFile = new File(sName);
        FileWriter out = new FileWriter(aFile.toString());
        out.write("eval 'exec perl -wS $0 ${1+\"$@\"}'                                                                                " + ls);
        out.write("   if 0;                                                                                                         " + ls);
        out.write("use strict;                                                                                                      " + ls);
        out.write("# This script is automatically created.                                                                          " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("use Win32::OLE qw(in with);                                                                                      " + ls);
        out.write("use Win32::OLE::Const 'Microsoft Excel';                                                                         " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("# ------ usage ------                                                                                            " + ls);
        out.write("sub print_usage()                                                                                                " + ls);
        out.write("{                                                                                                                " + ls);
        out.write("    print STDERR \"Usage: savaViaExcel.pl  <Excel file> <filefilter> <output file> .\\n                       " + ls);
        out.write("                  execl_print.pl  c:\\book1.xls Apple LaserWriter II NT v47.0 c:\\output\\book1.ps \\n\";     " + ls);
        out.write("}                                                                                                                " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("$Win32::OLE::Warn = 3;                                # die on errors...                                         " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("if ($#ARGV != 2)                                                                                                 " + ls);
        out.write("{                                                                                                                " + ls);
        out.write("   print \"Too less arguments.\\n\";                                                                              " + ls);
        out.write("   print_usage();                                                                                                " + ls);
        out.write("   exit(1);                                                                                                      " + ls);
        out.write("}                                                                                                                " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("my $Excel = Win32::OLE->GetActiveObject('Excel.Application')                                                     " + ls);
        out.write("    || Win32::OLE->new('Excel.Application', 'Quit');  # get already active Excel                                 " + ls);
        out.write("                                                      # application or open new                                  " + ls);
        out.write("my $sFilterParameter = $ARGV[1];                                                                                                                 " + ls);
        out.write("my $sFilterName = xlHTML;                                                                                                                 " + ls);
        out.write("if ($sFilterParameter eq 'xlXMLSpreadsheet')                                                                                                                 " + ls);
        out.write("{                                                                                                                 " + ls);
        out.write("    $sFilterName = xlXMLSpreadsheet;                                                                                                                " + ls);
        out.write("}                                                                                                                 " + ls);
        out.write("elsif ($sFilterParameter eq 'xlHTML')                                                                                                                 " + ls);
        out.write("{                                                                                                                 " + ls);
        out.write("    $sFilterName = xlHTML;                                                                                                                 " + ls);
        out.write("}                                                                                                                 " + ls);
        out.write("else                                                                                                                 " + ls);
        out.write("{                                                                                                                 " + ls);
        out.write("    my $undefined;                                                                                                " + ls);
        out.write("    $sFilterName = $undefined;                                                                                                              " + ls);
        out.write("}                                                                                                                 " + ls);
        out.write("                                                                                                                 " + ls);
        out.write("my $Book = $Excel->Workbooks->Open( $ARGV[0] );                                                                  " + ls);
        out.write("$Excel->{DisplayAlerts} = 0;                                                                                     " + ls);
        out.write("$Book->saveAs($ARGV[2],                                                                                          " + ls);
        out.write("              $sFilterName,                                                                                   " + ls);
        out.write("              '',                                                                                                " + ls);
        out.write("              '',                                                                                                " + ls);
        out.write("              0,                                                                                                 " + ls);
        out.write("              0,                                                                                                 " + ls);
        out.write("              xlNoChange,                                                                                        " + ls);
        out.write("              xlLocalSessionChanges,                                                                             " + ls);
        out.write("              1);                                                                                                " + ls);
        out.write("# Close worksheets without store changes" + ls);
        out.write("# $Book->Close({SaveChanges => 0}); " + ls);
        out.write("$Excel->Quit();                                                                                                     " + ls);
        out.close();
        aList.add("perl");
        aList.add(sName);
        return aList;
    }

    ArrayList createPowerPointPrintHelper() throws IOException {
        String sTmpPath = utils.getUsersTempDir();
        String ls = System.getProperty("line.separator");
        String fs = System.getProperty("file.separator");
        String sPrintViaPowerPoint = "printViaPowerPoint.pl";
        ArrayList aList = this.searchLocalFile(sPrintViaPowerPoint);
        if (!aList.isEmpty()) {
            return aList;
        }
        String sName = sTmpPath + fs + sPrintViaPowerPoint;
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("No local found, create a script: " + sName);
        }
        File aFile = new File(sName);
        FileWriter out = new FileWriter(aFile.toString());
        out.write("eval 'exec perl -wS $0 $1 $2 '                                                                                         " + ls);
        out.write("   if 0;                                                                                                               " + ls);
        out.write("use strict;                                                                                                            " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("if ( $^O ne \"MSWin32\")                                                                                                 " + ls);
        out.write("{                                                                                                                      " + ls);
        out.write("   print \"Windows only.\\n\";                                                                                            " + ls);
        out.write("   print_usage();                                                                                                      " + ls);
        out.write("   exit(1);                                                                                                            " + ls);
        out.write("}                                                                                                                      " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("use Win32::OLE qw(in with);                                                                                            " + ls);
        out.write("use Win32::OLE::Const 'Microsoft PowerPoint';                                                                          " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("# ------ usage ------                                                                                                  " + ls);
        out.write("sub print_usage()                                                                                                      " + ls);
        out.write("{                                                                                                                      " + ls);
        out.write("    print STDERR \"Usage: powerpoint_print.pl  <PowerPoint file> <name of printer> <output file> .\\n                    " + ls);
        out.write("                  Please use the same string for the name of the printer as you can find \\n                            " + ls);
        out.write("                  under Start-Control Panel-Printer and Faxes  \\n                                                  " + ls);
        out.write("                  The name could look like the the following line: \\n                                                  " + ls);
        out.write("                  Apple LaserWriter II NT v47.0 \\n                                                                     " + ls);
        out.write("                  Sample command line: \\n                                                                              " + ls);
        out.write("                  powerpoint_print.pl  c:\\book.ppt Apple LaserWriter II NT v47.0 c:\\output\\book.ps \\n\";         " + ls);
        out.write("}                                                                                                                      " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("$Win32::OLE::Warn = 3;                                # die on errors...                                               " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("if ($#ARGV < 2)                                                                                                        " + ls);
        out.write("{                                                                                                                      " + ls);
        out.write("   print \"Too less arguments.\\n\";                                                                                      " + ls);
        out.write("   print_usage();                                                                                                      " + ls);
        out.write("   exit(1);                                                                                                            " + ls);
        out.write("}                                                                                                                      " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("my $PowerPoint = Win32::OLE->GetActiveObject('PowerPoint.Application')                                                 " + ls);
        out.write("    || Win32::OLE->new('PowerPoint.Application', 'Quit');  # get already active Excel                                  " + ls);
        out.write("                                                      # application or open new                                        " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("   $PowerPoint->{'Visible'} = 1;                                                                                       " + ls);
        out.write("   my $Presentation = $PowerPoint->Presentations->Add;                                                                 " + ls);
        out.write("   my $Presentation = $PowerPoint->Presentations->Open( $ARGV[0] );                                                    " + ls);
        out.write("# we can't change active printer in powerpoint                                                            " + ls);
        out.write("#   $Presentation->PrintOptions->{ActivePrinter} = $ARGV[1]; " + ls);
        out.write("   print \"Active printer is: \" . $Presentation->PrintOptions->{ActivePrinter} . \"\\n\"; " + ls);
        out.write("   $Presentation->PrintOptions->{PrintInBackground} = 0;                                                               " + ls);
        out.write("   # PrintColorType = 1 means print in color and PrintColorType = 2 means print in gray                                " + ls);
        out.write("   $Presentation->PrintOptions->{PrintColorType} = 1;                                                                  " + ls);
        out.write("                                                                                                                       " + ls);
        out.write("   $Presentation->PrintOut({PrintToFile => $ARGV[2]});                                                                 " + ls);
        out.write("   sleep 5;                                                                                                            " + ls);
        out.write("   print \"Presentation has been printed\\n\";                                                                            " + ls);
        out.write("my $sVersion = $Presentation->Application->Version();" + ls);
        out.write("   $PowerPoint->Quit(); " + ls);
        out.write("local *FILE;" + ls);
        out.write("if (open(FILE, \">$ENV{HOME}/msofficeloadtimes.txt\"))" + ls);
        out.write("{" + ls);
        out.write("   print FILE \"name=$ARGV[0]\\n\";" + ls);
        out.write("   print FILE \"PowerPointVersion=$sVersion\\n\";" + ls);
        out.write("   close(FILE);" + ls);
        out.write("}" + ls);
        out.close();
        aList.add("perl");
        aList.add(sName);
        return aList;
    }

    public String getOfficeType(String _sFilename) {
        File aFile = new File(_sFilename);
        if (!aFile.exists()) {
            GlobalLogWriter.get().println("couldn't find file " + _sFilename);
            return "";
        }
        RandomAccessFile aReader = null;
        String sOfficeType = "";
        try {
            aReader = new RandomAccessFile(aFile, "r");
            String aLine = "";
            while (aLine != null) {
                int nIdx;
                aLine = aReader.readLine();
                if (aLine == null || (aLine = aLine.trim()).length() < 2 || aLine.startsWith("#") || aLine.startsWith(";") || (nIdx = aLine.indexOf("mso-application")) <= 0) continue;
                if (aLine.indexOf("Word.Document") > 0) {
                    sOfficeType = "word";
                    continue;
                }
                if (aLine.indexOf("Excel") > 0) {
                    sOfficeType = "excel";
                    continue;
                }
                GlobalLogWriter.get().println("Unknown/unsupported data file: " + aLine);
            }
        }
        catch (FileNotFoundException fne) {
            System.out.println("couldn't open file " + _sFilename);
            System.out.println("Message: " + fne.getMessage());
        }
        catch (IOException ie) {
            System.out.println("Exception while reading file " + _sFilename);
            System.out.println("Message: " + ie.getMessage());
        }
        try {
            aReader.close();
        }
        catch (IOException ie) {
            System.out.println("Couldn't close file " + _sFilename);
            System.out.println("Message: " + ie.getMessage());
        }
        return sOfficeType;
    }
}

