/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class LISTOutputter {
    FileWriter m_aOut;
    String m_sFilename;
    String ls;

    public static LISTOutputter create(String _sOutputPath, String _sFilename) {
        FileHelper.makeDirectories("", _sOutputPath);
        LISTOutputter a = new LISTOutputter();
        String fs = System.getProperty("file.separator");
        String sFilename = _sOutputPath + fs + _sFilename;
        try {
            File outputFile = new File(sFilename);
            a.m_aOut = new FileWriter(outputFile.toString());
            a.ls = System.getProperty("line.separator");
        }
        catch (IOException e) {
            e.printStackTrace();
            GlobalLogWriter.get().println("ERROR: Can't create LIST Outputter");
            return null;
        }
        a.m_sFilename = sFilename;
        return a;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public void createHeader() {
        try {
            this.m_aOut.write("# This file is automatically created by a convwatch run" + this.ls);
            this.m_aOut.write("# " + this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeValue(String _sValue) {
        try {
            this.m_aOut.write(_sValue + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.m_aOut.flush();
            this.m_aOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

