/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

class IniFile {
    String m_sFilename;
    ArrayList m_aList;
    boolean m_bListContainUnsavedChanges = false;

    public IniFile(String _sFilename) {
        this.m_sFilename = _sFilename;
        this.m_aList = this.loadLines();
    }

    ArrayList loadLines() {
        File aFile = new File(this.m_sFilename);
        ArrayList<String> aLines = new ArrayList<String>();
        if (!aFile.exists()) {
            GlobalLogWriter.get().println("couldn't find file " + this.m_sFilename);
            return aLines;
        }
        RandomAccessFile aReader = null;
        try {
            aReader = new RandomAccessFile(aFile, "r");
            String aLine = "";
            while (aLine != null) {
                aLine = aReader.readLine();
                if (aLine == null) continue;
                aLines.add(aLine);
            }
        }
        catch (FileNotFoundException fne) {
            GlobalLogWriter.get().println("couldn't open file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + fne.getMessage());
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Exception occurs while reading from file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
        try {
            aReader.close();
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Couldn't close file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
        return aLines;
    }

    public boolean is() {
        return this.m_aList.size() > 1;
    }

    boolean isRemark(String _sLine) {
        return _sLine.length() < 2 || _sLine.startsWith("#") || _sLine.startsWith(";");
    }

    String getItem(int i) {
        return (String)this.m_aList.get(i);
    }

    String buildSectionName(String _sSectionName) {
        String sFindSection = "[" + _sSectionName + "]";
        return sFindSection;
    }

    String toLowerIfNeed(String _sName) {
        return _sName.toLowerCase();
    }

    int findSection(String _sSection) {
        String sFindSection = this.toLowerIfNeed(this.buildSectionName(_sSection));
        for (int i = 0; i < this.m_aList.size(); ++i) {
            String sLine = this.toLowerIfNeed(this.getItem(i).trim());
            if (this.isRemark(sLine)) continue;
            if (sFindSection.equals("[]")) {
                return i - 1;
            }
            if (!sLine.startsWith(sFindSection)) continue;
            return i;
        }
        return -1;
    }

    int findKey(String _sSection, String _sKey) {
        int i = this.findSection(_sSection);
        if (i == -1) {
            return -1;
        }
        return this.findKeyFromKnownSection(i, _sKey);
    }

    int findKeyFromKnownSection(int _nSectionIndex, String _sKey) {
        _sKey = this.toLowerIfNeed(_sKey);
        for (int j = _nSectionIndex + 1; j < this.m_aList.size(); ++j) {
            String sKey;
            String sLine = this.getItem(j).trim();
            if (this.isRemark(sLine)) continue;
            if (sLine.startsWith("[")) break;
            int nEqual = sLine.indexOf("=");
            if (nEqual < 0 || !(sKey = this.toLowerIfNeed(sLine.substring(0, nEqual).trim())).equals(_sKey)) continue;
            return j;
        }
        return -1;
    }

    int findLastKnownKeyIndex(int _nSectionIndex, String _sKey) {
        int i;
        _sKey = this.toLowerIfNeed(_sKey);
        for (int j = i = _nSectionIndex + 1; j < this.m_aList.size(); ++j) {
            String sKey;
            String sLine = this.getItem(j).trim();
            if (this.isRemark(sLine)) continue;
            if (sLine.startsWith("[")) {
                return j;
            }
            int nEqual = sLine.indexOf("=");
            if (nEqual < 0 || !(sKey = this.toLowerIfNeed(sLine.substring(0, nEqual).trim())).equals(_sKey)) continue;
            return j;
        }
        return i;
    }

    String getValue(int _nIndex) {
        String sLine = this.getItem(_nIndex).trim();
        if (this.isRemark(sLine)) {
            return "";
        }
        int nEqual = sLine.indexOf("=");
        if (nEqual >= 0) {
            String sKey = sLine.substring(0, nEqual).trim();
            String sValue = sLine.substring(nEqual + 1).trim();
            return sValue;
        }
        return "";
    }

    public String getValue(String _sSection, String _sKey) {
        String sValue = "";
        int i = this.findKey(_sSection, _sKey);
        if (i == -1) {
            return "";
        }
        sValue = this.getValue(i);
        return sValue;
    }

    public void store() {
        if (!this.m_bListContainUnsavedChanges) {
            return;
        }
        File aFile = new File(this.m_sFilename);
        if (aFile.exists()) {
            aFile.delete();
            if (aFile.exists()) {
                GlobalLogWriter.get().println("Couldn't delete the file " + this.m_sFilename);
                return;
            }
        }
        try {
            RandomAccessFile aWriter = new RandomAccessFile(aFile, "rw");
            for (int i = 0; i < this.m_aList.size(); ++i) {
                String sLine = this.getItem(i);
                aWriter.writeBytes(sLine);
                aWriter.writeByte(10);
            }
            aWriter.close();
        }
        catch (FileNotFoundException fne) {
            GlobalLogWriter.get().println("couldn't open file for writing " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + fne.getMessage());
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Exception occurs while writing to file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
    }

    public void insertValue(String _sSection, String _sKey, String _sValue) {
        int i = this.findSection(_sSection);
        if (i == -1) {
            String sFindSection = this.buildSectionName(_sSection);
            this.m_aList.add(sFindSection);
            String sKeyValuePair = _sKey + "=" + _sValue;
            this.m_aList.add(sKeyValuePair);
            this.m_bListContainUnsavedChanges = true;
            return;
        }
        int j = this.findKeyFromKnownSection(i, _sKey);
        if (j == -1) {
            j = this.findLastKnownKeyIndex(i, _sKey);
            String sKeyValuePair = _sKey + "=" + _sValue;
            this.m_aList.add(j, sKeyValuePair);
            this.m_bListContainUnsavedChanges = true;
            return;
        }
        String sKeyValuePair = _sKey + "=" + _sValue;
        this.m_aList.set(j, sKeyValuePair);
        this.m_bListContainUnsavedChanges = true;
    }

    public static void main(String[] args) {
        IniFile aIniFile = new IniFile("/tmp/inifile");
        String sValue = aIniFile.getValue("Section", "Key");
        aIniFile.insertValue("Section", "Key2", "a new value in a existing section");
        aIniFile.insertValue("Section", "Key", "replaced value");
        aIniFile.insertValue("New Section", "Key", "a new key value pair");
        String sValue2 = aIniFile.getValue("Section2", "Key");
        aIniFile.store();
    }
}

