/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.StatusHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class INIOutputter {
    FileWriter m_aOut;
    String m_sFilename;
    String m_sNamePrefix;
    String ls;

    public static INIOutputter create(String _sOutputPath, String _sHTMLFilename, String _sNamePrefix, String _sTitle) {
        FileHelper.makeDirectories("", _sOutputPath);
        INIOutputter a = new INIOutputter();
        String fs = System.getProperty("file.separator");
        String sFilename = _sOutputPath + fs + _sHTMLFilename;
        try {
            File outputFile = new File(sFilename);
            a.m_aOut = new FileWriter(outputFile.toString());
            a.ls = System.getProperty("line.separator");
        }
        catch (IOException e) {
            e.printStackTrace();
            GlobalLogWriter.get().println("ERROR: Can't create INI Outputter");
            return null;
        }
        a.m_sFilename = sFilename;
        a.m_sNamePrefix = _sNamePrefix;
        return a;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public void createHeader() {
        try {
            this.m_aOut.write("; This file is automatically created by a convwatch run" + this.ls);
            this.m_aOut.write("; " + this.ls);
            this.m_aOut.write("; If you see this file in a browser you may have forgotten to set the follows in the property file" + this.ls);
            this.m_aOut.write("; DOC_COMPARATOR_HTML_OUTPUT_PREFIX=http://lla-1.germany/gfxcmp/cw.php?inifile=" + this.ls);
            this.m_aOut.write("; Please check the documentation if you got confused." + this.ls);
            this.m_aOut.write("; " + this.ls);
            this.m_aOut.write("; " + this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeSection(String _sSectionName) {
        try {
            this.m_aOut.write("[" + _sSectionName + "]" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeValue(String _sName, String _sValue) {
        try {
            this.m_aOut.write(_sName + "=" + _sValue + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startSection(int _nNumber) {
        this.writeSection("page" + String.valueOf(_nNumber));
    }

    public void close() {
        try {
            this.m_aOut.flush();
            this.m_aOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkLine(StatusHelper _aStatus, boolean _bCurrentResult) {
        try {
            this.m_aOut.write("oldgfx=" + _aStatus.m_sOldGfx + this.ls);
            this.m_aOut.write("newgfx=" + _aStatus.m_sNewGfx + this.ls);
            this.m_aOut.write("diffgfx=" + _aStatus.m_sDiffGfx + this.ls);
            String sPercent = String.valueOf(_aStatus.nPercent) + "%";
            if (_aStatus.nPercent > 0 && _aStatus.nPercent < 5) {
                sPercent = sPercent + " (less 5% is ok)";
            }
            this.m_aOut.write("percent=" + sPercent + this.ls);
            if (_aStatus.m_sDiff_BM_Gfx == null) {
                this.m_aOut.write("BM=false" + this.ls);
            } else {
                this.m_aOut.write("BM=true" + this.ls);
                this.m_aOut.write("old_BM_gfx=" + _aStatus.m_sOld_BM_Gfx + this.ls);
                this.m_aOut.write("new_BM_gfx=" + _aStatus.m_sNew_BM_Gfx + this.ls);
                this.m_aOut.write("diff_BM_gfx=" + _aStatus.m_sDiff_BM_Gfx + this.ls);
                String sPercent2 = String.valueOf(_aStatus.nPercent2) + "%";
                if (_aStatus.nPercent2 > 0 && _aStatus.nPercent2 < 5) {
                    sPercent2 = sPercent2 + " (less 5% is ok)";
                }
                this.m_aOut.write("percent2=" + sPercent2 + this.ls);
            }
            this.writeResult(_bCurrentResult);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void writeResult(boolean _bCurrentResult) throws IOException {
        if (_bCurrentResult) {
            this.m_aOut.write("result=YES" + this.ls);
        } else {
            this.m_aOut.write("result=NO" + this.ls);
        }
    }

    public void checkDiffDiffLine(StatusHelper _aStatus, boolean _bCurrentResult) {
        try {
            this.m_aOut.write("oldgfx=" + _aStatus.m_sOldGfx + this.ls);
            this.m_aOut.write("newgfx=" + _aStatus.m_sNewGfx + this.ls);
            this.m_aOut.write("diffgfx=" + _aStatus.m_sDiffGfx + this.ls);
            String sPercent = String.valueOf(_aStatus.nPercent) + "%";
            this.m_aOut.write("percent=" + sPercent + this.ls);
            this.writeResult(_bCurrentResult);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

