/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.StatusHelper;
import helper.OSHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class HTMLOutputter {
    FileWriter m_aOut;
    String m_sFilename;
    String m_sNamePrefix;
    String ls;
    static final String TEST_TABLETITLE = "Test";
    static final String VISUAL_STATUS_TABLETITLE = "Visual status";
    static final String VISUAL_STATUS_MESSAGE_TABLETITLE = "Message";
    static final String FIRSTGFX_TABLETITLE = "Original print file as jpeg";
    static final String SECONDGFX_TABLETITLE = "New print file as jpeg";
    static final String DIFFER_TABLETITLE = "Difference file";
    static final String STATUS_TABLETITLE = "Status";
    static final String PIXELDIFF_TABLETITLE = "Pixel difference in %";
    static final String PIXELDIFF_BM_TABLETITLE = "P.diff. in % after remove border";
    static final String DIFFER_BM_TABLETITLE = "Diff file (RB)";
    static final String OK_TABLETITLE = "OK?";

    HTMLOutputter() {
    }

    public static HTMLOutputter create(String _sOutputPath, String _sHTMLFilename, String _sNamePrefix, String _sTitle) {
        FileHelper.makeDirectories("", _sOutputPath);
        HTMLOutputter a = new HTMLOutputter();
        String fs = System.getProperty("file.separator");
        String sFilename = _sOutputPath + fs + _sHTMLFilename;
        try {
            File outputFile = new File(sFilename);
            a.m_aOut = new FileWriter(outputFile.toString());
            a.ls = System.getProperty("line.separator");
        }
        catch (IOException e) {
            e.printStackTrace();
            GlobalLogWriter.get().println("ERROR: Can't create HTML Outputter");
            return null;
        }
        a.m_sFilename = sFilename;
        a.m_sNamePrefix = _sNamePrefix;
        return a;
    }

    public String getFilename() {
        return this.m_sFilename;
    }

    public void header(String _sTitle) {
        try {
            this.m_aOut.write("<html>" + this.ls);
            this.m_aOut.write("<head>" + this.ls);
            this.m_aOut.write("<title>" + _sTitle + "</title>" + this.ls);
            this.m_aOut.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"/gfxcmp_ui/xmloff.css\" media=\"screen\" />" + this.ls);
            this.m_aOut.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"/gfxcmp_ui/style.css\" media=\"screen\" />" + this.ls);
            this.m_aOut.write("</head>" + this.ls);
            this.m_aOut.write("<body bgcolor=white>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void indexSection(String _sOfficeInfo) {
        try {
            this.m_aOut.write("<h2>Results for " + _sOfficeInfo + "</h2>" + this.ls);
            this.m_aOut.write("<p>Legend:<br>");
            this.m_aOut.write(this.stronghtml(FIRSTGFX_TABLETITLE) + " contains the output printed via 'ghostscript' as a jpeg picture.<br>");
            this.m_aOut.write("<table class=\"infotable\">" + this.ls);
            this.m_aOut.write("<TR>");
            this.m_aOut.write(this.tableHeaderCell(TEST_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(TEST_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(VISUAL_STATUS_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(VISUAL_STATUS_MESSAGE_TABLETITLE));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String getHREF(String _sHREF, String _sPathInfo) {
        StringBuffer a = new StringBuffer();
        if (!OSHelper.isWindows()) {
            a.append("<A HREF=\"");
            a.append(_sHREF);
            a.append("\">");
            a.append(_sPathInfo);
            a.append("</A>");
        } else {
            a.append("<A HREF=\"");
            a.append(_sHREF);
            a.append("\">");
            a.append(_sPathInfo);
            a.append("</A>");
        }
        return a.toString();
    }

    String tableDataCell(String _sValue) {
        StringBuffer a = new StringBuffer();
        a.append("<TD>");
        a.append(_sValue);
        a.append("</TD>");
        return a.toString();
    }

    String tableHeaderCell(String _sValue) {
        StringBuffer a = new StringBuffer();
        a.append("<TH>");
        a.append(_sValue);
        a.append("</TH>");
        return a.toString();
    }

    public void indexLine(String _sHTMLFile, String _sHTMLName, String _sHTMLFile2, String _sHTMLName2, String _sStatusRunThrough, String _sStatusMessage) {
        try {
            this.m_aOut.write("<TR>");
            this.m_aOut.write(this.tableDataCell(this.getHREF(_sHTMLFile, _sHTMLName)));
            if (_sHTMLFile2.length() > 0) {
                this.m_aOut.write(this.tableDataCell(this.getHREF(_sHTMLFile2, _sHTMLName2)));
            } else {
                this.m_aOut.write(this.tableDataCell(""));
            }
            this.m_aOut.write(this.tableDataCell(_sStatusRunThrough));
            this.m_aOut.write(this.tableDataCell(_sStatusMessage));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.m_aOut.write("</TABLE>" + this.ls);
            this.m_aOut.write("</BODY></HTML>" + this.ls);
            this.m_aOut.flush();
            this.m_aOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String stronghtml(String _sValue) {
        StringBuffer a = new StringBuffer();
        a.append("<STRONG>");
        a.append(_sValue);
        a.append("</STRONG>");
        return a.toString();
    }

    public void checkSection(String _sDocumentName) {
        try {
            this.m_aOut.write("<H2>Results for the document " + _sDocumentName + "</H2>" + this.ls);
            this.m_aOut.write("<p>Legend:<br>");
            this.m_aOut.write(this.stronghtml(FIRSTGFX_TABLETITLE) + " contains the output printed via 'ghostscript' as a jpeg picture.<br>");
            this.m_aOut.write(this.stronghtml(SECONDGFX_TABLETITLE) + " contains the same document opened within OpenOffice.org also printed via ghostscript as jpeg.<br>");
            this.m_aOut.write(this.stronghtml(DIFFER_TABLETITLE) + " is build via composite from original and new picture. The result should be a whole black picture, if there are no differences.<br>At the moment " + this.stronghtml(STATUS_TABLETITLE) + " is only ok, if the difference file contains only one color (black).</p>");
            this.m_aOut.write(this.stronghtml(DIFFER_BM_TABLETITLE) + " is build via composite from original and new picture after the border of both pictures are removed, so differences based on center problems may solved here");
            this.m_aOut.write("</p>");
            this.m_aOut.write("<p>Some words about the percentage value<br>");
            this.m_aOut.write("If a character is on the original page (a) and on the new page this character is moved to an other position only (b) , this means the difference is 100%.<br>");
            this.m_aOut.write("If character (b) is also bigger than character (a) the percentage is grow over the 100% mark.<br>");
            this.m_aOut.write("This tool count only the pixels which are differ to it's background color. It makes no sense to count all pixels, or the difference percentage will most the time in a very low percentage range.");
            this.m_aOut.write("</p>");
            this.m_aOut.write("<table class=\"infotable\">" + this.ls);
            this.m_aOut.write("<TR>" + this.ls);
            this.m_aOut.write(this.tableHeaderCell(FIRSTGFX_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(SECONDGFX_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(DIFFER_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(PIXELDIFF_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(DIFFER_BM_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(PIXELDIFF_BM_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(OK_TABLETITLE));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkLine(StatusHelper _aStatus, boolean _bCurrentResult) {
        try {
            this.m_aOut.write("<TR>" + this.ls);
            String sLink = this.getHREF(FileHelper.getBasename(_aStatus.m_sOldGfx), FileHelper.getBasename(_aStatus.m_sOldGfx));
            this.m_aOut.write(this.tableDataCell(sLink));
            sLink = this.getHREF(FileHelper.getBasename(_aStatus.m_sNewGfx), FileHelper.getBasename(_aStatus.m_sNewGfx));
            this.m_aOut.write(this.tableDataCell(sLink));
            sLink = this.getHREF(FileHelper.getBasename(_aStatus.m_sDiffGfx), FileHelper.getBasename(_aStatus.m_sDiffGfx));
            this.m_aOut.write(this.tableDataCell(sLink));
            String sPercent = String.valueOf(_aStatus.nPercent) + "%";
            if (_aStatus.nPercent > 0 && _aStatus.nPercent < 5) {
                sPercent = sPercent + " (less 5% is ok)";
            }
            this.m_aOut.write(this.tableDataCell(sPercent));
            if (_aStatus.m_sDiff_BM_Gfx == null) {
                sLink = "No diffs, therefore no moves";
                this.m_aOut.write(this.tableDataCell(sLink));
                this.m_aOut.write(this.tableDataCell(""));
            } else {
                sLink = this.getHREF(FileHelper.getBasename(_aStatus.m_sDiff_BM_Gfx), FileHelper.getBasename(_aStatus.m_sDiff_BM_Gfx));
                this.m_aOut.write(this.tableDataCell(sLink));
                String sPercent2 = String.valueOf(_aStatus.nPercent2) + "%";
                if (_aStatus.nPercent2 > 0 && _aStatus.nPercent2 < 5) {
                    sPercent2 = sPercent2 + " (less 5% is ok)";
                }
                this.m_aOut.write(this.tableDataCell(sPercent2));
            }
            if (_bCurrentResult) {
                this.m_aOut.write(this.tableDataCell("YES"));
            } else {
                this.m_aOut.write(this.tableDataCell("NO"));
            }
            this.m_aOut.write("</TR>" + this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkDiffDiffSection(String _sDocumentName) {
        try {
            this.m_aOut.write("<H2>Results for the document " + _sDocumentName + "</H2>" + this.ls);
            this.m_aOut.write("<p>Legend:<br>");
            this.m_aOut.write("</p>");
            this.m_aOut.write("<table class=\"infotable\">" + this.ls);
            this.m_aOut.write("<TR>" + this.ls);
            this.m_aOut.write(this.tableHeaderCell("Source to actual difference"));
            this.m_aOut.write(this.tableHeaderCell("Actual difference"));
            this.m_aOut.write(this.tableHeaderCell(DIFFER_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(PIXELDIFF_TABLETITLE));
            this.m_aOut.write(this.tableHeaderCell(OK_TABLETITLE));
            this.m_aOut.write("</TR>" + this.ls);
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void checkDiffDiffLine(StatusHelper _aStatus, boolean _bCurrentResult) {
        try {
            this.m_aOut.write("<TR>" + this.ls);
            String sBasename = FileHelper.getBasename(this.m_sFilename);
            String sNew = sBasename.substring(this.m_sNamePrefix.length());
            String sLink = this.getHREF(sNew, sNew);
            this.m_aOut.write(this.tableDataCell(sLink));
            sLink = this.getHREF(FileHelper.getBasename(_aStatus.m_sNewGfx), FileHelper.getBasename(_aStatus.m_sNewGfx));
            this.m_aOut.write(this.tableDataCell(sLink));
            sLink = this.getHREF(FileHelper.getBasename(_aStatus.m_sDiffGfx), FileHelper.getBasename(_aStatus.m_sDiffGfx));
            this.m_aOut.write(this.tableDataCell(sLink));
            String sPercent = String.valueOf(_aStatus.nPercent) + "%";
            this.m_aOut.write(this.tableDataCell(sPercent));
            if (_bCurrentResult) {
                this.m_aOut.write(this.tableDataCell("YES"));
            } else {
                this.m_aOut.write(this.tableDataCell("NO"));
            }
            this.m_aOut.write("</TR>" + this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

