/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import convwatch.BuildID;
import convwatch.GlobalLogWriter;
import convwatch.PerformanceContainer;
import convwatch.TriState;
import java.io.File;
import lib.TestParameters;

public class GraphicalTestArguments {
    String m_sReferenceType = "OOo";
    String m_sTargetFrameName = "_blank";
    String m_sPrinterName = null;
    boolean m_bHidden = true;
    String m_sDefaultXMLFormatApplication = null;
    boolean m_bIncludeSubdirectories;
    TestParameters m_aCurrentParams;
    int m_nMaxPages = 0;
    String m_sOnlyPage = "";
    int m_nResolutionInDPI = 0;
    boolean m_bStoreFile = true;
    boolean m_bResuseOffice = false;
    boolean m_bDebugMode = false;
    String m_sLeaveOutNames = null;
    String m_sDistinct = null;
    boolean m_bCreateDefaultReference = false;
    private String m_sRefBuildID;
    String m_sImportFilterName = "";
    String m_sExportFilterName = "";
    String m_sOfficeProgram = "";
    String m_sHTMLOutputPrefix = "";
    TriState m_tWithBorderMove = TriState.UNSET;
    String m_sDocumentType = "";
    PerformanceContainer m_aPerformanceContainer = null;
    private String m_aInputFile;
    private String m_sDBInfoString;

    private GraphicalTestArguments() {
    }

    public GraphicalTestArguments(TestParameters param) {
        String sCreateDefault;
        String sDistinct;
        String sDBInfoString;
        String sREUSE_OFFICE;
        String sOfficeProgram;
        String sExportFilterName;
        String sImportFilterName;
        String sDefaultXMLFormatApp;
        String sPrinterName;
        this.m_aCurrentParams = param;
        String sReferenceType = (String)param.get("DOC_COMPARATOR_REFERENCE_CREATOR_TYPE");
        if (sReferenceType != null && sReferenceType.length() != 0) {
            this.setReferenceType(sReferenceType);
        }
        if ((sPrinterName = (String)param.get("DOC_COMPARATOR_PRINTER_NAME")) != null && sPrinterName.length() != 0) {
            this.setPrinterName(sPrinterName);
        }
        if ((sDefaultXMLFormatApp = (String)param.get("DOC_COMPARATOR_DEFAULT_XML_FORMAT_APP")) != null && sDefaultXMLFormatApp.length() != 0) {
            this.setDefaultXMLFormatApp(sDefaultXMLFormatApp);
        }
        this.m_bIncludeSubdirectories = true;
        String sRECURSIVE = (String)param.get("DOC_COMPARATOR_INCLUDE_SUBDIRS");
        if (sRECURSIVE == null) {
            sRECURSIVE = "true";
        }
        if (sRECURSIVE.toLowerCase().equals("no") || sRECURSIVE.toLowerCase().equals("false")) {
            this.m_bIncludeSubdirectories = false;
        }
        this.m_nMaxPages = param.getInt("DOC_COMPARATOR_PRINT_MAX_PAGE");
        this.m_sOnlyPage = (String)param.get("DOC_COMPARATOR_PRINT_ONLY_PAGE");
        this.m_nResolutionInDPI = param.getInt("DOC_COMPARATOR_GFX_OUTPUT_DPI_RESOLUTION");
        if (this.m_nResolutionInDPI == 0) {
            this.m_nResolutionInDPI = 212;
        }
        if ((sImportFilterName = (String)param.get("DOC_CONVERTER_IMPORT_FILTER_NAME")) != null && sImportFilterName.length() > 0) {
            this.m_sImportFilterName = sImportFilterName;
            if (sImportFilterName.toLowerCase().equals("help")) {
                GraphicalTestArguments.showInternalFilterName(sImportFilterName, this.getMultiServiceFactory());
                GlobalLogWriter.get().println("Must quit.");
            }
        }
        if ((sExportFilterName = (String)param.get("DOC_CONVERTER_EXPORT_FILTER_NAME")) != null && sExportFilterName.length() > 0) {
            this.m_sExportFilterName = sExportFilterName;
            if (sExportFilterName.toLowerCase().equals("help")) {
                GraphicalTestArguments.showInternalFilterName(sExportFilterName, this.getMultiServiceFactory());
                GlobalLogWriter.get().println("Must quit.");
            }
        }
        if ((sOfficeProgram = (String)param.get("DOC_CONVERTER_OFFICE_PROGRAM")) != null && sOfficeProgram.length() > 0) {
            this.m_sOfficeProgram = sOfficeProgram;
        }
        if ((sREUSE_OFFICE = (String)param.get("DOC_CONVERTER_REUSE_OFFICE")) == null) {
            sREUSE_OFFICE = "false";
        }
        this.m_bResuseOffice = sREUSE_OFFICE.toLowerCase().equals("yes") || sREUSE_OFFICE.toLowerCase().equals("true");
        String sHTMLOutputPrefix = (String)param.get("DOC_COMPARATOR_HTML_OUTPUT_PREFIX");
        this.m_sHTMLOutputPrefix = sHTMLOutputPrefix == null ? "" : sHTMLOutputPrefix;
        String sWithBorderMove = (String)param.get("DOC_COMPARATOR_GFXCMP_WITH_BORDERMOVE");
        if (sWithBorderMove == null) {
            sWithBorderMove = "";
            this.m_tWithBorderMove = TriState.FALSE;
        }
        this.m_tWithBorderMove = sWithBorderMove.toLowerCase().equals("yes") || sWithBorderMove.toLowerCase().equals("true") ? TriState.TRUE : (sWithBorderMove.toLowerCase().equals("no") || sWithBorderMove.toLowerCase().equals("false") ? TriState.FALSE : TriState.FALSE);
        String sLeaveOutNames = (String)param.get("DOC_COMPARATOR_LEAVE_OUT_FILES");
        if (sLeaveOutNames != null) {
            this.m_sLeaveOutNames = sLeaveOutNames;
        }
        if ((sDBInfoString = (String)param.get("DOC_COMPARATOR_DB_INFO_STRING")) != null) {
            this.m_sDBInfoString = sDBInfoString;
        }
        if ((sDistinct = (String)param.get("DISTINCT")) == null || sDistinct.length() == 0) {
            sDistinct = "";
        } else {
            this.m_sDistinct = sDistinct;
        }
        String sOfficeViewable = (String)param.get("OFFICE_VIEWABLE");
        if (sOfficeViewable != null) {
            if (sOfficeViewable.toLowerCase().equals("yes") || sOfficeViewable.toLowerCase().equals("true")) {
                this.setViewable();
            } else {
                this.setHidden();
            }
        }
        if ((sCreateDefault = (String)param.get("CREATE_DEFAULT_REFERENCE")) != null) {
            this.m_bCreateDefaultReference = sCreateDefault.toLowerCase().equals("yes") || sCreateDefault.toLowerCase().equals("true");
        }
    }

    public boolean checkIfUsableDocumentType(String _sName) {
        return !_sName.toLowerCase().endsWith(".jpg") && !_sName.toLowerCase().endsWith(".png") && !_sName.toLowerCase().endsWith(".gif") && !_sName.toLowerCase().endsWith(".bmp") && !_sName.toLowerCase().endsWith(".prn") && !_sName.toLowerCase().endsWith(".ps");
    }

    static void showInternalFilterName(String _sFilterName, XMultiServiceFactory _xMSF) {
        XNameAccess aNameAccess;
        if (_sFilterName.length() == 0) {
            return;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return;
        }
        Object aObj = null;
        try {
            aObj = _xMSF.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return;
        }
        if (aObj != null && (aNameAccess = UnoRuntime.queryInterface(XNameAccess.class, aObj)) != null && _sFilterName.toLowerCase().equals("help")) {
            GlobalLogWriter.get().println("Show all possible ElementNames from current version.");
            String[] aElementNames = aNameAccess.getElementNames();
            for (int i = 0; i < aElementNames.length; ++i) {
                GlobalLogWriter.get().println(aElementNames[i]);
            }
        }
    }

    public void setReferenceType(String _sType) {
        this.m_sReferenceType = _sType == null ? "OOo" : _sType;
    }

    public void setTargetFrameName(String _sTargetFrameName) {
        this.m_sTargetFrameName = _sTargetFrameName;
    }

    public void setPrinterName(String _sName) {
        this.m_sPrinterName = _sName;
    }

    public void setHidden() {
        this.m_bHidden = true;
    }

    public void setViewable() {
        this.m_bHidden = false;
    }

    public void setDefaultXMLFormatApp(String _sNameOfApp) {
        this.m_sDefaultXMLFormatApplication = _sNameOfApp;
    }

    public XMultiServiceFactory getMultiServiceFactory() {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)this.m_aCurrentParams.getMSF();
        if ((this.getReferenceType().toLowerCase().equals("pdf") || this.getReferenceType().toLowerCase().equals("ooo")) && xMSF == null) {
            GlobalLogWriter.get().println("ERROR! MultiServiceFactory not given.");
        }
        return xMSF;
    }

    public String getReferenceType() {
        return this.m_sReferenceType;
    }

    public String getTargetFrameName() {
        return this.m_sTargetFrameName;
    }

    public String getPrinterName() {
        return this.m_sPrinterName;
    }

    public boolean isHidden() {
        return this.m_bHidden;
    }

    public String getDefaultXMLFormatApp() {
        return this.m_sDefaultXMLFormatApplication;
    }

    public boolean includeSubDirectories() {
        return this.m_bIncludeSubdirectories;
    }

    public int getMaxPages() {
        return this.m_nMaxPages;
    }

    public String getOnlyPages() {
        if (this.m_sOnlyPage == null) {
            return "";
        }
        return this.m_sOnlyPage;
    }

    public boolean printAllPages() {
        return this.getMaxPages() <= 0 && this.getOnlyPages().length() == 0;
    }

    public int getResolutionInDPI() {
        return this.m_nResolutionInDPI;
    }

    public static void checkIfMSWindowsConformPath(String _sPath) {
        if (_sPath != null && _sPath.length() > 1 && _sPath.charAt(1) == ':' && _sPath.charAt(2) != '\\') {
            GlobalLogWriter.get().println("This is not a Microsoft Windows conform path: '" + _sPath + "' please fix.");
            System.exit(1);
        }
    }

    public String getInputPath() {
        String sInputPath = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_INPUT_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(sInputPath);
        return sInputPath;
    }

    public String getOutputPath() {
        String sOutputPath = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_OUTPUT_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(sOutputPath);
        return sOutputPath;
    }

    public String getReferencePath() {
        String sReferencePath = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_REFERENCE_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(sReferencePath);
        return sReferencePath;
    }

    public String getDiffPath() {
        String sDiffPath = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_DIFF_PATH");
        GraphicalTestArguments.checkIfMSWindowsConformPath(sDiffPath);
        return sDiffPath;
    }

    public boolean getOverwrite() {
        boolean bOverwrite = this.m_aCurrentParams.getBool("DOC_COMPARATOR_OVERWRITE_REFERENCE");
        return bOverwrite;
    }

    public String getReferenceInputPath() {
        String sReferenceInputPath = (String)this.m_aCurrentParams.get("DOC_COMPARATOR_REFERENCE_INPUT_PATH");
        return sReferenceInputPath;
    }

    public String getBuildID() {
        String sAPP = (String)this.m_aCurrentParams.get("AppExecutionCommand");
        String sBuildID = BuildID.getBuildID(sAPP);
        return sBuildID;
    }

    public boolean shouldOfficeStart() {
        String sNoOffice = (String)this.m_aCurrentParams.get("NoOffice");
        return sNoOffice == null || !sNoOffice.toLowerCase().startsWith("t") && !sNoOffice.toLowerCase().startsWith("y");
    }

    public void setRefBuildID(String _sRef) {
        this.m_sRefBuildID = _sRef;
    }

    public String getRefBuildID() {
        return this.m_sRefBuildID;
    }

    public void disallowStore() {
        this.m_bStoreFile = false;
    }

    public void allowStore() {
        this.m_bStoreFile = true;
    }

    public boolean isStoreAllowed() {
        return this.m_bStoreFile;
    }

    public boolean createDefaultReference() {
        return this.m_bCreateDefaultReference;
    }

    public void setImportFilterName(String _sImportFilterName) {
        this.m_sImportFilterName = _sImportFilterName;
    }

    public String getImportFilterName() {
        return this.m_sImportFilterName;
    }

    public void setExportFilterName(String _sExportFilterName) {
        this.m_sExportFilterName = _sExportFilterName;
    }

    public String getExportFilterName() {
        return this.m_sExportFilterName;
    }

    public void setOfficeProgram(String _sName) {
        this.m_sOfficeProgram = _sName;
    }

    public String getOfficeProgram() {
        return this.m_sOfficeProgram;
    }

    public boolean restartOffice() {
        return !this.m_bResuseOffice;
    }

    public String getHTMLOutputPrefix() {
        return this.m_sHTMLOutputPrefix;
    }

    public TriState getBorderMove() {
        return this.m_tWithBorderMove;
    }

    public void setBorderMove(TriState _tBorderMove) {
        this.m_tWithBorderMove = _tBorderMove;
    }

    public void setDocumentType(String _sName) {
        this.m_sDocumentType = _sName;
    }

    public String getDocumentType() {
        return this.m_sDocumentType;
    }

    public PerformanceContainer getPerformance() {
        if (this.m_aPerformanceContainer == null) {
            this.m_aPerformanceContainer = new PerformanceContainer();
        }
        return this.m_aPerformanceContainer;
    }

    public void setInputFile(String _sInputFile) {
        this.m_aInputFile = _sInputFile;
    }

    public String getInputFile() {
        return this.m_aInputFile;
    }

    public String getDBInfoString() {
        if (this.m_sDBInfoString != null && this.m_sDBInfoString.length() == 0) {
            return null;
        }
        return this.m_sDBInfoString;
    }

    public boolean cancelRequest() {
        File aCancelFile = null;
        String fs = System.getProperty("file.separator");
        String sTempPath = (String)this.m_aCurrentParams.get("TEMPPATH");
        if (sTempPath != null) {
            String sCancelFile;
            String sGDC_Dir = sTempPath;
            if (this.m_sDistinct.length() > 0) {
                sGDC_Dir = sGDC_Dir + fs + this.m_sDistinct;
            }
            if ((aCancelFile = new File(sCancelFile = sGDC_Dir + fs + "cancel_compare.txt")).exists()) {
                GlobalLogWriter.get().println("ATTENTION: Found file: '" + sCancelFile + "'.");
                GlobalLogWriter.get().println("User has canceled the program flow.");
                return true;
            }
        }
        return false;
    }
}

