/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ConvWatchCancelException;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.OfficePrint;
import convwatch.PRNCompare;
import helper.URLHelper;
import java.io.File;
import java.util.ArrayList;
import util.utils;

public class GfxCompare
extends EnhancedComplexTestCase {
    GraphicalTestArguments m_aArguments = null;

    @Override
    public String[] getTestMethodNames() {
        return new String[]{"gfxcompare"};
    }

    @Override
    protected Object[] mustInstalledSoftware() {
        ArrayList<String> aList = new ArrayList<String>();
        aList.add("composite -version");
        aList.add("identify -version");
        aList.add("gs -version");
        return aList.toArray();
    }

    public void gfxcompare() {
        GlobalLogWriter.set(log);
        this.checkEnvironment(this.mustInstalledSoftware());
        this.m_aArguments = this.getGraphicalTestArguments();
        String sFile1 = (String)param.get("FILE1");
        String sFile2 = (String)param.get("FILE2");
        this.compare(sFile1, sFile2);
    }

    String createJPEG(String _sFile, String _sAdditional) {
        File aFile;
        String sJPEGFile = "";
        if (_sFile.startsWith("file:///")) {
            _sFile = FileHelper.getSystemPathFromFileURL(_sFile);
        }
        if ((aFile = new File(_sFile)).exists()) {
            String sAbsFile = aFile.getAbsolutePath();
            if (!sAbsFile.equals(_sFile)) {
                _sFile = sAbsFile;
            }
        } else {
            GlobalLogWriter.get().println("File: '" + _sFile + "' doesn't exist.");
            return "";
        }
        String sFileDir = FileHelper.getPath(_sFile);
        String sBasename = FileHelper.getBasename(_sFile);
        String sNameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
        String fs = System.getProperty("file.separator");
        String sTmpDir = utils.getUsersTempDir();
        if (this.m_aArguments.getOutputPath() != null) {
            sTmpDir = this.m_aArguments.getOutputPath();
        }
        if (_sFile.toLowerCase().endsWith("ps") || _sFile.toLowerCase().endsWith("prn") || _sFile.toLowerCase().endsWith("pdf")) {
            String[] aList = PRNCompare.createJPEGFromPostscript(sTmpDir, sFileDir, sBasename, this.m_aArguments.getResolutionInDPI());
            sJPEGFile = aList[0];
        } else {
            if (_sFile.toLowerCase().endsWith("jpg") || _sFile.toLowerCase().endsWith("jpeg")) {
                return _sFile;
            }
            String sInputFile = sFileDir + fs + sBasename;
            String sInputURL = URLHelper.getFileURLFromSystemPath(sInputFile);
            String sOutputFile = sTmpDir + fs + sBasename;
            String sOutputURL = URLHelper.getFileURLFromSystemPath(sOutputFile);
            String sPrintFile = sTmpDir + fs + sNameNoSuffix + _sAdditional + ".ps";
            String sPrintFileURL = URLHelper.getFileURLFromSystemPath(sPrintFile);
            try {
                OfficePrint.printToFile(this.m_aArguments, sInputURL, sOutputURL, sPrintFileURL);
                sJPEGFile = this.createJPEG(sPrintFile, _sAdditional);
            }
            catch (ConvWatchCancelException e) {
                GlobalLogWriter.get().println("Exception caught, can't create:" + sPrintFileURL);
            }
        }
        return sJPEGFile;
    }

    public String compare(String _sFile1, String _sFile2) {
        String sJPEGFile1 = this.createJPEG(_sFile1, "-1");
        String sJPEGFile2 = this.createJPEG(_sFile2, "-2");
        if (sJPEGFile1.length() > 0 && sJPEGFile2.length() > 0) {
            String sDiffFile = PRNCompare.compareJPEGs(sJPEGFile1, sJPEGFile2);
            if (sDiffFile.length() > 0) {
                GlobalLogWriter.get().println("Difference created: " + sDiffFile);
            }
            return sDiffFile;
        }
        return "";
    }
}

