/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import helper.OSHelper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import util.utils;

public class FileHelper {
    private static boolean m_bDebugTextShown = false;

    public FileHelper() {
        String sOSName = System.getProperty("os.name");
        String sOSArch = System.getProperty("os.arch");
        String sOSVersion = System.getProperty("os.version");
        GlobalLogWriter.get().println(sOSName);
        GlobalLogWriter.get().println(sOSArch);
        GlobalLogWriter.get().println(sOSVersion);
    }

    public static void MessageBox(String _sStr) {
        String sVersion = System.getProperty("java.version");
        String sOSName = System.getProperty("os.name");
        JOptionPane.showMessageDialog(null, _sStr, sVersion + " " + sOSName + " Hello World Debugger", 1);
    }

    public static boolean exists(String _sFile) {
        if (_sFile == null) {
            return false;
        }
        File aFile = new File(_sFile);
        return aFile.exists();
    }

    public static boolean isDir(String _sDir) {
        if (_sDir == null) {
            return false;
        }
        try {
            File aFile = new File(_sDir);
            if (aFile.exists() && aFile.isDirectory()) {
                return true;
            }
        }
        catch (NullPointerException e) {
            GlobalLogWriter.get().println("Exception caught. FileHelper.isDir('" + _sDir + "')");
            e.printStackTrace();
        }
        return false;
    }

    public static String getBasename(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        String fs = System.getProperty("file.separator");
        int nIdx = _sFilename.lastIndexOf(fs);
        if (nIdx > 0) {
            return _sFilename.substring(nIdx + 1);
        }
        return _sFilename;
    }

    public static String getNameNoSuffix(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        int nIdx = _sFilename.lastIndexOf(".");
        if (nIdx > 0) {
            return _sFilename.substring(0, nIdx);
        }
        return _sFilename;
    }

    public static String getSuffix(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        int nIdx = _sFilename.lastIndexOf(".");
        if (nIdx > 0) {
            return _sFilename.substring(nIdx);
        }
        return "";
    }

    public static String getPath(String _sFilename) {
        if (_sFilename == null) {
            return "";
        }
        String fs = System.getProperty("file.separator");
        int nIdx = _sFilename.lastIndexOf(fs);
        if (nIdx > 0) {
            return _sFilename.substring(0, nIdx);
        }
        return "";
    }

    public static void makeDirectories(String first, String path) {
        FileHelper.makeDirectories(first, path, "0777");
    }

    public static void makeDirectories(String first, String path, String _sMode) {
        String fs = System.getProperty("file.separator");
        if (path.startsWith(fs + fs)) {
            int n = path.indexOf(fs, 2);
            n = path.indexOf(fs, n + 1);
            first = path.substring(0, n);
            path = path.substring(n + 1);
        }
        String already_done = null;
        StringTokenizer path_tokenizer = new StringTokenizer(path, fs, false);
        already_done = first;
        while (path_tokenizer.hasMoreTokens()) {
            String part = path_tokenizer.nextToken();
            File new_dir = new File(already_done + File.separatorChar + part);
            already_done = new_dir.toString();
            new_dir.mkdirs();
            if (!OSHelper.isUnix() || _sMode.length() <= 0) continue;
            try {
                FileHelper.chmod(new_dir, _sMode);
            }
            catch (IOException e) {
                GlobalLogWriter.get().println("Exception caught. FileHelper.makeDirectories('" + new_dir.getAbsolutePath() + "')");
            }
        }
    }

    public static void chmod(File file, String mode) throws IOException {
        Runtime.getRuntime().exec(new String[]{"chmod", mode, file.getAbsolutePath()});
    }

    public static String removeFirstDirectorysAndBasenameFrom(String _sName, String _sRemovePath) {
        String fs = System.getProperty("file.separator");
        String sBasename = FileHelper.getBasename(_sName);
        String sSubDirs = "";
        if (_sName.startsWith(_sRemovePath)) {
            int nBasenameIndex;
            int nRemovePathIndex = _sRemovePath.length();
            if (!_sRemovePath.endsWith(fs)) {
                ++nRemovePathIndex;
            }
            if (nRemovePathIndex < (nBasenameIndex = _sName.length() - sBasename.length() - 1)) {
                sSubDirs = _sName.substring(nRemovePathIndex, nBasenameIndex);
            }
        } else {
            sSubDirs = FileHelper.getPath(_sName);
            if (sSubDirs.startsWith(fs)) {
                sSubDirs = sSubDirs.substring(1);
            }
        }
        return sSubDirs;
    }

    public static void test_removeFirstDirectorysAndBasenameFrom() {
        String a = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/a/b/c");
        String b = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/a/b/c/");
        String c = FileHelper.removeFirstDirectorysAndBasenameFrom("/a/b/c/d/e/f.g", "/b/c");
    }

    public static String getSystemPathFromFileURL(String _sFileURL) {
        String sSystemFile = null;
        if (_sFileURL.startsWith("file:///")) {
            sSystemFile = OSHelper.isWindows() ? _sFileURL.substring(8) : _sFileURL.substring(7);
        } else if (_sFileURL.startsWith("file://")) {
            sSystemFile = _sFileURL.substring(5);
        }
        String fs = System.getProperty("file.separator");
        if (!fs.equals("/")) {
            sSystemFile = sSystemFile.replace('/', fs.toCharArray()[0]);
        }
        return sSystemFile;
    }

    public static boolean isDebugEnabled() {
        boolean bDebug = false;
        String sTmpPath = utils.getUsersTempDir();
        String fs = System.getProperty("file.separator");
        String sName = sTmpPath + fs + "DOC_COMPARATOR_DEBUG";
        File aFile = new File(sName);
        if (aFile.exists()) {
            if (!m_bDebugTextShown) {
                GlobalLogWriter.get().println("Found file: " + sName);
                GlobalLogWriter.get().println("Activate debug mode.");
                GlobalLogWriter.get().println("If debug mode is no longer necessary, remove the above file.");
                m_bDebugTextShown = true;
            }
            bDebug = true;
        }
        return bDebug;
    }

    public static void copy(String _sSource, String _sDestination) {
        try {
            int c;
            File inputFile = new File(_sSource);
            File outputFile = new File(_sDestination);
            FileReader in = new FileReader(inputFile);
            FileWriter out = new FileWriter(outputFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            GlobalLogWriter.get().println("Exception caught. FileHelper.copy('" + _sSource + ", " + _sDestination + "')");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
        }
    }

    public static FileFilter getFileFilter() {
        FileFilter aFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.getName().startsWith("~$")) {
                    return false;
                }
                if (pathname.getName().endsWith(".prn")) {
                    return false;
                }
                if (pathname.getName().endsWith(".zip")) {
                    return false;
                }
                return !pathname.getName().endsWith("_");
            }
        };
        return aFileFilter;
    }
}

