/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.DateHelper;
import convwatch.GlobalLogWriter;
import convwatch.MySQLThread;
import convwatch.ValueNotFoundException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public class DBHelper {
    private static String m_sDBServerName;
    private static String m_sDBName;
    private static String m_sDBUser;
    private static String m_sDBPasswd;
    public static final String sComma = ",";
    public static final String sEqual = "=";
    public static final String sAND = " AND ";

    public void SQLinsertValues(Connection _aCon, String _sTableName, String value_names, String values) {
        if (_aCon == null) {
            GlobalLogWriter.get().println("DB: ERROR: in SQLinsertValues, connection not established.");
            return;
        }
        StringBuffer aInsertStr = new StringBuffer();
        aInsertStr.append("INSERT INTO ").append(_sTableName);
        aInsertStr.append(" (").append(value_names).append(")");
        aInsertStr.append(" VALUES (").append(values).append(")");
        this.ExecSQL(_aCon, aInsertStr.toString());
    }

    public void SQLupdateValue(Connection _aCon, String _sTableName, String _sSet, String _sWhere) {
        if (_aCon == null) {
            GlobalLogWriter.get().println("DB: ERROR: in SQLinsertValues, connection not established.");
            return;
        }
        StringBuffer aUpdateStr = new StringBuffer();
        aUpdateStr.append("UPDATE ").append(_sTableName).append(" SET ").append(_sSet).append(" WHERE ").append(_sWhere);
        this.ExecSQL(_aCon, aUpdateStr.toString());
    }

    protected synchronized void fillDBConnection(String _sInfo) {
        StringTokenizer aTokenizer = new StringTokenizer(_sInfo, sComma, false);
        while (aTokenizer.hasMoreTokens()) {
            String sPart = aTokenizer.nextToken();
            if (sPart.startsWith("db:")) {
                m_sDBName = sPart.substring(3);
                continue;
            }
            if (sPart.startsWith("user:")) {
                m_sDBUser = sPart.substring(5);
                continue;
            }
            if (sPart.startsWith("passwd:")) {
                m_sDBPasswd = sPart.substring(7);
                continue;
            }
            if (!sPart.startsWith("server:")) continue;
            m_sDBServerName = sPart.substring(7);
        }
    }

    public static Connection getMySQLConnection() throws SQLException {
        try {
            Class.forName("org.gjt.mm.mysql.Driver");
            String sConnection = "jdbc:mysql://" + m_sDBServerName + ":3306/" + m_sDBName;
            Connection mysql = DriverManager.getConnection(sConnection, m_sDBUser, m_sDBPasswd);
            return mysql;
        }
        catch (ClassNotFoundException e) {
            GlobalLogWriter.get().println("DB: Class not found exception caught: " + e.getMessage());
            GlobalLogWriter.get().println("DB: Maybe mysql.jar is not added to the classpath.");
            return null;
        }
    }

    protected synchronized void ExecSQL(Connection _aCon, String _sSQL) {
        MySQLThread aSQLThread = new MySQLThread(_aCon, _sSQL);
        aSQLThread.start();
    }

    public int QueryIntFromSQL(Connection _aCon, String _sSQL, String _sColumnName) throws ValueNotFoundException {
        Statement oStmt = null;
        Object oCon = null;
        int nValue = 0;
        try {
            oStmt = _aCon.createStatement();
            ResultSet oResult = oStmt.executeQuery(_sSQL);
            oResult.next();
            try {
                nValue = _sColumnName.length() == 0 ? oResult.getInt(1) : oResult.getInt(_sColumnName);
            }
            catch (SQLException e) {
                String sError = e.getMessage();
                GlobalLogWriter.get().println("DB: Original SQL error: " + sError);
                throw new ValueNotFoundException("Cant execute SQL: " + _sSQL);
            }
        }
        catch (SQLException e) {
            String sError = e.getMessage();
            GlobalLogWriter.get().println("DB: Couldn't execute sql string " + _sSQL + "\n" + sError);
        }
        return nValue;
    }

    public String Quote(String _sToQuote) {
        String ts = "'";
        String ds = "\"";
        int nQuote = _sToQuote.indexOf(ts);
        if (nQuote >= 0) {
            return ds + _sToQuote + ds;
        }
        return ts + _sToQuote + ts;
    }

    public static String today() {
        return DateHelper.getDateString("yyyy-MM-dd");
    }
}

