/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DB;
import convwatch.DirectoryHelper;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalDifferenceCheck;
import convwatch.GraphicalTestArguments;
import convwatch.HTMLOutputter;
import convwatch.LISTOutputter;
import helper.OSHelper;
import helper.OfficeProvider;
import helper.OfficeWatcher;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class ConvWatchStarter
extends EnhancedComplexTestCase {
    String m_sInputPath = "";
    String m_sReferencePath = "";
    String m_sOutputPath = "";
    String m_sDiffPath = null;

    @Override
    public String[] getTestMethodNames() {
        return new String[]{"compareGraphicalDiffs"};
    }

    private void initMember() {
        String sDIFF;
        String sINPATH = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
        boolean bQuit = false;
        if (sINPATH == null || sINPATH.length() == 0) {
            log.println("Please set input path (path to documents) DOC_COMPARATOR_INPUT_PATH=path.");
            bQuit = true;
        } else {
            log.println("found DOC_COMPARATOR_INPUT_PATH " + sINPATH);
            this.m_sInputPath = sINPATH;
        }
        String sREF = (String)param.get("DOC_COMPARATOR_REFERENCE_PATH");
        if (sREF == null || sREF.length() == 0) {
            log.println("Assumtion, reference directory and input directory are the same.");
            this.m_sReferencePath = this.m_sInputPath;
        } else {
            log.println("found DOC_COMPARATOR_REFERENCE_PATH " + sREF);
            this.m_sReferencePath = sREF;
        }
        String sOUT = (String)param.get("DOC_COMPARATOR_OUTPUT_PATH");
        if (sOUT == null || sOUT.length() == 0) {
            log.println("Please set output path (path to a temp directory) DOC_COMPARATOR_OUTPUT_PATH=path.");
            bQuit = true;
        } else {
            log.println("found DOC_COMPARATOR_OUTPUT_PATH " + sOUT);
            this.m_sOutputPath = sOUT;
        }
        if (bQuit) {
            this.assure("Must quit", false);
        }
        if ((sDIFF = (String)param.get("DOC_COMPARATOR_DIFF_PATH")) != null && sDIFF.length() != 0) {
            log.println("found DOC_COMPARATOR_DIFF_PATH " + sDIFF);
            this.m_sDiffPath = sDIFF;
        }
        if (this.m_sInputPath.startsWith("file:") || this.m_sReferencePath.startsWith("file:") || this.m_sOutputPath.startsWith("file:")) {
            this.assure("We can't handle file: URL right, use system path instead.", false);
        }
    }

    @Override
    protected Object[] mustInstalledSoftware() {
        ArrayList<String> aList = new ArrayList<String>();
        if (!OSHelper.isWindows()) {
            aList.add("composite -version");
            aList.add("identify -version");
            aList.add("gs -version");
        } else {
            aList.add("composite.exe -version");
            aList.add("identify.exe -version");
            aList.add("gswin32c.exe -version");
        }
        return aList.toArray();
    }

    public void compareGraphicalDiffs() {
        GlobalLogWriter.set(log);
        String sDBConnection = (String)param.get("DB_CONNECTION_STRING");
        this.checkEnvironment(this.mustInstalledSoftware());
        GraphicalTestArguments aGTA = this.getGraphicalTestArguments();
        if (aGTA == null) {
            this.assure("Must quit", false);
        }
        if (aGTA.cancelRequest()) {
            return;
        }
        this.initMember();
        aGTA.allowStore();
        String sBuildID = aGTA.getBuildID();
        log.println("Current Office has buildid: " + sBuildID);
        String fs = System.getProperty("file.separator");
        String sHTMLName = "index.html";
        File aInputPathTest = new File(this.m_sInputPath);
        if (!aInputPathTest.isDirectory()) {
            int n = this.m_sInputPath.lastIndexOf(fs);
            sHTMLName = this.m_sInputPath.substring(n + 1);
            sHTMLName = sHTMLName + ".html";
        }
        HTMLOutputter HTMLoutput = HTMLOutputter.create(this.m_sOutputPath, sHTMLName, "", "");
        HTMLoutput.header(this.m_sOutputPath);
        HTMLoutput.indexSection(this.m_sOutputPath);
        LISTOutputter LISToutput = LISTOutputter.create(this.m_sOutputPath, "allfiles.txt");
        DB.init(aGTA.getDBInfoString() + "," + sDBConnection);
        File aInputPath = new File(this.m_sInputPath);
        if (aInputPath.isDirectory()) {
            FileFilter aFileFilter = FileHelper.getFileFilter();
            Object[] aList = DirectoryHelper.traverse(this.m_sInputPath, aFileFilter, aGTA.includeSubDirectories());
            if (aList.length == 0) {
                log.println("Nothing to do, there are no document files found.");
            } else {
                for (int i = 0; i < aList.length; ++i) {
                    String sEntry = (String)aList[i];
                    log.println("- next file is: ------------------------------");
                    log.println(sEntry);
                    String sNewSubDir = FileHelper.removeFirstDirectorysAndBasenameFrom(sEntry, this.m_sInputPath);
                    String sNewReferencePath = this.m_sReferencePath;
                    String sNewOutputPath = this.m_sOutputPath;
                    String sNewDiffPath = this.m_sDiffPath;
                    if (sNewSubDir.length() > 0) {
                        if (sNewReferencePath != null) {
                            sNewReferencePath = sNewReferencePath + fs + sNewSubDir;
                        }
                        sNewOutputPath = sNewOutputPath + fs + sNewSubDir;
                        if (sNewDiffPath != null) {
                            sNewDiffPath = sNewDiffPath + fs + sNewSubDir;
                        }
                    }
                    if (aGTA.checkIfUsableDocumentType(sEntry)) {
                        this.runGDCWithStatus(HTMLoutput, LISToutput, sEntry, sNewOutputPath, sNewReferencePath, sNewDiffPath, sNewSubDir);
                    }
                    if (!aGTA.cancelRequest()) {
                        continue;
                    }
                    break;
                }
            }
        } else if (aGTA.checkIfUsableDocumentType(this.m_sInputPath)) {
            this.runGDCWithStatus(HTMLoutput, LISToutput, this.m_sInputPath, this.m_sOutputPath, this.m_sReferencePath, this.m_sDiffPath, "");
        }
        LISToutput.close();
        HTMLoutput.close();
        log.println("The file '" + HTMLoutput.getFilename() + "' shows a html based status.");
        DB.writeHTMLFile(HTMLoutput.getFilename());
    }

    void runGDCWithStatus(HTMLOutputter _aHTMLoutput, LISTOutputter _aLISToutput, String _sInputFile, String _sOutputPath, String _sReferencePath, String _sDiffPath, String _sNewSubDir) {
        GraphicalTestArguments aGTA = this.getGraphicalTestArguments();
        OfficeProvider aProvider = null;
        if (aGTA.shouldOfficeStart()) {
            aGTA.getPerformance().startTime(3);
            aProvider = new OfficeProvider();
            XMultiServiceFactory xMSF = (XMultiServiceFactory)aProvider.getManager(param);
            param.put("ServiceFactory", xMSF);
            aGTA.getPerformance().stopTime(3);
            long nStartTime = aGTA.getPerformance().getTime(3);
            aGTA = this.getGraphicalTestArguments();
            aGTA.getPerformance().setTime(3, nStartTime);
        }
        GlobalLogWriter.get().println("Set office watcher");
        OfficeWatcher aWatcher = (OfficeWatcher)param.get("Watcher");
        GlobalLogWriter.get().setWatcher(aWatcher);
        String sStatusRunThrough = "";
        String sStatusMessage = "";
        try {
            DB.destination_start();
            GraphicalDifferenceCheck.checkOneFile(_sInputFile, _sOutputPath, _sReferencePath, _sDiffPath, aGTA);
            sStatusRunThrough = "PASSED, OK";
            DB.destination_finished();
        }
        catch (ConvWatchCancelException e) {
            this.assure(e.getMessage(), false, true);
            sStatusRunThrough = "CANCELLED, FAILED";
            sStatusMessage = e.getMessage();
            DB.destination_failed(sStatusRunThrough, sStatusMessage);
        }
        catch (ConvWatchException e) {
            this.assure(e.getMessage(), false, true);
            sStatusMessage = e.getMessage();
            sStatusRunThrough = "PASSED, FAILED";
            DB.destination_failed(sStatusRunThrough, sStatusMessage);
        }
        catch (DisposedException e) {
            this.assure(e.getMessage(), false, true);
            sStatusMessage = e.getMessage();
            sStatusRunThrough = "FAILED, FAILED";
            DB.destination_failed(sStatusRunThrough, sStatusMessage);
        }
        GlobalLogWriter.get().println("Watcher count is: " + aWatcher.getPing());
        if (aProvider != null) {
            aProvider.closeExistingOffice(param, true);
        }
        String fs = System.getProperty("file.separator");
        String sBasename = FileHelper.getBasename(_sInputFile);
        String sFilenameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
        String sListFile = _sNewSubDir.length() > 0 ? _sNewSubDir + fs + sFilenameNoSuffix + ".ini" : sFilenameNoSuffix + ".ini";
        _aLISToutput.writeValue(sListFile);
        String sHTMLPrefix = aGTA.getHTMLOutputPrefix();
        GlobalLogWriter.get().println("----------------------------------------------------------------------");
        GlobalLogWriter.get().println(" OutputPath: " + _sOutputPath);
        GlobalLogWriter.get().println("    NewPath: " + _sNewSubDir);
        GlobalLogWriter.get().println("----------------------------------------------------------------------");
        String sLink = sHTMLPrefix + _sOutputPath + fs + sFilenameNoSuffix + ".ini";
        String sLinkDD = sHTMLPrefix + _sOutputPath + fs + "DiffDiff_" + sFilenameNoSuffix + ".ini";
        String sLinkName = sFilenameNoSuffix;
        String sLinkDDName = sFilenameNoSuffix + " (DiffDiff)";
        if (_sDiffPath != null && _sDiffPath.length() > 0) {
            _aHTMLoutput.indexLine(sLinkDD, sLinkDDName, sLink, sLinkName, sStatusRunThrough, sStatusMessage);
        } else {
            _aHTMLoutput.indexLine(sLink, sLinkName, "", "", sStatusRunThrough, sStatusMessage);
        }
    }
}

