/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import convwatch.IniFile;
import helper.OSHelper;
import java.io.File;
import java.util.Date;

public class BuildID {
    public static String getBuildID(String _sApp) {
        int nIdx;
        String sOfficePath = "";
        if (_sApp.startsWith("\"")) {
            nIdx = _sApp.indexOf("\"", 1);
            if (nIdx != -1) {
                sOfficePath = _sApp.substring(1, nIdx);
            }
        } else {
            nIdx = _sApp.indexOf(" ", 1);
            sOfficePath = nIdx == -1 ? _sApp : _sApp.substring(0, nIdx);
        }
        GlobalLogWriter.get().println("Office path: " + sOfficePath);
        String fs = System.getProperty("file.separator");
        String sBuildID = "";
        File aSOfficeFile = new File(sOfficePath);
        if (aSOfficeFile.exists()) {
            int nIdx2 = sOfficePath.lastIndexOf(fs);
            sBuildID = BuildID.getBuildIDFromBootstrap(sOfficePath = sOfficePath.substring(0, nIdx2));
            if (sBuildID.length() == 0) {
                sBuildID = BuildID.getBuildIDFromVersion(sOfficePath);
            }
        } else {
            GlobalLogWriter.get().println("soffice executable not found.");
        }
        boolean dummy = false;
        return sBuildID;
    }

    private static String getBuildIDFromBootstrap(String _sOfficePath) {
        String fs = System.getProperty("file.separator");
        String sBuildID = "";
        String sOfficePath = _sOfficePath;
        sOfficePath = OSHelper.isWindows() ? sOfficePath + fs + "bootstrap.ini" : sOfficePath + fs + "bootstraprc";
        IniFile aIniFile = new IniFile(sOfficePath);
        if (aIniFile.is()) {
            sBuildID = aIniFile.getValue("Bootstrap", "buildid");
        } else {
            GlobalLogWriter.get().println("Property Build, can't open file '" + sOfficePath + "', please check.");
        }
        return sBuildID;
    }

    private static String getBuildIDFromVersion(String _sOfficePath) {
        String fs = System.getProperty("file.separator");
        String sBuildID = "";
        String sOfficePath = _sOfficePath;
        sOfficePath = OSHelper.isWindows() ? sOfficePath + fs + "version.ini" : sOfficePath + fs + "versionrc";
        IniFile aIniFile = new IniFile(sOfficePath);
        if (aIniFile.is()) {
            sBuildID = aIniFile.getValue("Version", "buildid");
        } else {
            GlobalLogWriter.get().println("Property Build, can't open file '" + sOfficePath + "', please check.");
        }
        return sBuildID;
    }

    public static void main(String[] args) {
        String sApp = "/opt/staroffice8_m116/program/soffice -headless -accept=socket,host=localhost,port=8100;urp;";
        String sBuildID = BuildID.getBuildID(sApp);
        System.out.println("BuildID is: " + sBuildID);
        Date aDate = new Date();
        long nStart = aDate.getTime();
        System.out.println("Time:" + nStart);
        System.exit(1);
    }
}

