/*
 * Decompiled with CFR 0.152.
 */
package complexlib;

import complexlib.Assurance;
import complexlib.MethodThread;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import lib.StatusException;
import lib.TestParameters;
import share.ComplexTest;
import share.DescEntry;
import share.LogWriter;
import share.Watcher;

public abstract class ComplexTestCase
extends Assurance
implements ComplexTest {
    protected static TestParameters param = null;
    protected static LogWriter log = null;
    protected DescEntry subEntry = null;
    protected String mTestMethodName = null;
    protected int mThreadTimeOut = 0;
    public static final boolean BREAK = true;

    public void executeMethods(DescEntry entry, TestParameters environment) {
        block24: {
            Throwable t;
            boolean beforeWorked;
            block22: {
                param = environment;
                log = entry.Logger;
                this.mThreadTimeOut = param.getInt("ThreadTimeOut");
                if (this.mThreadTimeOut == 0) {
                    this.mThreadTimeOut = 300000;
                }
                beforeWorked = true;
                try {
                    Method before = this.getClass().getMethod("before", new Class[0]);
                    before.invoke((Object)this, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                    log.println("Cannot access the 'before()' method, although it is there. Is this ok?");
                }
                catch (InvocationTargetException e) {
                    beforeWorked = false;
                    t = e.getTargetException();
                    if (t instanceof RuntimeException && !this.state) break block22;
                    log.println(t.toString());
                    if (this.message == null) {
                        this.message = "Exception in before() method.\n\r" + t.getMessage();
                    }
                    this.state = false;
                    t.printStackTrace((PrintWriter)((Object)log));
                }
            }
            for (int i = 0; i < entry.SubEntries.length; ++i) {
                block23: {
                    this.subEntry = entry.SubEntries[i];
                    if (!beforeWorked) {
                        this.subEntry.State = this.message;
                        this.subEntry.hasErrorMsg = true;
                        this.subEntry.ErrorMsg = this.message;
                        continue;
                    }
                    this.state = true;
                    this.message = "";
                    Method testMethod = null;
                    try {
                        String entryName = this.subEntry.entryName;
                        String[] parameter = null;
                        if (entryName.indexOf("(") != -1) {
                            String sParameter = entryName.substring(entryName.indexOf("(") + 1, entryName.indexOf(")"));
                            this.mTestMethodName = entryName;
                            parameter = new String[]{sParameter};
                            entryName = entryName.substring(0, entryName.indexOf("("));
                            testMethod = this.getClass().getMethod(entryName, String.class);
                        } else {
                            testMethod = this.getClass().getMethod(entryName, new Class[0]);
                            this.mTestMethodName = entryName;
                        }
                        MethodThread th = new MethodThread(testMethod, this, parameter, (PrintWriter)((Object)log));
                        log.println("Starting " + this.mTestMethodName);
                        th.start();
                        try {
                            int lastPing = -1;
                            int newPing = 0;
                            int sleepingStep = 1000;
                            int factor = 0;
                            while (th.isAlive() && (lastPing != newPing || factor * sleepingStep < this.mThreadTimeOut)) {
                                Thread.sleep(sleepingStep);
                                ++factor;
                                Watcher ow = (Watcher)param.get("Watcher");
                                if (ow == null) continue;
                                lastPing = newPing;
                                newPing = ow.getPing();
                                factor = 0;
                            }
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (th.isAlive()) {
                            log.println("Destroy " + this.mTestMethodName);
                            th.destroy();
                            this.subEntry.State = "Test did sleep for " + this.mThreadTimeOut / 1000 + " seconds and has been killed!";
                            this.subEntry.hasErrorMsg = true;
                            this.subEntry.ErrorMsg = this.subEntry.State;
                            continue;
                        }
                        log.println("Finished " + this.mTestMethodName);
                        if (th.hasErrorMessage()) {
                            this.subEntry.State = th.getErrorMessage();
                            this.subEntry.hasErrorMsg = true;
                            this.subEntry.ErrorMsg = this.subEntry.State;
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        log.println(e.getClass().getName());
                        String msg = e.getMessage();
                        log.println("Message: " + msg);
                        e.printStackTrace((PrintWriter)((Object)log));
                        this.subEntry.State = "SKIPPED.FAILED";
                        this.subEntry.hasErrorMsg = true;
                        this.subEntry.ErrorMsg = msg == null ? "" : msg;
                    }
                    continue;
                }
                this.subEntry.State = this.state ? "PASSED.OK" : this.message;
                this.subEntry.hasErrorMsg = !this.state;
                this.subEntry.ErrorMsg = this.message;
            }
            if (beforeWorked) {
                try {
                    Method after = this.getClass().getMethod("after", new Class[0]);
                    after.invoke((Object)this, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                    t = e.getTargetException();
                    if (t instanceof StatusException) break block24;
                    log.println(t.toString());
                    this.message = this.message == null ? "Exception in after() method.\n\r" + t.getMessage() : this.message + "Exception in 'after()' method.\n\r" + t.getMessage();
                    log.println("Message: " + this.message);
                    t.printStackTrace((PrintWriter)((Object)log));
                }
            }
        }
    }

    @Override
    public abstract String[] getTestMethodNames();

    @Override
    public String getTestObjectName() {
        return this.getClass().getName();
    }
}

