/*
 * Decompiled with CFR 0.152.
 */
package complexlib;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Assurance {
    public static final boolean CONTINUE = true;
    protected boolean state = true;
    protected String message = null;

    protected void assure(boolean s) {
        this.assure("Assure failed.", s, false);
    }

    protected void assure(String msg, boolean s) {
        this.assure(msg, s, false);
    }

    protected void assureEquals(boolean expected, boolean actual) {
        this.assureEquals("Equality test failed", new Boolean(expected), new Boolean(actual), false);
    }

    protected void assureEquals(String message, boolean expected, boolean actual) {
        this.assureEquals(message, new Boolean(expected), new Boolean(actual), false);
    }

    protected void assureEquals(byte expected, byte actual) {
        this.assureEquals("Equality test failed", new Byte(expected), new Byte(actual), false);
    }

    protected void assureEquals(String message, byte expected, byte actual) {
        this.assureEquals(message, new Byte(expected), new Byte(actual), false);
    }

    protected void assureEquals(double expected, double actual) {
        this.assureEquals("Equality test failed", new Double(expected), new Double(actual), false);
    }

    protected void assureEquals(String message, double expected, double actual) {
        this.assureEquals(message, new Double(expected), new Double(actual), false);
    }

    protected void assureEquals(float expected, float actual) {
        this.assureEquals("Equality test failed", new Float(expected), new Float(actual), false);
    }

    protected void assureEquals(String message, float expected, float actual) {
        this.assureEquals(message, new Float(expected), new Float(actual), false);
    }

    protected void assureEquals(short expected, short actual) {
        this.assureEquals("Equality test failed", new Short(expected), new Short(actual), false);
    }

    protected void assureEquals(String message, short expected, short actual) {
        this.assureEquals(message, new Short(expected), new Short(actual), false);
    }

    protected void assureEquals(int expected, int actual) {
        this.assureEquals("Equality test failed", new Integer(expected), new Integer(actual), false);
    }

    protected void assureEquals(String message, int expected, int actual) {
        this.assureEquals(message, new Integer(expected), new Integer(actual), false);
    }

    protected void assureEquals(long expected, long actual) {
        this.assureEquals("Equality test failed", new Long(expected), new Long(actual), false);
    }

    protected void assureEquals(String message, long expected, long actual) {
        this.assureEquals(message, new Long(expected), new Long(actual), false);
    }

    protected void assureEquals(String expected, String actual) {
        this.assureEquals("Equality test failed", expected, actual, false);
    }

    protected void assureEquals(String message, String expected, String actual) {
        this.assureEquals(message, expected, actual, false);
    }

    protected void assureEquals(Object expected, Object actual) {
        this.assureEquals("Equality test failed", expected, actual, false);
    }

    protected void assureEquals(String message, Object expected, Object actual) {
        this.assureEquals(message, expected, actual, false);
    }

    protected void assureException(String _message, Object _object, String _methodName, Class[] _argClasses, Object[] _methodArgs, Class _expectedExceptionClass) {
        Class<?> objectClass = _object.getClass();
        boolean noExceptionAllowed = _expectedExceptionClass == null;
        boolean caughtExpected = noExceptionAllowed;
        try {
            Method method = objectClass.getMethod(_methodName, _argClasses);
            method.invoke(_object, _methodArgs);
        }
        catch (InvocationTargetException e) {
            caughtExpected = noExceptionAllowed ? false : e.getTargetException().getClass().equals(_expectedExceptionClass);
        }
        catch (Exception e) {
            caughtExpected = false;
        }
        this.assure(_message, caughtExpected);
    }

    protected void assureException(String _message, Object _object, String _methodName, Object[] _methodArgs, Class _expectedExceptionClass) {
        Class[] argClasses = new Class[_methodArgs.length];
        for (int i = 0; i < _methodArgs.length; ++i) {
            argClasses[i] = _methodArgs[i].getClass();
        }
        this.assureException(_message, _object, _methodName, argClasses, _methodArgs, _expectedExceptionClass);
    }

    protected void assureException(Object _object, String _methodName, Object[] _methodArgs, Class _expectedExceptionClass) {
        this.assureException("did not catch the expected exception (" + (_expectedExceptionClass == null ? "none" : _expectedExceptionClass.getName()) + ") while calling " + _object.getClass().getName() + "." + _methodName, _object, _methodName, _methodArgs, _expectedExceptionClass);
    }

    protected void assureException(Object _object, String _methodName, Class[] _argClasses, Object[] _methodArgs, Class _expectedExceptionClass) {
        this.assureException("did not catch the expected exception (" + (_expectedExceptionClass == null ? "none" : _expectedExceptionClass.getName()) + ") while calling " + _object.getClass().getName() + "." + _methodName, _object, _methodName, _argClasses, _methodArgs, _expectedExceptionClass);
    }

    protected void failed() {
        this.assure("Test did fail.", false, false);
    }

    protected void failed(String msg) {
        this.assure(msg, false, false);
    }

    protected void assure(String msg, boolean s, boolean cont) {
        this.state &= s;
        if (!s) {
            this.message = this.message + msg + "\r\n";
            if (!cont) {
                throw new AssureException(msg);
            }
        }
    }

    protected void assureEquals(String message, Object expected, Object actual, boolean cont) {
        this.assure(message + " (expected: " + expected.toString() + ", actual: " + actual.toString() + ")", expected.equals(actual), cont);
    }

    protected void failed(String msg, boolean cont) {
        this.assure(msg, false, cont);
    }

    public class AssureException
    extends RuntimeException {
        public AssureException(String msg) {
            super(msg);
        }
    }
}

