/*
 * Decompiled with CFR 0.152.
 */
package basicrunner;

import basicrunner.BasicHandler;
import basicrunner.basichelper.AttributeList;
import basicrunner.basichelper.Connector;
import basicrunner.basichelper.DispatchProviderInterceptor;
import basicrunner.basichelper.DocumentHandler;
import basicrunner.basichelper.Filter;
import basicrunner.basichelper.ThreadRunner;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.XSet;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import lib.TestParameters;
import share.LogWriter;
import util.utils;

public class BasicHandlerProvider {
    static BasicHandler oHandler = null;
    static Connector oConnector = null;
    static DocumentHandler oDocumentHandler = null;
    static ThreadRunner oThreadRunner = null;
    static AttributeList oAttributeList = null;
    static Filter oFilter = null;
    static DispatchProviderInterceptor oCeptor = null;
    static XMultiServiceFactory MSF = null;
    static boolean bIsNewConnection = true;

    public static BasicHandler getHandler(TestParameters tParam, LogWriter log) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)tParam.getMSF();
        if (!xMSF.equals(MSF)) {
            MSF = xMSF;
            oHandler = new BasicHandler(tParam);
            oConnector = new Connector();
            oFilter = new Filter();
            oDocumentHandler = new DocumentHandler();
            oThreadRunner = new ThreadRunner(xMSF);
            oCeptor = new DispatchProviderInterceptor();
            oAttributeList = new AttributeList();
            XSet xMSFSet = UnoRuntime.queryInterface(XSet.class, (Object)xMSF);
            try {
                xMSFSet.insert(oHandler);
                xMSFSet.insert(oConnector);
                xMSFSet.insert(oFilter);
                xMSFSet.insert(oDocumentHandler);
                xMSFSet.insert(oThreadRunner);
                xMSFSet.insert(oCeptor);
                xMSFSet.insert(oAttributeList);
            }
            catch (ElementExistException e) {
                System.out.println(e.toString());
            }
            catch (IllegalArgumentException e) {
                System.out.println(e.toString());
            }
            try {
                oHandler.Connect(utils.getFullURL((String)tParam.get("BASICBRIDGE")), tParam, xMSF, log);
            }
            catch (ConnectionSetupException e) {
                System.out.println("Can't connect to BASIC !");
            }
            bIsNewConnection = true;
        } else {
            bIsNewConnection = false;
        }
        return oHandler;
    }

    public static boolean isNewConnection() {
        return bIsNewConnection;
    }

    public static void disposeHandler() {
        try {
            if (oHandler != null) {
                oHandler.dispose();
            }
            if (MSF != null) {
                XSet xMSFSet = UnoRuntime.queryInterface(XSet.class, (Object)MSF);
                xMSFSet.remove(oHandler);
                xMSFSet.remove(oFilter);
                xMSFSet.remove(oConnector);
                xMSFSet.remove(oDocumentHandler);
                xMSFSet.remove(oThreadRunner);
                xMSFSet.remove(oAttributeList);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        MSF = null;
        oHandler = null;
    }
}

