/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.TestBase;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import helper.APIDescGetter;
import java.io.PrintWriter;
import lib.MultiMethodTest;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import lib.TestResult;
import share.DescEntry;
import share.DescGetter;
import share.LogWriter;
import stats.Summarizer;
import util.DynamicClassLoader;

public class java_fat_service
implements TestBase {
    protected static boolean debug = false;
    protected LogWriter log = null;

    @Override
    public boolean executeTest(TestParameters param) {
        DynamicClassLoader dcl = new DynamicClassLoader();
        this.log = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
        debug = (Boolean)param.get("DebugIsActive");
        APIDescGetter dg = new APIDescGetter();
        String job = (String)param.get("TestJob");
        boolean retValue = true;
        this.log.println("Getting Descriptions for Job: " + job);
        DescEntry[] entries = ((DescGetter)dg).getDescriptionFor(job, (String)param.get("DescriptionPath"), debug);
        if (entries == null) {
            this.log.println("Couldn't get Description for Job");
            return false;
        }
        String conStr = (String)param.get("ConnectionString");
        XMultiServiceFactory msf = (XMultiServiceFactory)param.getMSF();
        for (int l = 0; l < entries.length; ++l) {
            LogWriter sumObj;
            if (entries[l] == null) continue;
            if (entries[l].hasErrorMsg) {
                this.log.println(entries[l].ErrorMsg);
                continue;
            }
            DescEntry entry = entries[l];
            Summarizer sumIt = new Summarizer();
            TestCase tCase = null;
            try {
                tCase = (TestCase)dcl.getInstance("mod._" + entry.entryName);
            }
            catch (IllegalArgumentException ie) {
                entry.ErrorMsg = ie.getMessage();
                entry.hasErrorMsg = true;
            }
            if (tCase == null) {
                Summarizer.summarizeDown(entry, entry.ErrorMsg);
                LogWriter sumObj2 = (LogWriter)dcl.getInstance((String)param.get("OutProducer"));
                sumObj2.initialize(entry, true);
                entry.UserDefinedParams = param;
                sumObj2.summary(entry);
                continue;
            }
            this.log.println("Creating: " + tCase.getObjectName());
            this.log.initialize(entry, true);
            entry.UserDefinedParams = param;
            TestEnvironment tEnv = null;
            try {
                tCase.setLogWriter((PrintWriter)((Object)this.log));
                tCase.initializeTestCase(param);
                tEnv = tCase.getTestEnvironment(param);
            }
            catch (Exception e) {
                this.log.println("Exception while creating " + tCase.getObjectName());
                this.log.println("Exception: " + e);
                this.log.println("Message " + e.getMessage());
                tEnv = null;
            }
            if (tEnv == null) {
                Summarizer.summarizeDown(entry, "Couldn't create " + tCase.getObjectName());
                sumObj = (LogWriter)dcl.getInstance((String)param.get("OutProducer"));
                sumObj.initialize(entry, true);
                entry.UserDefinedParams = param;
                sumObj.summary(entry);
                continue;
            }
            this.log.println("Created " + tCase.getObjectName() + "\n");
            for (int j = 0; j < entry.SubEntryCount; ++j) {
                if (!entry.SubEntries[j].isToTest) {
                    Summarizer.summarizeDown(entry.SubEntries[j], "not part of the job");
                    continue;
                }
                this.log.println("running: " + entry.SubEntries[j].entryName);
                LogWriter ifclog = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
                ifclog.initialize(entry.SubEntries[j], true);
                entry.SubEntries[j].UserDefinedParams = param;
                entry.SubEntries[j].Logger = ifclog;
                if (tEnv == null || tEnv.isDisposed()) {
                    tEnv = this.getEnv(entry, param);
                }
                MultiMethodTest ifc = null;
                TestResult res = null;
                try {
                    ifc = (MultiMethodTest)dcl.getInstance(entry.SubEntries[j].entryName);
                    res = ifc.run(entry.SubEntries[j], tEnv, param);
                }
                catch (IllegalArgumentException iae) {
                    this.log.println("Couldn't load class " + entry.SubEntries[j].entryName);
                    this.log.println("**** " + iae.getMessage() + " ****");
                    Summarizer.summarizeDown(entry.SubEntries[j], iae.getMessage());
                }
                catch (RuntimeException e) {
                    tEnv = this.getEnv(entry, param);
                    ifc = (MultiMethodTest)dcl.getInstance(entry.SubEntries[j].entryName);
                    res = tEnv != null && ifc != null ? ifc.run(entry.SubEntries[j], tEnv, param) : null;
                }
                if (res != null) {
                    for (int k = 0; k < entry.SubEntries[j].SubEntryCount; ++k) {
                        if (!res.hasMethod(entry.SubEntries[j].SubEntries[k].entryName)) continue;
                        entry.SubEntries[j].SubEntries[k].State = res.getStatusFor(entry.SubEntries[j].SubEntries[k].entryName).toString();
                    }
                }
                sumIt.summarizeUp(entry.SubEntries[j]);
                LogWriter sumIfc = (LogWriter)dcl.getInstance((String)param.get("OutProducer"));
                sumIfc.initialize(entry.SubEntries[j], true);
                entry.SubEntries[j].UserDefinedParams = param;
                sumIfc.summary(entry.SubEntries[j]);
            }
            try {
                tCase.cleanupTestCase(param);
            }
            catch (Exception e) {
                e.printStackTrace((PrintWriter)((Object)this.log));
            }
            sumIt.summarizeUp(entry);
            sumObj = (LogWriter)dcl.getInstance((String)param.get("OutProducer"));
            sumObj.initialize(entry, true);
            sumObj.summary(entry);
        }
        if (entries.length > 1) {
            this.log.println("");
            int counter = 0;
            this.log.println("Failures that appeared during scenario execution:");
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].State.endsWith("OK")) continue;
                this.log.println("\t " + entries[i].longName);
                ++counter;
            }
            this.log.println(counter + " of " + entries.length + " tests failed");
        }
        return retValue;
    }

    protected TestEnvironment getEnv(DescEntry entry, TestParameters param) {
        DynamicClassLoader dcl = new DynamicClassLoader();
        this.log = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
        XMultiServiceFactory msf = (XMultiServiceFactory)param.getMSF();
        TestCase tCase = null;
        try {
            tCase = (TestCase)dcl.getInstance("mod._" + entry.entryName);
        }
        catch (IllegalArgumentException ie) {
            entry.ErrorMsg = ie.getMessage();
            entry.hasErrorMsg = true;
        }
        this.log.println("Creating: " + tCase.getObjectName());
        LogWriter log = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
        log.initialize(entry, true);
        entry.UserDefinedParams = param;
        tCase.setLogWriter((PrintWriter)((Object)log));
        TestEnvironment tEnv = null;
        try {
            tCase.initializeTestCase(param);
            tEnv = tCase.getTestEnvironment(param);
        }
        catch (DisposedException de) {
            log.println("Office disposed");
        }
        return tEnv;
    }

    protected void shortWait(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

