/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.TestBase;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XMultiServiceFactory;
import helper.APIDescGetter;
import helper.AppProvider;
import helper.ProcessHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import lib.MultiMethodTest;
import lib.StatusException;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import lib.TestResult;
import share.DescEntry;
import share.DescGetter;
import share.LogWriter;
import stats.OutProducerFactory;
import stats.Summarizer;
import util.DynamicClassLoader;
import util.utils;

public class java_fat
implements TestBase {
    private static boolean debug = false;
    private static boolean keepdocument = false;
    private static boolean logging = true;
    private static boolean newOffice = false;
    private DynamicClassLoader dcl = null;
    private TestParameters m_aParams;
    private AppProvider m_aOffice;

    @Override
    public boolean executeTest(TestParameters param) {
        this.m_aParams = param;
        this.dcl = new DynamicClassLoader();
        APIDescGetter dg = new APIDescGetter();
        String job = (String)param.get("TestJob");
        String ExclusionFile = (String)param.get("ExclusionList");
        Vector exclusions = null;
        boolean retValue = true;
        debug = param.getBool("DebugIsActive");
        logging = param.getBool("LoggingIsActive");
        keepdocument = param.getBool("KeepDocument");
        newOffice = param.getBool("NewOfficeInstance");
        if (keepdocument) {
            System.setProperty("KeepDocument", "true");
        }
        if (ExclusionFile != null) {
            exclusions = this.getExclusionList(ExclusionFile, debug);
        }
        System.out.println("Getting Descriptions for Job: " + job);
        String sDescriptionPath = (String)param.get("DescriptionPath");
        DescEntry[] entries = ((DescGetter)dg).getDescriptionFor(job, sDescriptionPath, debug);
        if (entries == null) {
            System.out.println("Couldn't get Description for Job: " + job);
            return false;
        }
        this.m_aOffice = this.startOffice(param);
        boolean firstRun = true;
        for (int l = 0; l < entries.length; ++l) {
            LogWriter sumObj;
            if (entries[l] == null) continue;
            if (entries[l].hasErrorMsg) {
                System.out.println(entries[l].ErrorMsg);
                retValue = false;
                continue;
            }
            if (!firstRun && newOffice) {
                if (!this.m_aOffice.closeExistingOffice(param, true)) {
                    this.m_aOffice.disposeManager(param);
                }
                this.startOffice(param);
            }
            firstRun = false;
            XMultiServiceFactory msf = (XMultiServiceFactory)param.getMSF();
            if (msf == null) {
                retValue = false;
                continue;
            }
            DescEntry entry = entries[l];
            Summarizer sumIt = new Summarizer();
            TestCase tCase = null;
            try {
                tCase = (TestCase)this.dcl.getInstance("mod._" + entry.entryName);
            }
            catch (IllegalArgumentException ie) {
                entry.ErrorMsg = ie.getMessage();
                entry.hasErrorMsg = true;
            }
            catch (NoClassDefFoundError ie) {
                entry.ErrorMsg = ie.getMessage();
                entry.hasErrorMsg = true;
            }
            if (tCase == null) {
                Summarizer.summarizeDown(entry, entry.ErrorMsg);
                LogWriter sumObj2 = OutProducerFactory.createOutProducer(param);
                entry.UserDefinedParams = param;
                sumObj2.initialize(entry, logging);
                sumObj2.summary(entry);
                continue;
            }
            if (debug) {
                System.out.println("sleeping 5 seconds..");
            }
            utils.shortWait(5000);
            System.out.println("Creating: " + entry.entryName);
            LogWriter log = (LogWriter)this.dcl.getInstance((String)param.get("LogWriter"));
            log.initialize(entry, logging);
            entry.UserDefinedParams = param;
            TestEnvironment tEnv = null;
            try {
                tCase.setLogWriter((PrintWriter)((Object)log));
                tCase.initializeTestCase(param);
                tEnv = tCase.getTestEnvironment(param);
            }
            catch (Exception e) {
                System.out.println("Exception while creating " + tCase.getObjectName());
                System.out.println("Message " + e.getMessage());
                e.printStackTrace();
                tEnv = null;
            }
            catch (UnsatisfiedLinkError e) {
                System.out.println("Exception while creating " + tCase.getObjectName());
                System.out.println("Message " + e.getMessage());
                tEnv = null;
            }
            catch (NoClassDefFoundError e) {
                System.out.println("Exception while creating " + tCase.getObjectName());
                System.out.println("Message " + e.getMessage());
                tEnv = null;
            }
            if (tEnv == null) {
                Summarizer.summarizeDown(entry, "Couldn't create " + tCase.getObjectName());
                sumObj = OutProducerFactory.createOutProducer(param);
                entry.UserDefinedParams = param;
                sumObj.initialize(entry, logging);
                sumObj.summary(entry);
                continue;
            }
            System.out.println(tCase.getObjectName() + " recreated ");
            for (int j = 0; j < entry.SubEntryCount; ++j) {
                DescEntry aSubEntry = entry.SubEntries[j];
                if (!aSubEntry.isToTest) {
                    Summarizer.summarizeDown(aSubEntry, "not part of the job");
                    continue;
                }
                if (exclusions != null && exclusions.contains(aSubEntry.longName)) {
                    Summarizer.summarizeDown(aSubEntry, "known issue");
                    continue;
                }
                System.out.println("running: '" + aSubEntry.entryName + "'");
                LogWriter ifclog = (LogWriter)this.dcl.getInstance((String)param.get("LogWriter"));
                ifclog.initialize(aSubEntry, logging);
                aSubEntry.UserDefinedParams = param;
                aSubEntry.Logger = ifclog;
                if (tEnv == null || tEnv.isDisposed()) {
                    this.closeExistingOffice();
                    tEnv = this.getEnv(entry, param);
                }
                TestResult res = null;
                int countInterfaceTestRun = 0;
                boolean finished = false;
                while (!finished) {
                    try {
                        ++countInterfaceTestRun;
                        finished = true;
                        res = this.executeInterfaceTest(aSubEntry, tEnv, param);
                    }
                    catch (IllegalArgumentException iae) {
                        System.out.println("Couldn't load class " + aSubEntry.entryName);
                        System.out.println("**** " + iae.getMessage() + " ****");
                        Summarizer.summarizeDown(aSubEntry, iae.getMessage());
                    }
                    catch (NoClassDefFoundError iae) {
                        System.out.println("Couldn't load class " + aSubEntry.entryName);
                        System.out.println("**** " + iae.getMessage() + " ****");
                        Summarizer.summarizeDown(aSubEntry, iae.getMessage());
                    }
                    catch (RuntimeException e) {
                        this.closeExistingOffice();
                        tEnv = this.getEnv(entry, param);
                        if (countInterfaceTestRun < 2) {
                            finished = false;
                            continue;
                        }
                        Summarizer.summarizeDown(aSubEntry, e.toString() + ".FAILED");
                    }
                }
                this.setState(aSubEntry, res);
                sumIt.summarizeUp(aSubEntry);
                LogWriter sumIfc = OutProducerFactory.createOutProducer(param);
                aSubEntry.UserDefinedParams = param;
                sumIfc.initialize(aSubEntry, logging);
                sumIfc.summary(aSubEntry);
            }
            try {
                if (!keepdocument) {
                    tCase.cleanupTestCase(param);
                }
            }
            catch (Exception e) {
                System.out.println("couldn't cleanup");
            }
            catch (NoClassDefFoundError e) {
                System.out.println("couldn't cleanup");
            }
            sumIt.summarizeUp(entry);
            sumObj = OutProducerFactory.createOutProducer(param);
            sumObj.initialize(entry, logging);
            sumObj.summary(entry);
        }
        if (entries.length > 0) {
            System.out.println();
            int counter = 0;
            System.out.println("Failures that appeared during scenario execution:");
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].State.endsWith("OK")) continue;
                System.out.println("\t " + entries[i].longName);
                ++counter;
            }
            System.out.println(counter + " of " + entries.length + " tests failed");
        }
        this.closeExistingOffice();
        return retValue;
    }

    private void setState(DescEntry aSubEntry, TestResult res) {
        if (res != null) {
            for (int k = 0; k < aSubEntry.SubEntryCount; ++k) {
                DescEntry aSubSubEntry = aSubEntry.SubEntries[k];
                if (!res.hasMethod(aSubSubEntry.entryName)) continue;
                aSubSubEntry.State = res.getStatusFor(aSubSubEntry.entryName).toString();
            }
        }
    }

    private TestEnvironment getEnv(DescEntry entry, TestParameters param) {
        TestCase tCase = null;
        try {
            tCase = (TestCase)this.dcl.getInstance("mod._" + entry.entryName);
        }
        catch (IllegalArgumentException ie) {
            entry.ErrorMsg = ie.getMessage();
            entry.hasErrorMsg = true;
        }
        catch (NoClassDefFoundError ie) {
            entry.ErrorMsg = ie.getMessage();
            entry.hasErrorMsg = true;
        }
        System.out.println("Creating: " + entry.entryName);
        entry.UserDefinedParams = param;
        LogWriter log = (LogWriter)this.dcl.getInstance((String)param.get("LogWriter"));
        log.initialize(entry, logging);
        tCase.setLogWriter((PrintWriter)((Object)log));
        TestEnvironment tEnv = null;
        try {
            tCase.initializeTestCase(param);
            tEnv = tCase.getTestEnvironment(param);
        }
        catch (DisposedException de) {
            System.out.println("Office disposed");
            this.closeExistingOffice();
        }
        catch (StatusException e) {
            System.out.println(e.getMessage());
            this.closeExistingOffice();
            entry.ErrorMsg = e.getMessage();
            entry.hasErrorMsg = true;
        }
        return tEnv;
    }

    private void closeExistingOffice() {
        ProcessHandler ph = (ProcessHandler)this.m_aParams.get("AppProvider");
        if (ph != null) {
            this.m_aOffice.closeExistingOffice(this.m_aParams, true);
            this.shortWait(5000);
        }
    }

    private void shortWait(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Vector getExclusionList(String url, boolean debug) {
        Vector<String> entryList = new Vector<String>();
        String line = "#";
        BufferedReader exclusion = null;
        try {
            exclusion = new BufferedReader(new FileReader(url));
        }
        catch (FileNotFoundException fnfe) {
            if (debug) {
                System.out.println("Couldn't find file " + url);
            }
            return entryList;
        }
        while (line != null) {
            try {
                if (!line.startsWith("#") && line.length() > 1) {
                    entryList.add(line.trim());
                }
                line = exclusion.readLine();
            }
            catch (IOException ioe) {
                if (debug) {
                    System.out.println("Exception while reading exclusion list");
                }
                return entryList;
            }
        }
        try {
            exclusion.close();
        }
        catch (IOException ioe) {
            if (debug) {
                System.out.println("Couldn't close file " + url);
            }
            return entryList;
        }
        return entryList;
    }

    private TestResult executeInterfaceTest(DescEntry entry, TestEnvironment tEnv, TestParameters param) throws IllegalArgumentException, NoClassDefFoundError {
        MultiMethodTest ifc = (MultiMethodTest)this.dcl.getInstance(entry.entryName);
        return ifc.run(entry, tEnv, param);
    }

    private AppProvider startOffice(TestParameters param) {
        XMultiServiceFactory msf;
        String officeProviderName;
        AppProvider office;
        if (this.dcl == null) {
            this.dcl = new DynamicClassLoader();
        }
        if ((office = (AppProvider)this.dcl.getInstance(officeProviderName = (String)param.get("OfficeProvider"))) == null) {
            System.out.println("ERROR: Wrong parameter 'OfficeProvider',  it cannot be instantiated.");
            System.exit(-1);
        }
        if ((msf = (XMultiServiceFactory)office.getManager(param)) != null) {
            param.put("ServiceFactory", msf);
        }
        return office;
    }
}

