/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WaitingImageObserver
implements ImageObserver {
    private static final Log LOGGER = LogFactory.getLog(WaitingImageObserver.class);
    private static final long serialVersionUID = -807204410581383550L;
    private boolean lock;
    private Image image;
    private boolean error;

    public WaitingImageObserver(Image image) {
        if (image == null) {
            throw new NullPointerException();
        }
        this.image = image;
        this.lock = true;
    }

    @Override
    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == null) {
            throw new NullPointerException();
        }
        if ((n & 0x20) == 32) {
            this.lock = false;
            this.error = false;
            this.notifyAll();
            return false;
        }
        if ((n & 0x80) == 128 || (n & 0x40) == 64) {
            this.lock = false;
            this.error = true;
            this.notifyAll();
            return false;
        }
        return true;
    }

    public synchronized void waitImageLoaded() {
        if (!this.lock) {
            return;
        }
        BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
        Graphics graphics = bufferedImage.getGraphics();
        while (this.lock) {
            if (graphics.drawImage(this.image, 0, 0, bufferedImage.getWidth(this), bufferedImage.getHeight(this), this)) {
                return;
            }
            try {
                this.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.info((Object)"WaitingImageObserver.waitImageLoaded(): InterruptedException thrown", (Throwable)interruptedException);
            }
        }
    }

    public boolean isLoadingComplete() {
        return !this.lock;
    }

    public boolean isError() {
        return this.error;
    }
}

