/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.text.Format;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

public class StringUtils {
    private static final String TRUE = "true";
    private static final String YES = "yes";
    private static final String ON = "on";

    private StringUtils() {
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        return string.regionMatches(true, 0, string2, 0, string2.length());
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        if (string.length() < string2.length()) {
            return false;
        }
        return string.regionMatches(true, string.length() - string2.length(), string2, 0, string2.length());
    }

    public static String getLineSeparator() {
        try {
            return System.getProperty("line.separator", "\n");
        }
        catch (Exception exception) {
            return "\n";
        }
    }

    public static String[] split(String string) {
        return StringUtils.split(string, " \t\n\r\f");
    }

    public static String[] split(String string, String string2) {
        if (string2 == null) {
            throw new NullPointerException("Separator characters must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("String to be split must not be null.");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            stringArray[n] = string3 = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String[] split(String string, String string2, String string3) {
        String[] stringArray;
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, string2, string3);
        String[] stringArray2 = new String[cSVTokenizer.countTokens()];
        int n = 0;
        while (cSVTokenizer.hasMoreTokens()) {
            stringArray = cSVTokenizer.nextToken();
            if (stringArray.length() <= 0) continue;
            stringArray2[n] = stringArray;
            ++n;
        }
        if (n == stringArray2.length) {
            return stringArray2;
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }

    public static String[] splitCSV(String string, String string2) {
        return StringUtils.splitCSV(string, string2, null);
    }

    public static String[] splitCSV(String string, String string2, String string3) {
        CSVTokenizer cSVTokenizer = new CSVTokenizer(string, string2, string3);
        String[] stringArray = new String[cSVTokenizer.countTokens()];
        int n = 0;
        while (cSVTokenizer.hasMoreTokens()) {
            String string4;
            stringArray[n] = string4 = cSVTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static String makeUniqueName(String[] stringArray, String string) {
        Object[] objectArray;
        HashSet<Object[]> hashSet = new HashSet<Object[]>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray = stringArray[i];
            hashSet.add(objectArray);
        }
        MessageFormat messageFormat = new MessageFormat(string);
        objectArray = new Object[]{""};
        String string2 = messageFormat.format(objectArray);
        if (!hashSet.contains(string2)) {
            return string2;
        }
        Format[] formatArray = messageFormat.getFormats();
        if (formatArray.length == 0) {
            return null;
        }
        for (int i = 1; i < 2000000; ++i) {
            objectArray[0] = String.valueOf(i);
            String string3 = messageFormat.format(objectArray);
            if (hashSet.contains(string3)) continue;
            return string3;
        }
        return null;
    }

    public static String[] merge(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray.length == 0) {
            return (String[])stringArray2.clone();
        }
        if (stringArray2.length == 0) {
            return (String[])stringArray.clone();
        }
        HashSet<String> hashSet = new HashSet<String>(stringArray.length + stringArray2.length);
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.add(stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            hashSet.add(stringArray2[n]);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public static boolean toBoolean(String string) {
        return StringUtils.toBoolean(string, false);
    }

    public static boolean toBoolean(String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        return TRUE.equals(string = string.trim().toLowerCase()) || YES.equals(string) || ON.equals(string);
    }

    public static boolean isEmpty(String string) {
        return StringUtils.isEmpty(string, true);
    }

    public static boolean isEmpty(String string, boolean bl) {
        if (string == null) {
            return true;
        }
        if (string.length() == 0) {
            return true;
        }
        if (!bl) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c <= ' ') continue;
            return false;
        }
        return true;
    }

    public static boolean equals(String string, String string2) {
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string == null && string2 == null || string != null && string.equalsIgnoreCase(string2);
    }
}

