/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ObjectUtilities {
    private static final Log LOGGER = LogFactory.getLog(ObjectUtilities.class);
    public static final String THREAD_CONTEXT = "ThreadContext";
    public static final String CLASS_CONTEXT = "ClassContext";
    private static String classLoaderSource = "ThreadContext";
    private static ClassLoader classLoader;
    private static final Integer[] EMPTY_VERSIONS;

    private ObjectUtilities() {
    }

    public static String getClassLoaderSource() {
        return classLoaderSource;
    }

    public static void setClassLoaderSource(String string) {
        classLoaderSource = string;
    }

    public static boolean equal(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object != null) {
            return object.equals(object2);
        }
        return false;
    }

    public static Object clone(Object object) throws CloneNotSupportedException {
        if (object == null) {
            throw new IllegalArgumentException("Null 'object' argument.");
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            if (Modifier.isPublic(method.getModifiers())) {
                return method.invoke(object, (Object[])null);
            }
            throw new CloneNotSupportedException("Failed to clone: Method 'clone()' is not public on class " + object.getClass());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.warn((Object)("Object without clone() method is impossible on class " + object.getClass()), (Throwable)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.warn((Object)("Object.clone(): unable to call method 'clone()'  on class " + object.getClass()), (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.warn((Object)("Object without clone() method is impossible on class " + object.getClass()), (Throwable)invocationTargetException);
        }
        throw new CloneNotSupportedException("Failed to clone: Clone caused an Exception while cloning type " + object.getClass());
    }

    public static synchronized void setClassLoader(ClassLoader classLoader) {
        ObjectUtilities.classLoader = classLoader;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getClassLoader(Class clazz) {
        Object object = ObjectUtilities.class;
        synchronized (ObjectUtilities.class) {
            if (classLoader != null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return classLoader;
            }
            String string = classLoaderSource;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            if (THREAD_CONTEXT.equals(string) && (object = Thread.currentThread().getContextClassLoader()) != null) {
                return object;
            }
            object = clazz.getClassLoader();
            if (object == null) {
                return ClassLoader.getSystemClassLoader();
            }
            return object;
        }
    }

    public static URL getResource(String string, Class clazz) {
        if (string == null) {
            throw new NullPointerException();
        }
        ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResource(string);
    }

    public static URL getResourceRelative(String string, Class clazz) {
        if (string == null) {
            throw new NullPointerException();
        }
        ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
        String string2 = ObjectUtilities.convertName(string, clazz);
        if (classLoader == null) {
            return null;
        }
        return classLoader.getResource(string2);
    }

    private static String convertName(String string, Class clazz) {
        if (string.length() > 0 && string.charAt(0) == '/') {
            return string.substring(1);
        }
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        String string2 = clazz.getName();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        String string3 = string2.substring(0, n);
        return string3.replace('.', '/') + '/' + string;
    }

    public static InputStream getResourceAsStream(String string, Class clazz) {
        URL uRL = ObjectUtilities.getResource(string, clazz);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static InputStream getResourceRelativeAsStream(String string, Class clazz) {
        URL uRL = ObjectUtilities.getResourceRelative(string, clazz);
        if (uRL == null) {
            return null;
        }
        try {
            return uRL.openStream();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Object loadAndInstantiate(String string, Class clazz) {
        return ObjectUtilities.loadAndInstantiate(string, clazz, null);
    }

    public static Object loadAndInstantiate(String string, Class clazz, Class clazz2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        try {
            ClassLoader classLoader = ObjectUtilities.getClassLoader(clazz);
            Class<?> clazz3 = classLoader.loadClass(string);
            if (clazz2 != null && !clazz2.isAssignableFrom(clazz3)) {
                LOGGER.warn((Object)("Specified class " + string + " is not of expected type " + clazz2));
                return null;
            }
            return clazz3.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Specified class " + string + " does not exist."));
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Specified class " + string + " cannot be loaded [NOCLASSDEFERROR]."));
            }
        }
        catch (Throwable throwable) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info((Object)("Specified class " + string + " failed to instantiate correctly."), throwable);
            }
            LOGGER.info((Object)("Specified class " + string + " failed to instantiate correctly."));
        }
        return null;
    }

    public static boolean isJDK14() {
        Object object;
        try {
            object = ObjectUtilities.getClassLoader(ObjectUtilities.class);
            if (object != null) {
                try {
                    ((ClassLoader)object).loadClass("java.util.RandomAccess");
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            object = System.getProperty("java.vm.specification.version");
            if (object == null) {
                return false;
            }
            Integer[] integerArray = ObjectUtilities.parseVersions((String)object);
            Integer[] integerArray2 = new Integer[]{new Integer(1), new Integer(4)};
            return ObjectUtilities.compareVersionArrays(integerArray, integerArray2) >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static int compareVersionArrays(Integer[] integerArray, Integer[] integerArray2) {
        int n = Math.min(integerArray.length, integerArray2.length);
        for (int i = 0; i < n; ++i) {
            Integer n2 = integerArray[i];
            Integer n3 = integerArray2[i];
            if (n2 == null && n3 == null) continue;
            if (n2 == null) {
                return 1;
            }
            if (n3 == null) {
                return -1;
            }
            int n4 = n2.compareTo(n3);
            if (n4 == 0) continue;
            return n4;
        }
        return 0;
    }

    private static Integer[] parseVersions(String string) {
        if (string == null) {
            return EMPTY_VERSIONS;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(new Integer(stringTokenizer.nextToken()));
            }
            catch (NumberFormatException numberFormatException) {
                break;
            }
        }
        return arrayList.toArray(new Integer[arrayList.size()]);
    }

    public static boolean equalArray(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        return Arrays.equals(objectArray, objectArray2);
    }

    static {
        EMPTY_VERSIONS = new Integer[0];
    }
}

