/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;

public class LinkedMap
implements Cloneable,
Serializable {
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final Object NULL_MARKER = new Object();
    private int size;
    private int mask;
    private float loadFactor;
    private int capacity;
    private MapEntry[] backend;
    private MapEntry firstEntry;
    private MapEntry lastEntry;

    public LinkedMap() {
        this(16, 0.75f);
    }

    public LinkedMap(int n, float f) {
        int n2;
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        int n3 = 0;
        for (n2 = 1; n2 < n; n2 <<= 1) {
            n3 = n3 << 1 | 1;
        }
        this.mask = n3;
        this.loadFactor = f;
        this.backend = new MapEntry[n2];
        this.capacity = (int)Math.ceil((float)n2 * f);
    }

    private void ensureSize() {
        MapEntry[] mapEntryArray = this.backend;
        if (this.size <= this.capacity) {
            return;
        }
        MapEntry[] mapEntryArray2 = new MapEntry[mapEntryArray.length << 1];
        int n = this.mask << 1 | 1;
        for (MapEntry mapEntry = this.firstEntry; mapEntry != null; mapEntry = mapEntry.getNext()) {
            int n2 = mapEntry.hashKey & n;
            MapEntry mapEntry2 = mapEntryArray2[n2];
            mapEntry.setCollisionNext(mapEntry2);
            mapEntryArray2[n2] = mapEntry;
        }
        this.mask = n;
        this.backend = mapEntryArray2;
        this.capacity = (int)Math.ceil(this.loadFactor * (float)mapEntryArray.length);
    }

    public int size() {
        return this.size;
    }

    public Object put(Object object, Object object2) {
        Object object3 = LinkedMap.ensureKey(object);
        int n = LinkedMap.cleanHash(object3.hashCode());
        int n2 = n & this.mask;
        MapEntry mapEntry = this.backend[n2];
        if (mapEntry == null) {
            MapEntry mapEntry2 = new MapEntry(object3, n, object2);
            this.addNewRecord(n2, mapEntry2);
            return null;
        }
        MapEntry mapEntry3 = mapEntry;
        while (mapEntry3.hashKey != n || !mapEntry3.key.equals(object3)) {
            if (mapEntry3.collisionNext == null) {
                MapEntry mapEntry4 = new MapEntry(object3, n, object2);
                this.addCollisionRecord(mapEntry3, mapEntry4);
                return null;
            }
            mapEntry3 = mapEntry3.collisionNext;
        }
        return this.updateRecord(object2, mapEntry3);
    }

    private Object updateRecord(Object object, MapEntry mapEntry) {
        MapEntry mapEntry2;
        Object object2 = mapEntry.value;
        mapEntry.value = object;
        MapEntry mapEntry3 = this.firstEntry;
        MapEntry mapEntry4 = this.lastEntry;
        if (mapEntry4 == mapEntry) {
            return object2;
        }
        if (mapEntry3 == mapEntry) {
            this.firstEntry = mapEntry.next;
            mapEntry.previous = mapEntry4;
            mapEntry.next = null;
            mapEntry4.next = mapEntry;
            this.lastEntry = mapEntry;
            return object2;
        }
        MapEntry mapEntry5 = mapEntry.previous;
        mapEntry5.next = mapEntry2 = mapEntry.next;
        mapEntry2.previous = mapEntry5;
        mapEntry.previous = mapEntry4;
        mapEntry.next = null;
        mapEntry4.next = mapEntry;
        this.lastEntry = mapEntry;
        return object2;
    }

    private void addCollisionRecord(MapEntry mapEntry, MapEntry mapEntry2) {
        MapEntry mapEntry3;
        mapEntry.collisionNext = mapEntry2;
        mapEntry2.previous = mapEntry3 = this.lastEntry;
        mapEntry2.next = null;
        mapEntry3.next = mapEntry2;
        this.lastEntry = mapEntry2;
        ++this.size;
    }

    private void addNewRecord(int n, MapEntry mapEntry) {
        this.ensureSize();
        MapEntry mapEntry2 = this.lastEntry;
        if (mapEntry2 == null) {
            this.firstEntry = mapEntry;
        } else {
            mapEntry.previous = mapEntry2;
            mapEntry2.next = mapEntry;
        }
        this.lastEntry = mapEntry;
        this.backend[n] = mapEntry;
        ++this.size;
    }

    public Object get(Object object) {
        Object object2 = LinkedMap.ensureKey(object);
        int n = LinkedMap.cleanHash(object2.hashCode());
        int n2 = n & this.mask;
        MapEntry mapEntry = this.backend[n2];
        if (mapEntry == null) {
            return null;
        }
        MapEntry mapEntry2 = mapEntry;
        while (mapEntry2 != null) {
            if (mapEntry2.hashKey == n && mapEntry2.key.equals(object2)) {
                return mapEntry2.value;
            }
            mapEntry2 = mapEntry2.collisionNext;
        }
        return null;
    }

    public Object remove(Object object) {
        Object object2 = LinkedMap.ensureKey(object);
        int n = LinkedMap.cleanHash(object2.hashCode());
        int n2 = n & this.mask;
        MapEntry mapEntry = this.backend[n2];
        if (mapEntry == null) {
            return null;
        }
        MapEntry mapEntry2 = null;
        MapEntry mapEntry3 = mapEntry;
        while (mapEntry3 != null) {
            if (mapEntry3.hashKey == n && mapEntry3.key.equals(object2)) {
                MapEntry mapEntry4;
                Object object3 = mapEntry3.value;
                if (mapEntry2 == null) {
                    this.backend[n2] = mapEntry3.collisionNext;
                } else {
                    mapEntry2.setCollisionNext(mapEntry3.collisionNext);
                }
                if (this.firstEntry == this.lastEntry) {
                    this.firstEntry = null;
                    this.lastEntry = null;
                    --this.size;
                    return object3;
                }
                if (this.firstEntry == mapEntry3) {
                    mapEntry4 = mapEntry3.next;
                    if (mapEntry4 != null) {
                        mapEntry4.previous = null;
                    }
                    this.firstEntry = mapEntry4;
                }
                if (this.lastEntry == mapEntry3) {
                    mapEntry4 = mapEntry3.previous;
                    if (mapEntry4 != null) {
                        mapEntry4.next = null;
                    }
                    this.lastEntry = mapEntry4;
                }
                if (mapEntry3.previous != null) {
                    mapEntry3.previous.next = mapEntry3.next;
                }
                if (mapEntry3.next != null) {
                    mapEntry3.next.previous = mapEntry3.previous;
                }
                --this.size;
                return object3;
            }
            mapEntry2 = mapEntry3;
            mapEntry3 = mapEntry3.collisionNext;
        }
        return null;
    }

    public boolean containsKey(Object object) {
        Object object2 = LinkedMap.ensureKey(object);
        int n = LinkedMap.cleanHash(object2.hashCode());
        int n2 = n & this.mask;
        MapEntry mapEntry = this.backend[n2];
        if (mapEntry == null) {
            return false;
        }
        MapEntry mapEntry2 = mapEntry;
        while (mapEntry2 != null) {
            if (mapEntry2.hashKey == n && mapEntry2.key.equals(object2)) {
                return true;
            }
            mapEntry2 = mapEntry2.collisionNext;
        }
        return false;
    }

    public Object[] keys(Object[] objectArray) {
        Object[] objectArray2 = objectArray.length < this.size ? (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size) : objectArray;
        int n = 0;
        MapEntry mapEntry = this.firstEntry;
        while (mapEntry != null) {
            Object object = mapEntry.key;
            objectArray2[n] = object == NULL_MARKER ? null : object;
            mapEntry = mapEntry.getNext();
            ++n;
        }
        return objectArray2;
    }

    public Object[] keys() {
        return this.keys(new Object[this.size]);
    }

    public Object[] values() {
        return this.values(new Object[this.size]);
    }

    public Object[] values(Object[] objectArray) {
        Object[] objectArray2 = objectArray.length < this.size ? (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size) : objectArray;
        int n = 0;
        MapEntry mapEntry = this.firstEntry;
        while (mapEntry != null) {
            Object object;
            objectArray2[n] = object = mapEntry.value;
            mapEntry = mapEntry.getNext();
            ++n;
        }
        return objectArray2;
    }

    public void clear() {
        if (this.firstEntry == null) {
            return;
        }
        this.firstEntry = null;
        this.lastEntry = null;
        Arrays.fill(this.backend, null);
        this.size = 0;
    }

    private static Object ensureKey(Object object) {
        if (object == null) {
            return NULL_MARKER;
        }
        return object;
    }

    private static int cleanHash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    public Object clone() throws CloneNotSupportedException {
        LinkedMap linkedMap = (LinkedMap)super.clone();
        linkedMap.backend = (MapEntry[])this.backend.clone();
        Arrays.fill(linkedMap.backend, null);
        linkedMap.firstEntry = null;
        linkedMap.lastEntry = null;
        linkedMap.size = 0;
        for (MapEntry mapEntry = this.firstEntry; mapEntry != null; mapEntry = mapEntry.getNext()) {
            linkedMap.put(mapEntry.key, mapEntry.value);
        }
        return linkedMap;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    protected static final class MapEntry
    implements Serializable {
        protected final int hashKey;
        protected final Object key;
        protected Object value;
        protected MapEntry previous;
        protected MapEntry next;
        protected MapEntry collisionNext;

        protected MapEntry(Object object, int n, Object object2) {
            if (object == null) {
                throw new NullPointerException();
            }
            this.key = object;
            this.hashKey = n;
            this.value = object2;
        }

        public MapEntry getPrevious() {
            return this.previous;
        }

        public void setPrevious(MapEntry mapEntry) {
            this.previous = mapEntry;
        }

        public MapEntry getNext() {
            return this.next;
        }

        public void setNext(MapEntry mapEntry) {
            this.next = mapEntry;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }

        public MapEntry getCollisionNext() {
            return this.collisionNext;
        }

        public void setCollisionNext(MapEntry mapEntry) {
            this.collisionNext = mapEntry;
        }
    }
}

