/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class CSVTokenizer
implements Enumeration {
    private String record;
    private String separator;
    private String quate;
    private int currentIndex;
    private boolean beforeStart;
    public static final String SEPARATOR_COMMA = ",";
    public static final String SEPARATOR_TAB = "\t";
    public static final String SEPARATOR_SPACE = " ";
    public static final String DOUBLE_QUATE = "\"";
    public static final String SINGLE_QUATE = "'";

    public CSVTokenizer(String string, String string2, String string3) {
        if (string == null) {
            throw new NullPointerException("The given string is null");
        }
        if (string2 == null) {
            throw new NullPointerException("The given separator is null");
        }
        this.record = string.trim();
        this.separator = string2;
        this.quate = string3;
        this.currentIndex = 0;
        this.beforeStart = true;
    }

    public CSVTokenizer(String string, String string2) {
        this(string, string2, DOUBLE_QUATE);
    }

    public CSVTokenizer(String string) {
        this(string, SEPARATOR_COMMA);
    }

    public boolean hasMoreTokens() {
        return this.currentIndex < this.record.length();
    }

    public String nextToken() throws NoSuchElementException, IllegalArgumentException {
        if (!this.hasMoreTokens()) {
            throw new NoSuchElementException();
        }
        if (!this.beforeStart) {
            this.currentIndex += this.separator.length();
        } else {
            this.beforeStart = false;
        }
        if (this.quate != null && this.record.startsWith(this.quate, this.currentIndex)) {
            int n = this.quate.length();
            int n2 = this.currentIndex + n;
            while (true) {
                int n3;
                if ((n3 = this.record.indexOf(this.quate, n2)) < 0) {
                    throw new IllegalArgumentException("Illegal format");
                }
                if (!this.record.startsWith(this.quate, n3 + 1)) {
                    String string = this.record.substring(this.currentIndex + n, n3);
                    this.currentIndex = n3 + 1;
                    return string;
                }
                n2 = n3 + n * 2;
            }
        }
        int n = this.record.indexOf(this.separator, this.currentIndex);
        if (n >= 0) {
            int n4 = this.currentIndex;
            String string = this.record.substring(n4, n);
            this.currentIndex = n;
            return string;
        }
        int n5 = this.currentIndex;
        String string = this.record.substring(n5);
        this.currentIndex = this.record.length();
        return string;
    }

    public String nextToken(String string) {
        this.separator = string;
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int n = 0;
        int n2 = this.currentIndex;
        boolean bl = this.beforeStart;
        while (this.hasMoreTokens()) {
            this.nextToken();
            ++n;
        }
        this.currentIndex = n2;
        this.beforeStart = bl;
        return n;
    }

    public String getQuate() {
        return this.quate;
    }

    public void setQuate(String string) {
        this.quate = string;
    }
}

