/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.sandbox;

import com.sun.star.lib.sandbox.Cachable;
import com.sun.star.lib.sandbox.ClassContext;
import com.sun.star.lib.sandbox.ClassContextImpl;
import com.sun.star.lib.sandbox.ProtectionDomain;
import com.sun.star.lib.sandbox.WeakRef;
import com.sun.star.lib.sandbox.WeakTable;
import java.io.InputStream;
import java.net.URL;

public final class ClassContextProxy
implements ClassContext,
Cachable {
    private static int instances;
    private static final boolean DEBUG = false;
    private ClassContext classContext;
    private WeakRef weakRef;
    private URL base;

    public ClassContextProxy() {
        ++instances;
    }

    @Override
    public Object getHardObject() {
        return this.classContext;
    }

    @Override
    public void setWeakRef(WeakRef weakRef) {
        this.classContext = (ClassContext)weakRef.getRef();
        this.base = this.classContext.getBase();
        this.weakRef = weakRef;
        weakRef.incRefCnt();
    }

    public void finalize() {
        this.weakRef.decRefCnt();
        --instances;
    }

    public static ClassContext create(URL uRL, ProtectionDomain protectionDomain, ThreadGroup threadGroup) {
        return ClassContextProxy.create(uRL, protectionDomain, threadGroup, false);
    }

    public static ClassContext create(URL uRL, ProtectionDomain protectionDomain, ThreadGroup threadGroup, boolean bl) {
        Cachable cachable = WeakTable.get("ClassContxt: " + uRL);
        ClassContextProxy classContextProxy = (ClassContextProxy)cachable;
        if (classContextProxy == null) {
            classContextProxy = new ClassContextProxy(uRL, protectionDomain, threadGroup, bl);
            WeakTable.put("ClassContxt: " + uRL, classContextProxy);
        }
        return classContextProxy;
    }

    private ClassContextProxy(URL uRL, ProtectionDomain protectionDomain, ThreadGroup threadGroup, boolean bl) {
        this();
        this.base = uRL;
        this.classContext = new ClassContextImpl(uRL, protectionDomain, threadGroup, bl);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classContext.getClassLoader();
    }

    @Override
    public boolean hasThreadGroup() {
        return this.classContext.hasThreadGroup();
    }

    @Override
    public ThreadGroup getThreadGroup() {
        return this.classContext.getThreadGroup();
    }

    @Override
    public URL getBase() {
        return this.classContext.getBase();
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        return this.classContext.getResourceAsStream(string);
    }

    @Override
    public URL getResource(String string) {
        return this.classContext.getResource(string);
    }

    @Override
    public void addCargo(Object object) {
        this.classContext.addCargo(object);
    }

    @Override
    public void dispose() {
        this.classContext.dispose();
    }

    @Override
    public synchronized Class findClass(String string) throws ClassNotFoundException {
        return this.classContext.findClass(string);
    }

    @Override
    public synchronized Class loadClass(String string) throws ClassNotFoundException {
        return this.classContext.loadClass(string);
    }
}

