/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.palm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.converter.palm.PalmDB;
import org.openoffice.xmerge.converter.palm.PdbDecoder;
import org.openoffice.xmerge.converter.palm.PdbEncoder;
import org.openoffice.xmerge.converter.palm.Record;

public class PalmDocument
implements Document {
    private PalmDB pdb;
    private String fileName;

    public PalmDocument(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    public PalmDocument(String string, int n, int n2, int n3, short s, Record[] recordArray) throws UnsupportedEncodingException {
        this.pdb = new PalmDB(string, n, n2, n3, s, recordArray);
        this.fileName = this.pdb.getPDBNameString();
    }

    @Override
    public void read(InputStream inputStream) throws IOException {
        PdbDecoder pdbDecoder = new PdbDecoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = 0;
        while ((n = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.pdb = pdbDecoder.parse(byArray2);
        this.fileName = this.pdb.getPDBNameString();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        PdbEncoder pdbEncoder = new PdbEncoder(this.pdb);
        pdbEncoder.write(outputStream);
    }

    public PalmDB getPdb() {
        return this.pdb;
    }

    public void setPdb(PalmDB palmDB) {
        String string;
        this.pdb = palmDB;
        this.fileName = string = palmDB.getPDBNameString();
    }

    @Override
    public String getFileName() {
        return this.fileName + ".pdb";
    }

    @Override
    public String getName() {
        return this.fileName;
    }
}

