/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.NoBodyOutputStream;

class NoBodyResponse
implements HttpServletResponse {
    private HttpServletResponse resp;
    private NoBodyOutputStream noBody;
    private PrintWriter writer;
    private boolean didSetContentLength;

    NoBodyResponse(HttpServletResponse r) {
        this.resp = r;
        this.noBody = new NoBodyOutputStream();
    }

    void setContentLength() {
        if (!this.didSetContentLength) {
            this.resp.setContentLength(this.noBody.getContentLength());
        }
    }

    @Override
    public void setContentLength(int len) {
        this.resp.setContentLength(len);
        this.didSetContentLength = true;
    }

    @Override
    public void setCharacterEncoding(String charset) {
        this.resp.setCharacterEncoding(charset);
    }

    @Override
    public void setContentType(String type) {
        this.resp.setContentType(type);
    }

    @Override
    public String getContentType() {
        return this.resp.getContentType();
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this.noBody;
    }

    @Override
    public String getCharacterEncoding() {
        return this.resp.getCharacterEncoding();
    }

    @Override
    public PrintWriter getWriter() throws UnsupportedEncodingException {
        if (this.writer == null) {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)this.noBody, this.getCharacterEncoding());
            this.writer = new PrintWriter(w);
        }
        return this.writer;
    }

    @Override
    public void setBufferSize(int size) throws IllegalStateException {
        this.resp.setBufferSize(size);
    }

    @Override
    public int getBufferSize() {
        return this.resp.getBufferSize();
    }

    @Override
    public void reset() throws IllegalStateException {
        this.resp.reset();
    }

    @Override
    public void resetBuffer() throws IllegalStateException {
        this.resp.resetBuffer();
    }

    @Override
    public boolean isCommitted() {
        return this.resp.isCommitted();
    }

    @Override
    public void flushBuffer() throws IOException {
        this.resp.flushBuffer();
    }

    @Override
    public void setLocale(Locale loc) {
        this.resp.setLocale(loc);
    }

    @Override
    public Locale getLocale() {
        return this.resp.getLocale();
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.resp.addCookie(cookie);
    }

    @Override
    public boolean containsHeader(String name) {
        return this.resp.containsHeader(name);
    }

    @Override
    public void setStatus(int sc, String sm) {
        this.resp.setStatus(sc, sm);
    }

    @Override
    public void setStatus(int sc) {
        this.resp.setStatus(sc);
    }

    @Override
    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }

    @Override
    public void setIntHeader(String name, int value) {
        this.resp.setIntHeader(name, value);
    }

    @Override
    public void setDateHeader(String name, long date) {
        this.resp.setDateHeader(name, date);
    }

    @Override
    public void sendError(int sc, String msg) throws IOException {
        this.resp.sendError(sc, msg);
    }

    @Override
    public void sendError(int sc) throws IOException {
        this.resp.sendError(sc);
    }

    @Override
    public void sendRedirect(String location) throws IOException {
        this.resp.sendRedirect(location);
    }

    @Override
    public String encodeURL(String url) {
        return this.resp.encodeURL(url);
    }

    @Override
    public String encodeRedirectURL(String url) {
        return this.resp.encodeRedirectURL(url);
    }

    @Override
    public void addHeader(String name, String value) {
        this.resp.addHeader(name, value);
    }

    @Override
    public void addDateHeader(String name, long value) {
        this.resp.addDateHeader(name, value);
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.resp.addIntHeader(name, value);
    }

    @Override
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Override
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }
}

