/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;
import org.pentaho.reporting.libraries.resourceloader.loader.LoaderUtils;

public class ZipResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private static final long serialVersionUID = -7432641415119820243L;

    public ZipResourceData(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.key = resourceKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getResourceAsStream(ResourceManager resourceManager) throws ResourceLoadingException {
        ResourceKey resourceKey = this.key.getParent();
        ResourceData resourceData = resourceManager.load(resourceKey);
        ZipInputStream zipInputStream = new ZipInputStream(resourceData.getResourceAsStream(resourceManager));
        try {
            try {
                block7: {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    while (zipEntry != null) {
                        if (!zipEntry.getName().equals(this.key.getIdentifier())) {
                            zipEntry = zipInputStream.getNextEntry();
                            continue;
                        }
                        break block7;
                    }
                    throw new ResourceLoadingException("The zip-file did not contain the specified entry");
                }
                ZipInputStream zipInputStream2 = zipInputStream;
                return zipInputStream2;
            }
            finally {
                zipInputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new ResourceLoadingException("Reading the zip-file failed.", iOException);
        }
    }

    @Override
    public Object getAttribute(String string) {
        if (string.equals("filename")) {
            return LoaderUtils.getFileName((String)this.key.getIdentifier());
        }
        return null;
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }

    @Override
    public long getVersion(ResourceManager resourceManager) throws ResourceLoadingException {
        ResourceKey resourceKey = this.key.getParent();
        ResourceData resourceData = resourceManager.load(resourceKey);
        return resourceData.getVersion(resourceManager);
    }
}

