/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader.file;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class FileResourceData
extends AbstractResourceData {
    private ResourceKey key;
    private File file;
    private static final long serialVersionUID = -5719048997437795736L;

    public FileResourceData(ResourceKey resourceKey) throws ResourceLoadingException {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        File file = (File)resourceKey.getIdentifier();
        if (!file.isFile()) {
            throw new ResourceLoadingException("File-handle given does not point to a regular file.");
        }
        if (!file.canRead()) {
            throw new ResourceLoadingException("File '" + file + "' is not readable.");
        }
        this.key = resourceKey;
        this.file = file;
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager resourceManager) throws ResourceLoadingException {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceLoadingException("Unable to open Stream: ", fileNotFoundException);
        }
    }

    @Override
    public Object getAttribute(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("filename")) {
            return this.file.getName();
        }
        if (string.equals("content-length")) {
            return new Long(this.file.length());
        }
        return null;
    }

    @Override
    public long getVersion(ResourceManager resourceManager) throws ResourceLoadingException {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        return this.file.lastModified();
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }
}

