/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.loader.AbstractResourceData;

public class URLResourceData
extends AbstractResourceData {
    private long modificationDate;
    private String filename;
    private Long contentLength;
    private String contentType;
    private boolean metaDataOK;
    private URL url;
    private ResourceKey key;
    private static final long serialVersionUID = -7183025686032509509L;

    public URLResourceData(ResourceKey resourceKey) {
        if (resourceKey == null) {
            throw new NullPointerException();
        }
        this.key = resourceKey;
        this.url = (URL)resourceKey.getIdentifier();
        this.filename = IOUtils.getInstance().getFileName(this.url);
    }

    private void readMetaData() throws IOException {
        URLConnection uRLConnection = this.url.openConnection();
        uRLConnection.setDoOutput(false);
        uRLConnection.setAllowUserInteraction(false);
        if (uRLConnection instanceof HttpURLConnection) {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setRequestMethod("HEAD");
        }
        uRLConnection.connect();
        this.modificationDate = uRLConnection.getDate();
        this.contentLength = new Long(uRLConnection.getContentLength());
        this.contentType = uRLConnection.getHeaderField("content-type");
        uRLConnection.getInputStream().close();
        this.metaDataOK = true;
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager resourceManager) throws ResourceLoadingException {
        try {
            URLConnection uRLConnection = this.url.openConnection();
            uRLConnection.setDoOutput(false);
            uRLConnection.setAllowUserInteraction(false);
            return uRLConnection.getInputStream();
        }
        catch (IOException iOException) {
            throw new ResourceLoadingException("Failed to open URL connection", iOException);
        }
    }

    @Override
    public Object getAttribute(String string) {
        if (string.equals("filename")) {
            return this.filename;
        }
        if (string.equals("content-length")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentLength;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        if (string.equals("content-type")) {
            try {
                if (!this.metaDataOK) {
                    this.readMetaData();
                }
                return this.contentType;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public long getVersion(ResourceManager resourceManager) throws ResourceLoadingException {
        try {
            this.readMetaData();
            return this.modificationDate;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    @Override
    public ResourceKey getKey() {
        return this.key;
    }
}

