/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.loader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractResourceData
implements ResourceData,
Serializable {
    private static final long serialVersionUID = -2578855461270413802L;

    protected AbstractResourceData() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getResource(ResourceManager resourceManager) throws ResourceLoadingException {
        byte[] byArray;
        InputStream inputStream = this.getResourceAsStream(resourceManager);
        if (inputStream == null) {
            throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.getInstance().copyStreams(inputStream, (OutputStream)byteArrayOutputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (ResourceLoadingException resourceLoadingException) {
                throw resourceLoadingException;
            }
            catch (IOException iOException) {
                throw new ResourceLoadingException("Unable to read Stream: ", iOException);
            }
        }
        inputStream.close();
        return byArray;
    }

    @Override
    public long getLength() {
        Object object = this.getAttribute("content-length");
        if (object instanceof Number) {
            Number number = (Number)object;
            return number.longValue();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getResource(ResourceManager resourceManager, byte[] byArray, long l, int n) throws ResourceLoadingException {
        int n2;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if ((long)byArray.length < l + (long)n) {
            throw new IndexOutOfBoundsException();
        }
        InputStream inputStream = this.getResourceAsStream(resourceManager);
        if (inputStream == null) {
            throw new ResourceLoadingException("Unable to read Stream: No input stream: " + this.getKey());
        }
        try {
            if (l > 0L) {
                long l2 = l;
                long l3 = inputStream.skip(l2);
                l2 -= l3;
                while (l3 > 0L && l2 > 0L) {
                    l3 = inputStream.skip(l);
                    l2 -= l3;
                }
                if (l2 > 0L) {
                    throw new ResourceLoadingException("Unable to read Stream: Skipping content failed: " + this.getKey());
                }
            }
            int n3 = n;
            int n4 = inputStream.read(byArray, n - n3, n3);
            while (n4 > -1 && n3 > 0) {
                n4 = inputStream.read(byArray, n - (n3 -= n4), n3);
            }
            n2 = n - n4;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (ResourceLoadingException resourceLoadingException) {
                throw resourceLoadingException;
            }
            catch (IOException iOException) {
                throw new ResourceLoadingException("Unable to read Stream: ", iOException);
            }
        }
        inputStream.close();
        return n2;
    }
}

