/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory.image;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.factory.AbstractFactoryModule;

public class JPEGImageFactoryModule
extends AbstractFactoryModule {
    private static final int[] FINGERPRINT_1 = new int[]{255, 216, 255, 224};
    private static final int[] FINGERPRINT_2 = new int[]{74, 70, 73, 70, 0};
    private static final String[] MIMETYPES = new String[]{"image/jpeg", "image/jpg", "image/jp_", "application/jpg", "application/x-jpg", "image/pjpeg", "image/pipeg", "image/vnd.swiftview-jpeg", "image/x-xbitmap"};
    private static final String[] FILEEXTENSIONS = new String[]{".jpg", ".jpeg"};
    private static final int[] EMPTY_ARRAY = new int[0];

    @Override
    public int getHeaderFingerprintSize() {
        return -1;
    }

    @Override
    protected boolean canHandleResourceByContent(InputStream inputStream) throws IOException {
        int n;
        int[] nArray = FINGERPRINT_1;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == inputStream.read()) continue;
            return false;
        }
        if (inputStream.read() == -1) {
            return false;
        }
        if (inputStream.read() == -1) {
            return false;
        }
        nArray = FINGERPRINT_2;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] == inputStream.read()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int[] getFingerPrint() {
        return EMPTY_ARRAY;
    }

    @Override
    protected String[] getMimeTypes() {
        return MIMETYPES;
    }

    @Override
    protected String[] getFileExtensions() {
        return FILEEXTENSIONS;
    }

    @Override
    public Resource create(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceLoadingException {
        long l = resourceData.getVersion(resourceManager);
        Image image = Toolkit.getDefaultToolkit().createImage(resourceData.getResource(resourceManager));
        return new SimpleResource(resourceData.getKey(), image, l);
    }
}

