/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory.image;

import java.awt.Image;
import java.awt.Toolkit;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;
import org.pentaho.reporting.libraries.resourceloader.factory.AbstractFactoryModule;

public class GIFImageFactoryModule
extends AbstractFactoryModule {
    private static final int[] FINGERPRINT = new int[]{71, 73, 70, 56};
    private static final String[] MIMETYPES = new String[]{"image/gif", "image/x-xbitmap", "image/gi_"};
    private static final String[] FILEEXTENSIONS = new String[]{".gif"};

    @Override
    public int getHeaderFingerprintSize() {
        return FINGERPRINT.length;
    }

    @Override
    protected int[] getFingerPrint() {
        return FINGERPRINT;
    }

    @Override
    protected String[] getMimeTypes() {
        return MIMETYPES;
    }

    @Override
    protected String[] getFileExtensions() {
        return FILEEXTENSIONS;
    }

    @Override
    public Resource create(ResourceManager resourceManager, ResourceData resourceData, ResourceKey resourceKey) throws ResourceLoadingException {
        long l = resourceData.getVersion(resourceManager);
        Image image = Toolkit.getDefaultToolkit().createImage(resourceData.getResource(resourceManager));
        return new SimpleResource(resourceData.getKey(), image, l);
    }
}

