/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.factory.drawable;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DrawableWrapper {
    private static final Log logger = LogFactory.getLog(DrawableWrapper.class);
    private static final Map drawables = Collections.synchronizedMap(new HashMap());
    private Object backend;
    private Method drawMethod;
    private Method getPreferredSizeMethod;
    private Method isKeepAspectRatioMethod;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Class[] EMPTY_PARAMS = new Class[0];
    private static final Class[] PARAMETER_TYPES = new Class[]{Graphics2D.class, Rectangle2D.class};

    public DrawableWrapper(Object object) {
        int n;
        if (object == null) {
            throw new NullPointerException("Drawable must not be null");
        }
        if (object instanceof DrawableWrapper) {
            throw new IllegalArgumentException("Cannot wrap around a drawable-wrapper");
        }
        Class<?> clazz = object.getClass();
        try {
            this.drawMethod = clazz.getMethod("draw", PARAMETER_TYPES);
            n = this.drawMethod.getModifiers();
            if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isStatic(n)) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("DrawMethod is not valid: " + clazz + '#' + this.drawMethod));
                }
                this.drawMethod = null;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)("The object is not a drawable: " + clazz));
            }
            this.drawMethod = null;
        }
        if (this.drawMethod != null) {
            try {
                this.isKeepAspectRatioMethod = clazz.getMethod("isPreserveAspectRatio", EMPTY_PARAMS);
                n = this.isKeepAspectRatioMethod.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isStatic(n) || !Boolean.TYPE.equals(this.isKeepAspectRatioMethod.getReturnType())) {
                    this.isKeepAspectRatioMethod = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                this.getPreferredSizeMethod = clazz.getMethod("getPreferredSize", EMPTY_PARAMS);
                int n2 = this.getPreferredSizeMethod.getModifiers();
                if (!Modifier.isPublic(n2) || Modifier.isAbstract(n2) || Modifier.isStatic(n2) || !Dimension2D.class.equals(this.getPreferredSizeMethod.getReturnType())) {
                    this.isKeepAspectRatioMethod = null;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        this.backend = object;
    }

    public Object getBackend() {
        return this.backend;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        block3: {
            if (this.drawMethod == null) {
                return;
            }
            try {
                this.drawMethod.invoke(this.backend, graphics2D, rectangle2D);
            }
            catch (Exception exception) {
                if (!logger.isDebugEnabled()) break block3;
                logger.warn((Object)"Invoking draw failed:", (Throwable)exception);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.getPreferredSizeMethod == null) {
            return null;
        }
        try {
            return (Dimension)this.getPreferredSizeMethod.invoke(this.backend, EMPTY_ARGS);
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Invoking getPreferredSize failed:", (Throwable)exception);
            }
            return null;
        }
    }

    public boolean isPreserveAspectRatio() {
        if (this.isKeepAspectRatioMethod == null) {
            return false;
        }
        try {
            return Boolean.TRUE.equals(this.isKeepAspectRatioMethod.invoke(this.backend, EMPTY_ARGS));
        }
        catch (Exception exception) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)"Invoking isPreserveAspectRatio failed:", (Throwable)exception);
            }
            return false;
        }
    }

    public static boolean isDrawable(Object object) {
        if (object == null) {
            throw new NullPointerException("A <null> value can never be a drawable.");
        }
        String string = object.getClass().getName();
        Boolean bl = (Boolean)drawables.get(string);
        if (bl != null) {
            return bl;
        }
        boolean bl2 = DrawableWrapper.computeIsDrawable(object);
        if (bl2) {
            drawables.put(string, Boolean.TRUE);
        } else {
            drawables.put(string, Boolean.FALSE);
        }
        return bl2;
    }

    private static boolean computeIsDrawable(Object object) {
        Class<?> clazz = object.getClass();
        try {
            Method method = clazz.getMethod("draw", PARAMETER_TYPES);
            int n = method.getModifiers();
            return Modifier.isPublic(n) && !Modifier.isAbstract(n) && !Modifier.isStatic(n);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }
}

