/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.cache.CachingResourceData;
import org.pentaho.reporting.libraries.resourceloader.cache.DefaultResourceDataCacheEntry;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCache;
import org.pentaho.reporting.libraries.resourceloader.cache.ResourceDataCacheEntry;

public class NullResourceDataCache
implements ResourceDataCache {
    private Reference lastEntry;

    @Override
    public ResourceData put(ResourceManager resourceManager, ResourceData resourceData) throws ResourceLoadingException {
        ResourceData resourceData2 = CachingResourceData.createCached(resourceData);
        this.lastEntry = new WeakReference<DefaultResourceDataCacheEntry>(new DefaultResourceDataCacheEntry(resourceData2, resourceManager));
        return resourceData2;
    }

    @Override
    public ResourceDataCacheEntry get(ResourceKey resourceKey) {
        if (this.lastEntry != null) {
            ResourceDataCacheEntry resourceDataCacheEntry = (ResourceDataCacheEntry)this.lastEntry.get();
            if (resourceDataCacheEntry != null && resourceKey.equals(resourceDataCacheEntry.getData().getKey())) {
                return resourceDataCacheEntry;
            }
            this.lastEntry = null;
        }
        return null;
    }

    @Override
    public void remove(ResourceData resourceData) {
    }

    @Override
    public void clear() {
        this.lastEntry = null;
    }

    @Override
    public void shutdown() {
        this.lastEntry = null;
    }
}

