/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.reporting.libraries.resourceloader.ResourceBundleData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class CachingResourceBundleData
implements ResourceBundleData,
Serializable {
    private static final int CACHE_THRESHOLD = 524288;
    private ResourceBundleData data;
    private HashMap attributes;
    private transient byte[] rawData;
    private static final long serialVersionUID = -7272527822440412818L;

    public CachingResourceBundleData(ResourceBundleData resourceBundleData) {
        if (resourceBundleData == null) {
            throw new NullPointerException();
        }
        this.data = resourceBundleData;
    }

    @Override
    public InputStream getResourceAsStream(ResourceManager resourceManager) throws ResourceLoadingException {
        byte[] byArray = this.getResource(resourceManager);
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public long getLength() {
        if (this.rawData != null) {
            return this.rawData.length;
        }
        return this.data.getLength();
    }

    @Override
    public synchronized byte[] getResource(ResourceManager resourceManager) throws ResourceLoadingException {
        if (this.rawData == null) {
            this.rawData = this.data.getResource(resourceManager);
        }
        return (byte[])this.rawData.clone();
    }

    @Override
    public synchronized int getResource(ResourceManager resourceManager, byte[] byArray, long l, int n) throws ResourceLoadingException {
        int n2;
        int n3;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if ((long)byArray.length < l + (long)n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.rawData == null) {
            this.rawData = this.data.getResource(resourceManager);
        }
        if ((n3 = Math.min(this.rawData.length - (n2 = (int)(Integer.MAX_VALUE & l)), n)) <= 0) {
            return -1;
        }
        System.arraycopy(this.rawData, n2, byArray, 0, n3);
        return n3;
    }

    @Override
    public synchronized Object getAttribute(String string) {
        Object object;
        if (this.attributes == null) {
            this.attributes = new HashMap();
        } else {
            object = this.attributes.get(string);
            if (object != null) {
                return object;
            }
        }
        object = this.data.getAttribute(string);
        if (object != null) {
            this.attributes.put(string, object);
        }
        return object;
    }

    @Override
    public ResourceKey getKey() {
        return this.data.getKey();
    }

    @Override
    public long getVersion(ResourceManager resourceManager) throws ResourceLoadingException {
        return this.data.getVersion(resourceManager);
    }

    @Override
    public ResourceKey getBundleKey() {
        return this.data.getBundleKey();
    }

    @Override
    public ResourceBundleData deriveData(ResourceKey resourceKey) throws ResourceLoadingException {
        return this.data.deriveData(resourceKey);
    }

    public static ResourceBundleData createCached(ResourceBundleData resourceBundleData) {
        Number number;
        Object object = resourceBundleData.getAttribute("content-length");
        if (object instanceof Number && (number = (Number)object).intValue() < 524288) {
            return new CachingResourceBundleData(resourceBundleData);
        }
        return resourceBundleData;
    }
}

