/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui.event;

import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XCheckBox;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XListBox;
import com.sun.star.awt.XTextComponent;
import com.sun.star.awt.XTextListener;
import com.sun.star.lang.EventObject;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.ui.event.DataAware;
import com.sun.star.wizards.ui.event.DataAwareFields;

public class UnoDataAware
extends DataAware {
    protected Object unoControl;
    protected Object unoModel;
    protected String unoPropName;
    protected Object[] disableObjects = new Object[0];
    protected boolean inverse = false;

    protected UnoDataAware(Object object, DataAware.Value value, Object object2, String string) {
        super(object, value);
        this.unoControl = object2;
        this.unoModel = UnoDataAware.getModel(this.unoControl);
        this.unoPropName = string;
    }

    public void setInverse(boolean bl) {
        this.inverse = bl;
    }

    @Override
    protected void enableControls(Object object) {
        Boolean bl = this.getBoolean(object);
        if (this.inverse) {
            bl = bl != false ? Boolean.FALSE : Boolean.TRUE;
        }
        for (int i = 0; i < this.disableObjects.length; ++i) {
            UnoDataAware.setEnabled(this.disableObjects[i], bl);
        }
    }

    @Override
    protected void setToUI(Object object) {
        Helper.setUnoPropertyValue(this.unoModel, this.unoPropName, object);
    }

    private String stringof(Object object) {
        if (object.getClass().isArray()) {
            StringBuffer stringBuffer = new StringBuffer("[");
            for (int i = 0; i < ((short[])object).length; ++i) {
                stringBuffer.append(((short[])object)[i]).append(" , ");
            }
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return object.toString();
    }

    protected Boolean getBoolean(Object object) {
        if (object == null) {
            return Boolean.FALSE;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object.getClass().isArray()) {
            return ((short[])object).length != 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        if (object.equals("")) {
            return Boolean.FALSE;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() == 0 ? Boolean.TRUE : Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void disableControls(Object[] objectArray) {
        this.disableObjects = objectArray;
    }

    @Override
    protected Object getFromUI() {
        return Helper.getUnoPropertyValue(this.unoModel, this.unoPropName);
    }

    private static UnoDataAware attachTextControl(Object object, String string, Object object2, final DataAware.Listener listener, String string2, boolean bl, Object object3) {
        XTextComponent xTextComponent = (XTextComponent)UnoRuntime.queryInterface(XTextComponent.class, (Object)object2);
        final UnoDataAware unoDataAware = new UnoDataAware(object, bl ? DataAwareFields.getFieldValueFor(object, string, object3) : new DataAware.PropertyValue(string, object), xTextComponent, string2);
        xTextComponent.addTextListener(new XTextListener(){

            public void textChanged(TextEvent textEvent) {
                unoDataAware.updateData();
                if (listener != null) {
                    listener.eventPerformed(textEvent);
                }
            }

            public void disposing(EventObject eventObject) {
            }
        });
        return unoDataAware;
    }

    public static UnoDataAware attachEditControl(Object object, String string, Object object2, DataAware.Listener listener, boolean bl) {
        return UnoDataAware.attachTextControl(object, string, object2, listener, "Text", bl, "");
    }

    public static UnoDataAware attachDateControl(Object object, String string, Object object2, DataAware.Listener listener, boolean bl) {
        return UnoDataAware.attachTextControl(object, string, object2, listener, "Date", bl, new Integer(0));
    }

    public static UnoDataAware attachTimeControl(Object object, String string, Object object2, DataAware.Listener listener, boolean bl) {
        return UnoDataAware.attachTextControl(object, string, object2, listener, "Time", bl, new Integer(0));
    }

    public static UnoDataAware attachNumericControl(Object object, String string, Object object2, DataAware.Listener listener, boolean bl) {
        return UnoDataAware.attachTextControl(object, string, object2, listener, "Value", bl, new Double(0.0));
    }

    public static UnoDataAware attachCheckBox(Object object, String string, Object object2, DataAware.Listener listener, boolean bl) {
        XCheckBox xCheckBox = (XCheckBox)UnoRuntime.queryInterface(XCheckBox.class, (Object)object2);
        UnoDataAware unoDataAware = new UnoDataAware(object, bl ? DataAwareFields.getFieldValueFor(object, string, new Short(0)) : new DataAware.PropertyValue(string, object), object2, "State");
        xCheckBox.addItemListener(UnoDataAware.itemListener(unoDataAware, listener));
        return unoDataAware;
    }

    static XItemListener itemListener(final DataAware dataAware, final DataAware.Listener listener) {
        return new XItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                dataAware.updateData();
                if (listener != null) {
                    listener.eventPerformed(itemEvent);
                }
            }

            public void disposing(EventObject eventObject) {
            }
        };
    }

    public static UnoDataAware attachLabel(Object object, String string, Object object2, DataAware.Listener listener, boolean bl) {
        return new UnoDataAware(object, bl ? DataAwareFields.getFieldValueFor(object, string, "") : new DataAware.PropertyValue(string, object), object2, "Label");
    }

    public static UnoDataAware attachListBox(Object object, String string, Object object2, DataAware.Listener listener, boolean bl) {
        XListBox xListBox = (XListBox)UnoRuntime.queryInterface(XListBox.class, (Object)object2);
        UnoDataAware unoDataAware = new UnoDataAware(object, bl ? DataAwareFields.getFieldValueFor(object, string, new short[0]) : new DataAware.PropertyValue(string, object), object2, "SelectedItems");
        xListBox.addItemListener(UnoDataAware.itemListener(unoDataAware, listener));
        return unoDataAware;
    }

    public static Object getModel(Object object) {
        return ((XControl)UnoRuntime.queryInterface(XControl.class, (Object)object)).getModel();
    }

    public static void setEnabled(Object object, boolean bl) {
        UnoDataAware.setEnabled(object, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public static void setEnabled(Object object, Boolean bl) {
        Helper.setUnoPropertyValue(UnoDataAware.getModel(object), "Enabled", bl);
    }
}

