/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: keyset.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:28:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ADC_DISPLAY_KEYSET_HXX
#define ADC_DISPLAY_KEYSET_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/path.hxx>
	// COMPONENTS
	// PARAMETERS
#include <cosv/template/tpltools.hxx>
#include <udm/i_struct.hxx>

namespace udm
{


template <class ORIGIN>
class KeySet
{
  public:
    // LIFECYCLE
                        KeySet();
                        ~KeySet();
    void                add_key(
                            int                 i_nId,
                            DYN Path &          let_drPath );

    // OPERATIONS
    Object              search_by_key(
                            int                 i_id,
                            const TStruct<ORIGIN> &
                                                i_rData ) const;
  private:
    // DATA
    std::map< int, DYN udm::Path * >
                        aMap;
};



// IMPLEMENTATION

template <class ORIGIN>
KeySet<ORIGIN>::KeySet()
    :   aMap()
{
}

template <class ORIGIN>
KeySet<ORIGIN>::~KeySet()
{
    csv::erase_map_of_heap_ptrs(aMap);
}

template <class ORIGIN>
void
KeySet<ORIGIN>::add_key( int                 i_nId,
                         DYN Path &          let_drPath )
{
    aMap[i_nId] = &let_drPath;
}

template <class ORIGIN>
udm::Object
KeySet<ORIGIN>::search_by_key( int                     i_id,
                               const TStruct<ORIGIN> & i_rData ) const
{
    const udm::Path * pPath = csv::value_from_map( aMap, i_id );
    if (pPath == 0 )
        return udm::Object();

    return (*pPath)( i_rData );
}




}   // namespace udm



#endif


