/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svdogrp.hxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:48:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVDOGRP_HXX
#define _SVDOGRP_HXX

#ifndef _DATETIME_HXX //autogen
#include <tools/datetime.hxx>
#endif

#ifndef _SVDOBJ_HXX
#include <svx/svdobj.hxx>
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

//************************************************************
//   Vorausdeklarationen
//************************************************************

//BFS01class ImpSdrObjGroupLink;
class SdrObjList;
class SdrObjListIter;
class SfxItemSet;

//************************************************************
//   Defines
//************************************************************

//BFS01#define SDRUSERDATA_OBJGROUPLINK	0

//************************************************************
//   Hilfsklasse ImpSdrObjGroupLinkUserData
//************************************************************

//BFS01class ImpSdrObjGroupLinkUserData : public SdrObjUserData
//BFS01{
//BFS01	friend class				SdrObjGroup;
//BFS01	friend class				ImpSdrObjGroupLink;
//BFS01
//BFS01	SdrObject*					pObj;
//BFS01	String						aFileName;   // Name des referenzierten Dokuments
//BFS01	XubString					aObjName;    // Name des referenzierten Objekts
//BFS01	DateTime					aFileDate0;  // Unnoetiges neuladen vermeiden
//BFS01	Rectangle					aSnapRect0;  // Letztes bekanntes SnapRect des Originals
//BFS01	long						nDrehWink0;  // Letzter bekannter Drehwinkel des Originals
//BFS01	long						nShearWink0; // Letzter bekannter Shearwinkel des Originals
//BFS01
//BFS01	ImpSdrObjGroupLink*			pLink;
//BFS01	ULONG						nObjNum;     // des referenzierten Objekts
//BFS01	USHORT						nPageNum;    // zum schnelleren wiederauffinden
//BFS01	FASTBOOL					bMasterPage; // Liegt im Referenzdokoment auf einer Masterpage
//BFS01
//BFS01	FASTBOOL					bOrigPos;    // Objekt hat immer die Position des Referenzobjekts
//BFS01	FASTBOOL					bOrigSize;   // Objekt hat immer die Groesse des Referenzobjekts
//BFS01	FASTBOOL					bOrigRotate; // Objekt hat immer die Drehung des Referenzobjekts
//BFS01	FASTBOOL					bOrigShear;  // Objekt hat immer den Shearwinkel des Referenzobjekts
//BFS01
//BFS01public:
//BFS01	TYPEINFO();
//BFS01
//BFS01	ImpSdrObjGroupLinkUserData(SdrObject* pObj1);
//BFS01	virtual ~ImpSdrObjGroupLinkUserData();
//BFS01
//BFS01	virtual SdrObjUserData* Clone(SdrObject* pObj1) const;
//BFS01	virtual void WriteData(SvStream& rOut);
//BFS01	virtual void ReadData(SvStream& rIn);
//BFS01	virtual void AfterRead();
//BFS01};

//************************************************************
//   SdrObjGroup
//************************************************************

class SVX_DLLPUBLIC SdrObjGroup : public SdrObject
{
	// BaseProperties section
	virtual sdr::properties::BaseProperties* CreateObjectSpecificProperties();

	// #110094# DrawContact section
private:
	virtual sdr::contact::ViewContact* CreateObjectSpecificViewContact();

//BFS01private:
//BFS01	friend class				ImpSdrObjGroupLink;
//BFS01	friend class				ImpSdrObjGroupLinkUserData;

protected:
	SdrObjList*					pSub;    // Subliste (Kinder)
	long						nDrehWink;
	long						nShearWink;

	String						aName;

	Point						aRefPoint; // Referenzpunkt innerhalb der Objektgruppe
	FASTBOOL					bRefPoint; // Ist ein RefPoint gesetzt?

private:
	//BFS01ImpSdrObjGroupLinkUserData* GetLinkUserData() const;
	//BFS01void ImpLinkAnmeldung();
	//BFS01void ImpLinkAbmeldung();

public:
	TYPEINFO();
	SdrObjGroup();
	virtual ~SdrObjGroup();

	// Folgende 5 Methoden zur Verwendung von Verknuepfungen zu Gruppenobjekten
	// in fremden Dokumenten.
	// !!! Derzeit werden noch keine Ringreferenzen abgefangen !!!
	// GruppenLinks koennen durchaus selber auch gruppiert werden. Nach betreten
	// einer gelinkten Gruppe kann zwar noch selektiert, jedoch nichts mehr
	// veraendert werden (ReadOnly). Das Referenzgruppenobjekt im fremden
	// Dokument darf nicht gruppiert sein, muss sich also immer auf dem Root-
	// Level der Page befinden.
	// Transformationen auf den gesamten Gruppenlink sind zwar vorgesehen,
	// jedoch noch nicht implementiert.
	// Zur Verwendung von GruppenLinks muessen die Methoden
	//   virtual const SdrModel* SdrModel::LoadModel(const String& rFileName);
	//   virtual const SdrModel* SdrModel::DisposeLoadedModels();
	// ueberladen werden (siehe SvdModel.HXX), die ein neues Model alloziiert
	// und in den Speicher laed bzw. zuvor geladene Models verwirft.
	// Ansonsten muss die App I.d.R. nur SetGroupLink() rufen - der Rest geschieht
	// von selbst (SfxLinkManager). Die Methode LoadGroup() kann ausserdem
	// verwendet werden, um eine benannte Gruppe aus einem fremden Dokument zu
	// laden (ohne Verknuepfung).
	//BFS01void SetGroupLink(const String& rFileName, const String& rObjName);
	//BFS01void ReleaseGroupLink();
	//BFS01FASTBOOL IsLinkedGroup() const { return pPlusData!=NULL && GetLinkUserData()!=NULL; }
	//BFS01FASTBOOL ReloadLinkedGroup(FASTBOOL bForceLoad=FALSE);

	// pnPgNum, etc. ist zum schnelleren wiederauffinden gedacht
	//BFS01FASTBOOL LoadGroup(const String& rFileName, const String& rObjName, USHORT* pnPgNum=NULL, FASTBOOL* pbMasterPg=NULL, ULONG* pnObjNum=NULL);

	virtual UINT16 GetObjIdentifier() const;
	virtual void TakeObjInfo(SdrObjTransformInfoRec& rInfo) const;
	virtual SdrLayerID GetLayer() const;
	virtual void NbcSetLayer(SdrLayerID nLayer);
	virtual void SetObjList(SdrObjList* pNewObjList);
	virtual void SetPage(SdrPage* pNewPage);
	virtual void SetModel(SdrModel* pNewModel);
	virtual FASTBOOL HasRefPoint() const;
	virtual Point GetRefPoint() const;
	virtual void SetRefPoint(const Point& rPnt);
	virtual SdrObjList* GetSubList() const;

	virtual const Rectangle& GetCurrentBoundRect() const;
	virtual const Rectangle& GetSnapRect() const;

	// #110094#-13
	// virtual FASTBOOL Paint(XOutputDevice& rOut, const SdrPaintInfoRec& rInfoRec) const;

	virtual SdrObject* CheckHit(const Point& rPnt, USHORT nTol, const SetOfByte* pVisiLayer) const;
	virtual void operator=(const SdrObject& rObj);

	virtual void TakeObjNameSingul(String& rName) const;
	virtual void TakeObjNamePlural(String& rName) const;

	virtual FASTBOOL HasSetName() const;

	virtual void SetName(const String& rStr);
	virtual String GetName() const;

	virtual void RecalcSnapRect();
	virtual void TakeXorPoly(XPolyPolygon& rPoly, FASTBOOL bDetail) const;
	//#110094#-12	
	//virtual void TakeContour(XPolyPolygon& rXPoly, SdrContourType eType) const;

	virtual FASTBOOL BegDrag(SdrDragStat& rDrag)  const;
	virtual FASTBOOL BegCreate(SdrDragStat& rStat);

	virtual long GetRotateAngle() const;
	virtual long GetShearAngle(FASTBOOL bVertical=FALSE) const;

	virtual void Move(const Size& rSiz);
	virtual void Resize(const Point& rRef, const Fraction& xFact, const Fraction& yFact);
	virtual void Rotate(const Point& rRef, long nWink, double sn, double cs);
	virtual void Mirror(const Point& rRef1, const Point& rRef2);
	virtual void Shear(const Point& rRef, long nWink, double tn, FASTBOOL bVShear);
	virtual void SetAnchorPos(const Point& rPnt);
	virtual void SetRelativePos(const Point& rPnt);
	virtual void SetSnapRect(const Rectangle& rRect);
	virtual void SetLogicRect(const Rectangle& rRect);

	virtual void NbcMove(const Size& rSiz);
	virtual void NbcResize(const Point& rRef, const Fraction& xFact, const Fraction& yFact);
	virtual void NbcRotate(const Point& rRef, long nWink, double sn, double cs);
	virtual void NbcMirror(const Point& rRef1, const Point& rRef2);
	virtual void NbcShear(const Point& rRef, long nWink, double tn, FASTBOOL bVShear);
	virtual void NbcSetAnchorPos(const Point& rPnt);
	virtual void NbcSetRelativePos(const Point& rPnt);
	virtual void NbcSetSnapRect(const Rectangle& rRect);
	virtual void NbcSetLogicRect(const Rectangle& rRect);

	virtual void NbcReformatText();
	virtual void ReformatText();

	virtual SdrObject* DoConvertToPolyObj(BOOL bBezier) const;

	//BFS01virtual void WriteData(SvStream& rOut) const;
	//BFS01virtual void ReadData(const SdrObjIOHeader& rHead, SvStream& rIn);
	//BFS01virtual void AfterRead();
};

#endif //_SVDOGRP_HXX

