/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tabdlg.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 11:31:35 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SV_TABDLG_HXX
#define _SV_TABDLG_HXX

#ifndef _SV_SV_H
#include <vcl/sv.h>
#endif
#ifndef _VCL_DLLAPI_H
#include <vcl/dllapi.h>
#endif

#ifndef _SV_DIALOG_HXX
#include <vcl/dialog.hxx>
#endif

class FixedLine;

// ----------------------
// - TabDialog -
// ----------------------

class VCL_DLLPUBLIC TabDialog : public Dialog
{
private:
	FixedLine*			mpFixedLine;
	Window* 			mpViewWindow;
	WindowAlign 		meViewAlign;
	BOOL				mbPosControls;

	SAL_DLLPRIVATE void	ImplInitData();
	SAL_DLLPRIVATE void	ImplPosControls();

public:
						TabDialog( Window* pParent,
								   WinBits nStyle = WB_STDTABDIALOG );
						TabDialog( Window* pParent, const ResId& rResId );
						~TabDialog();

	virtual void		Resize();
	virtual void		StateChanged( StateChangedType nStateChange );

	void				AdjustLayout();

	void				SetViewWindow( Window* pWindow ) { mpViewWindow = pWindow; }
	Window* 			GetViewWindow() const { return mpViewWindow; }
	void				SetViewAlign( WindowAlign eAlign ) { meViewAlign = eAlign; }
	WindowAlign 		GetViewAlign() const { return meViewAlign; }
};

#endif	// _SV_TABDLG_HXX
