/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: genericunodialog.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:33:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVT_GENERICUNODIALOG_HXX_
#define _SVT_GENERICUNODIALOG_HXX_

#ifndef INCLUDED_SVTDLLAPI_H
#include "svtools/svtdllapi.h"
#endif

#ifndef _CPPUHELPER_IMPLBASE2_HXX_
#include <cppuhelper/implbase3.hxx>
#endif
#ifndef _CPPUHELPER_PROPSHLP_HXX
#include <cppuhelper/propshlp.hxx>
#endif
#ifndef _COMPHELPER_PROPERTY_ARRAY_HELPER_HXX_
#include <comphelper/proparrhlp.hxx>
#endif
#ifndef _COMPHELPER_UNO3_HXX_
#include <comphelper/uno3.hxx>
#endif
#ifndef _COMPHELPER_PROPERTYCONTAINER_HXX_
#include <comphelper/propertycontainer.hxx>
#endif
#ifndef _COMPHELPER_BROADCASTHELPER_HXX_
#include <comphelper/broadcasthelper.hxx>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XWINDOW_HPP_
#include <com/sun/star/awt/XWindow.hpp>
#endif
#ifndef _COM_SUN_STAR_UI_DIALOGS_XEXECUTABLEDIALOG_HPP_
#include <com/sun/star/ui/dialogs/XExecutableDialog.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

class Dialog;
class Window;

//.........................................................................
namespace svt
{
//.........................................................................

	//=========================================================================
#define		UNODIALOG_PROPERTY_ID_TITLE		1
#define		UNODIALOG_PROPERTY_ID_PARENT	2

#define		UNODIALOG_PROPERTY_TITLE		"Title"
#define		UNODIALOG_PROPERTY_PARENT		"ParentWindow"

	//=========================================================================
	typedef	::cppu::WeakImplHelper3	<	com::sun::star::ui::dialogs::XExecutableDialog
									,	com::sun::star::lang::XServiceInfo
									,	com::sun::star::lang::XInitialization
									>	OGenericUnoDialogBase;

	/**	abstract base class for implementing UNO objects representing dialogs (<type scope="com.sun.star.awt">XDialog</type>)
	*/
	class SVT_DLLPUBLIC OGenericUnoDialog
			:public OGenericUnoDialogBase
			,public ::comphelper::OMutexAndBroadcastHelper
			,public ::comphelper::OPropertyContainer
	{
	private:
		::osl::Mutex					m_aExecutionMutex;	/// acess safety for execute/cancel

	protected:
		Dialog*						m_pDialog;			/// the dialog to execute
		sal_Bool					m_bExecuting : 1;	/// we're currently executing the dialog
		sal_Bool					m_bCanceled : 1;	/// endDialog was called while we were executing
		sal_Bool					m_bTitleAmbiguous : 1;	/// m_sTitle has not been set yet

		// <properties>
		::rtl::OUString							m_sTitle;	/// title of the dialog
		com::sun::star::uno::Reference<com::sun::star::awt::XWindow>	m_xParent;	/// parent window
		// </properties>

		com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >
									m_xORB;

	protected:
		OGenericUnoDialog(const com::sun::star::uno::Reference< com::sun::star::lang::XMultiServiceFactory >& _rxORB);
		~OGenericUnoDialog();

	public:
		// UNO
		DECLARE_UNO3_DEFAULTS(OGenericUnoDialog, OGenericUnoDialogBase);
		virtual com::sun::star::uno::Any SAL_CALL queryInterface(const com::sun::star::uno::Type& _rType) throw (com::sun::star::uno::RuntimeException);

		// XTypeProvider
		virtual com::sun::star::uno::Sequence<com::sun::star::uno::Type> SAL_CALL getTypes(  ) throw(com::sun::star::uno::RuntimeException);
		virtual com::sun::star::uno::Sequence<sal_Int8> SAL_CALL getImplementationId(  ) throw(com::sun::star::uno::RuntimeException) = 0;

		// XServiceInfo
		virtual ::rtl::OUString SAL_CALL getImplementationName() throw(com::sun::star::uno::RuntimeException) = 0;
		virtual sal_Bool SAL_CALL supportsService(const ::rtl::OUString& ServiceName) throw(com::sun::star::uno::RuntimeException);
		virtual ::comphelper::StringSequence SAL_CALL getSupportedServiceNames() throw(com::sun::star::uno::RuntimeException) = 0;

		// OPropertySetHelper
		virtual void SAL_CALL setFastPropertyValue_NoBroadcast( sal_Int32 nHandle, const com::sun::star::uno::Any& rValue ) throw(com::sun::star::uno::Exception);
		virtual sal_Bool SAL_CALL convertFastPropertyValue( com::sun::star::uno::Any& rConvertedValue, com::sun::star::uno::Any& rOldValue, sal_Int32 nHandle, const com::sun::star::uno::Any& rValue) throw(com::sun::star::lang::IllegalArgumentException);

		// XExecutableDialog
		virtual void SAL_CALL setTitle( const ::rtl::OUString& aTitle ) throw(::com::sun::star::uno::RuntimeException);
		virtual sal_Int16 SAL_CALL execute(  ) throw(::com::sun::star::uno::RuntimeException);

		// XInitialization
		virtual void SAL_CALL initialize( const com::sun::star::uno::Sequence< com::sun::star::uno::Any >& aArguments ) throw(com::sun::star::uno::Exception, com::sun::star::uno::RuntimeException);

	protected:
		/** create the concret dialog instance. note that m_aMutex is not locked when this method get's called,
			but the application-wide solar mutex is (to guard the not thread-safe ctor of the dialog).
			@param		pParent		the parent window for the new dialog
		*/
		virtual Dialog*	createDialog(Window* _pParent) = 0;

		/// called to destroy the dialog used. the default implementation just deletes m_pDialog and resets it to NULL
		virtual void destroyDialog();

		/**	called after the dialog has been executed
			@param		_nExecutionResult		the execution result as returned by Dialog::Execute
		*/
		virtual void executedDialog(sal_Int16 _nExecutionResult) { }

		/** smaller form of <method>initialize</method>.<p/>
			The <method>initialize</method> method is called with a sequence of <type scope="com.sun.star.uno">Any</type>'s,
			which is split up into the single elements, which are passed to implInitialize. The default implementation
			tries to exract an <type scope="com.sun.star.beans">PropertyValue</type> from the value an pass it to the
			<type scope="com.sun.star.beans">XPropertySet</type> interface of the object.
		*/
		virtual void implInitialize(const com::sun::star::uno::Any& _rValue);
	};

//.........................................................................
}	// namespace svt
//.........................................................................

#endif // _SVT_GENERICUNODIALOG_HXX_

