<?php
/* ----------------------------------------
headに表示されるタグなどを削除
---------------------------------------- */
remove_action('wp_head', 'wp_generator');
remove_action('wp_head', 'rsd_link');
remove_action('wp_head', 'wlwmanifest_link');
remove_action('wp_head', 'wp_shortlink_wp_head');
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head');
remove_action('wp_head', 'feed_links_extra', 3);

/* ----------------------------------------
ウィジェット
---------------------------------------- */
function widget_create() {
	$sidebars = array(1, 2, 3);
	foreach($sidebars as $number) {
		register_sidebar(
			array(
				'name' => 'widget-area' . $number,
				'id' => 'widget-area' . $number,
				'before_widget' => '<nav>',
				'after_widget' => '</nav>',
				'before_title' => '<div class="heading">',
				'after_title' => '</div>'
			)
		);
	}
}
add_action( 'widgets_init', 'widget_create' );

function get_current_term () {
	
	if(is_category()){
		$tax_slug = "category";
		$id = get_query_var('cat');	
	}else if(is_tag()){
		$tax_slug = "post_tag";
		$id = get_query_var('tag_id');	
	}else if(is_tax()){
		$tax_slug = get_query_var('taxonomy');	
		$term_slug = get_query_var('term');	
		$term = get_term_by("slug",$term_slug,$tax_slug);
		$id = $term->term_id;
	}

	return get_term($id,$tax_slug);
}
?>
