/*
 * Decompiled with CFR 0.152.
 */
package saccubus.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;

public class Mson {
    private JsonElement json;

    public Mson(JsonElement je) {
        this.json = je;
    }

    public String toString() {
        if (this.json == null) {
            return "[]";
        }
        return this.json.toString();
    }

    public static Mson parse(String text) throws Exception {
        JsonReader reader = new JsonReader((Reader)new StringReader(text));
        reader.setLenient(true);
        return new Mson(new JsonParser().parse(reader));
    }

    public void prettyPrint(PrintStream ps) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String js = gson.toJson(this.json);
        ps.println(js);
    }

    public static ArrayList<String[]> getListString(JsonElement json, String[] keys) throws Exception {
        ArrayList<String[]> ret = new ArrayList<String[]>();
        String[] rets = new String[keys.length];
        if (json.isJsonObject()) {
            JsonObject jo = json.getAsJsonObject();
            rets = new String[keys.length];
            for (Map.Entry ent : jo.entrySet()) {
                JsonElement val = (JsonElement)ent.getValue();
                boolean flag = false;
                int i = 0;
                while (i < keys.length) {
                    if (keys[i].equals(ent.getKey())) {
                        String s = val.toString();
                        if (val.isJsonPrimitive() && val.getAsJsonPrimitive().isString()) {
                            s = val.getAsString();
                        }
                        rets[i] = s;
                        flag = true;
                    }
                    ++i;
                }
                if (flag) continue;
                ret.addAll(Mson.getListString(val, keys));
            }
            if (rets[0] != null) {
                ret.add(rets);
            }
            return ret;
        }
        if (json.isJsonArray()) {
            JsonArray ja = json.getAsJsonArray();
            for (JsonElement je : ja) {
                ret.addAll(Mson.getListString(je, keys));
            }
            return ret;
        }
        return ret;
    }

    public ArrayList<String[]> getListString(String[] keys) throws Exception {
        return Mson.getListString(this.json, keys);
    }
}

