package shooting;

import static org.lwjgl.opengl.GL11.GL_BACK;
import static org.lwjgl.opengl.GL11.GL_BLEND;
import static org.lwjgl.opengl.GL11.GL_CULL_FACE;
import static org.lwjgl.opengl.GL11.GL_DEPTH_TEST;
import static org.lwjgl.opengl.GL11.GL_FRONT_AND_BACK;
import static org.lwjgl.opengl.GL11.GL_LINES;
import static org.lwjgl.opengl.GL11.GL_MODELVIEW;
import static org.lwjgl.opengl.GL11.GL_NORMALIZE;
import static org.lwjgl.opengl.GL11.GL_PROJECTION;
import static org.lwjgl.opengl.GL11.GL_QUADS;
import static org.lwjgl.opengl.GL11.GL_TEXTURE_2D;
import static org.lwjgl.opengl.GL11.glBegin;
import static org.lwjgl.opengl.GL11.glClear;
import static org.lwjgl.opengl.GL11.glClearColor;
import static org.lwjgl.opengl.GL11.glColor4f;
import static org.lwjgl.opengl.GL11.glCullFace;
import static org.lwjgl.opengl.GL11.glEnable;
import static org.lwjgl.opengl.GL11.glEnd;
import static org.lwjgl.opengl.GL11.glLoadIdentity;
import static org.lwjgl.opengl.GL11.glMatrixMode;
import static org.lwjgl.opengl.GL11.glOrtho;
import static org.lwjgl.opengl.GL11.glPolygonMode;
import static org.lwjgl.opengl.GL11.glPopMatrix;
import static org.lwjgl.opengl.GL11.glPushMatrix;
import static org.lwjgl.opengl.GL11.glRotatef;
import static org.lwjgl.opengl.GL11.glScalef;
import static org.lwjgl.opengl.GL11.glTranslatef;
import static org.lwjgl.opengl.GL11.glVertex3f;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import net.chocolapod.lwjgfont.LWJGFont;
import net.chocolapod.lwjgfont.mig1p.Migmix1pRegularH28Font;

import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Controller;
import org.lwjgl.input.Controllers;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;

import shooting.Enemy.State;
import shooting.EnemyGroup.CreateType;
import shooting.GameController.Input;
import shooting.Texture;

public class Main {
	//画面に関する変数の設定
	public static int         width = 1200;
	public static int         height =700;
	public static int         depth = 800;
	private String      title = "Yosimasa_Shooting";

	private static final int    MOVE_DISTANCE_PER_SECOND = 100;

	private long        time;
	private long        timeDelta;
	private long        fps;
	private long        calcedFps;
	private float scale;

	private TextureLoader   textureLoader;
	private LightManager    lightManager;

	//各キャラクターの変数の設定
	//自分のロケットなど
	public Model           myRocket;
	private long        actionTime;
	public static float       x;
	public static float       y;
	public static float rocketSize = 20;
	private float roll;
	private float rollInc = 1.5f;
	private float pitch;
	private float pitchInc = 0.5f;
	public int maxRocketNum = 3;
	public int myRocketNum = maxRocketNum;
	public static int aileronRoll;
	public int repeatLimit = 300;//エルロンロールするときのリミット（ミリ秒）
	private long keyRepeatTime;
	private float rocketScale;

	//敵
	//敵の種類の数はenumであるCreateTypeの要素の数を取得してくる
	public int enemyTypeNum = CreateType.values().length;
	public Model enemyModel[] = new Model[enemyTypeNum];
	public ArrayList<EnemyGroup> group = new ArrayList<EnemyGroup>();
	public static int enemyCreNum;
	public static int groupLife;
	public static int maxSpeed;
	public static int maxGroup;

	//背景用の星
	private Model starTile[] = new Model[4];
	public int starNum = 150;
	public BackGroundStar star[] = new BackGroundStar[starNum];

	//自分の弾丸
	private Model bulletModel;
	public static int bulletNum = 4;
	public static Bullet bullet[] = new Bullet[bulletNum];
	public int bulletInterval = 10 ;
	public int bulletIntervalCount = 0;
	public static float bulletSize = 3;
	public boolean circleOn;

	//爆発
	public Model explosionModel[] = new Model[3];
	public ArrayList<Explosion> explosion = new ArrayList<Explosion>();
	public static int explosionStandardNum = 20;

	//タイトル
	public Texture titleTexture;
	public Texture gameOver;
	public int titleCount = 0;
	private float titleRoll = 270;
	
	//ライト
	public float lightX = 0f;
	public float lightVX = 10f;
	public float lightY = height;
	public float lightVY = 3f;
	
	//コントローラー
	private List<GameController>  controllers;
	private int             controllerIndex;
	private GameController  controller;
	private GameController  keyboard;
	private boolean pauseOn;
	
	//効果音
	public static SoundManager2 soundManager;
	private int SOUND_SHOT;
	public static int SOUND_HIT;
	public static int SOUND_DAMAGED;
	public static int SOUND_BGM;
	public static int SOUND_BONUS;

	// LWJGFont を呼び出す
	LWJGFont font = new Migmix1pRegularH28Font();
	//スコア
	public static int score;
	//ゲームの状態を示す変数
	public enum Game{
		TITLE,
		PLAYING,
		DESTORIED,
		STARTING,
		GAMEOVER
	};
	static Game game;
	/* TITLE:ゲーム未開始
	 * PLAYING:プレイ中
	 * DESTORIED:自分のロケットがやられた時
	 * STARTING:スタート前
	 * GAMEOVER:ゲームオーバー
	 * 5:
	 * 6:
	 */
	//全体的な移動距離の調整
	public static int move;
	private boolean keyOn = false;
	private ArrayList<Bonus> bonus =new ArrayList<Bonus>();
	

	//////////////////////////////////////////////////////////////////////////////
	///////////////////////////////イニシャライズ//////////////////////////////////
	//////////////////////////////////////////////////////////////////////////////
	private void init() throws Exception {

		pauseOn = true;

		time = getMillisecond();
		fps = 0;

		textureLoader = new TextureLoader();

		lightManager = new LightManager();
		lightManager.initLight();

		//  ファイルのパス指定で画像を読み込む
		myRocket = ObjectLoader.load("MyRocket3.obj");
		myRocket.compile(textureLoader);

		for (CreateType c : CreateType.values()){
			switch (c){
			case COMMET:
				enemyModel[c.getId()] = ObjectLoader.load("EnemyCommet.obj");
				break;
			case T2VIRUS:
				enemyModel[c.getId()] = ObjectLoader.load("T2virus.obj");
				break;
			case ROCKET:
				enemyModel[c.getId()] = ObjectLoader.load("EnemyRocket.obj");
				break;
			case FISH:
				enemyModel[c.getId()] = ObjectLoader.load("fish2.obj");
				break;
			}
			enemyModel[c.getId()].compile(textureLoader);
		}// for CreateType
		
		starTile[0] =  ObjectLoader.load("StarTileYellow.obj");
		starTile[0].compile(textureLoader);
		starTile[1] =  ObjectLoader.load("StarTilePink.obj");
		starTile[1].compile(textureLoader);
		starTile[2] =  ObjectLoader.load("StarTileBlue.obj");
		starTile[2].compile(textureLoader);
		starTile[3] =  ObjectLoader.load("StarTileRed.obj");
		starTile[3].compile(textureLoader);

		bulletModel = ObjectLoader.load("Bullet.obj");
		bulletModel.compile(textureLoader);

		explosionModel[0] = ObjectLoader.load("Explosion_white.obj");
		explosionModel[0].compile(textureLoader);
		explosionModel[1] = ObjectLoader.load("Explosion_yellow.obj");
		explosionModel[1].compile(textureLoader);
		explosionModel[2] = ObjectLoader.load("Explosion_orange.obj");
		explosionModel[2].compile(textureLoader);

		//エクリプスで起動するときはgetClassLoaderは使えない。jarファイルの時はgetClassLoaderを使う。
		//なのでnullだった時にgetClassLoaderで再度読み込むようにした。
		try{
			titleTexture = textureLoader.loadTexture("images/" + "SpaceVacterian.png");
			gameOver = textureLoader.loadTexture("images/" + "gameover.png");
		}
		catch(FileNotFoundException e){
			System.out.println("loading by getClassLoader....");
			titleTexture = textureLoader.loadTexture("images/" + "SpaceVacterian.png", Main.class.getClassLoader());
			gameOver = textureLoader.loadTexture("images/" + "gameover.png", Main.class.getClassLoader());
		}
		//  MyRocketを初期化する
		actionTime = getMillisecond();
		x = width / 2;
		y = 50;
		roll = 0;
		aileronRoll = 0;
		rocketScale = 25;

		//  コントローラーを用意する
		controllers = new ArrayList<GameController>();
		try {
			Controllers.create();
			for (int i = 0; i < Controllers.getControllerCount(); i++) {
				Controller  controller = Controllers.getController(i);

				System.out.println("Detected controller(" + i + "): " + controller.getName());
				controllers.add(new JoyStick(controller));
			}
		} catch (LWJGLException e) {
			e.printStackTrace();
		}
		keyboard = new PcKeyboard();
		controllers.add(keyboard);

		controllerIndex = controllers.size() - 1;
		controller = controllers.get(controllerIndex);
		//最初はキーボードを入力デバイスとする。
		//controllerIndex = 0 〜: GamePad
		//controllerIndex = 最後: KeyBoard
		
		//弾丸を初期化
		for (int i=0; i<bulletNum; i++){
			bullet[i] = new Bullet();
		}

		//背景の星を初期化
		for (int i=0; i<starNum; i++){
			star[i] = new BackGroundStar();
		}

		//サウンドマネージャーはスペースインベーダーのチュートリアルからいただいてきた。
		// create our sound manager, and initialize it with 7 channels
		// 1 channel for sounds, 6 for effects - this should be enough
		// since we have a most 4 shots on screen at any one time, which leaves
		// us with 2 channels for explosions.
		soundManager = new SoundManager2();
		soundManager.initialize(8);

		// load our sound data
		//効果音は「sfxr」で作った。
		SOUND_SHOT   = soundManager.addSound("sounds/"+ "shoot4.wav");
		SOUND_HIT    = soundManager.addSound("sounds/"+ "explosion.wav");
		SOUND_DAMAGED = soundManager.addSound("sounds/"+ "myExplosion.wav");
		SOUND_BGM = soundManager.addSound("sounds/"+ "cosmoRunning.wav");
		SOUND_BONUS = soundManager.addSound("sounds/"+"bonus.wav");
	
		//openGLの初期化
		glPolygonMode(GL_FRONT_AND_BACK, GL_LINES);
		glEnable(GL_NORMALIZE);
	}

	////////////////////////////////////////////////////////////////////////
	////////////////////////////////////スタート////////////////////////////
	///////////////////////////////////////////////////////////////////////
	public void start() {
		try {
			//  ウインドウを生成する
			Display.setDisplayMode(new DisplayMode(width, height));
			Display.setTitle(title);
			Display.create();
		} catch(LWJGLException e) {
			e.printStackTrace();
			return;
		}

		try {
			//  OpenGL の初期設定

			//  オフスクリーンを初期化する際の背景色を指定する
			glClearColor(0f, 0f, 0f, 1f);

			//  テクスチャーを有効化する
			glEnable(GL_TEXTURE_2D);

			//  アルファブレンドを有効化する
			glEnable(GL_BLEND);

			//  ポリゴンの表示面を表のみに設定する
			glEnable(GL_CULL_FACE);
			glCullFace(GL_BACK);

			//  カメラ用の設定変更を宣言する
			glMatrixMode(GL_PROJECTION);
			//  設定を初期化する
			glLoadIdentity();
			//  視体積（目に見える範囲）を定義する
			glOrtho(0, width, 0, height, 0, depth);

			//  物体モデル用の設定変更を宣言する
			glMatrixMode(GL_MODELVIEW);

			//  デプステストを有効にする
			glEnable(GL_DEPTH_TEST);

			init();
			game = Game.TITLE;
			///////////////////////////////////////////////////////////////////////////////////////
			////////////////////////////////実質的メインループ//////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////////////////
			while (!Display.isCloseRequested()) {
				//  オフスクリーンを初期化する
				glClear(GL11.GL_COLOR_BUFFER_BIT | GL11.GL_DEPTH_BUFFER_BIT);

				//  キー入力を処理する
				updateControllers();

				//  FPS を計算する
				calcFps();

				switch(game){
				/* 0:ゲーム未開始
				 * 1:プレイ中
				 * 2:自分のロケットがやられた時
				 * 3:スタート前
				 * 4:ゲームオーバー
				 * 5:
				 * 6:
				 */
				case TITLE://ゲームタイトル
					gameTitle();

					break;
				case PLAYING://ゲームのプレイ中である
					playing();

					break;
				case DESTORIED://やられました
					damaging();

					break;
				case STARTING://戦闘開始
					hereWeGo();

					break;
				case GAMEOVER://ゲームオーバー
					gameover();
					break;
				}//switch
				//  オフスクリーンをスクリーンに反映する
				Display.update();

			}//while
			/////////////////////////////////////////////////////////////////////////////////////////
		} catch(Exception e) {
			e.printStackTrace();
		} finally {
			terminate();
			Display.destroy();
		}
	}//end of start()
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////各オブジェクトの移動など//////////////////
	///////////////////////////////////////////////////////////////////////////
	private void update(){
		//時間調整に必要な処理
		long    now = getMillisecond();
		long    delta = now - actionTime;
		move = (int)(MOVE_DISTANCE_PER_SECOND * (delta / 1000f));
		actionTime = now;
		Display.setTitle(title + "(" + calcedFps + "fps)");
		//  FPS を調整する
		Display.sync(60);
	}
	//////////////////////４：ゲームオーバー///////////////////////
	private void gameover() {
		update();
		starUpdate();

		render();
		renderStars();

		renderGameOver();

		if (Keyboard.isKeyDown(Keyboard.KEY_F5)){
			game = Game.TITLE;//タイトルにする。
		}
	}

	//////////////////////３：戦闘開始////////////////////////
	private void hereWeGo() {
		update();
		starUpdate();

		render();
		renderStars();
		renderText();

		x = width / 2;
		y = 50;
		roll = 0;
		group.add(new EnemyGroup(enemyCreNum, groupLife, maxSpeed));
		game = Game.PLAYING;
		soundManager.playSound(SOUND_BGM);

	}
	//////////////////////０：ゲームタイトル////////////////////////////
	private void gameTitle() {
		update();
		starUpdate();
		//入力デバイスの切換。F1キーで切り替え
		//タイトル画面の時のみ入力デバイスの切換ができる。
		if (keyboard.getKeyEvent() == Input.SELECT) {
			controllerIndex = (controllerIndex + 1) % controllers.size();
			controller = controllers.get(controllerIndex);
		}
/*
		lightManager.setLight(lightX, lightY , -100, 1);
		
		lightX += lightVX;
		lightY += lightVY;
		if (lightX > width) lightVX = -lightVX;
		if (lightX < 0) lightVX = -lightVX;
		if (lightY > height) lightVY = -lightVY;
		if (lightY < 300) lightVY = -lightVY;
*/		
		render();
		renderStars();
		renderTitle();
		
		//F2でゲーム開始
		if (controller.isPressing(Input.START)) {
			keyOn = true;
		}//押されて離したらゲーム開始
		if (!((controller.isPressing(Input.START))) && keyOn ){
			keyOn = false;
			//ゲームをリセットする。
			lightManager.setLight(-100,800,10,1);
			score = 0;
			myRocketNum = maxRocketNum;
			group.removeAll(group);
			enemyCreNum = 5;
			groupLife = 500;
			maxSpeed = 4;
			maxGroup = 1;

			game = Game.STARTING;//ゲームを始める
		
		}
	}

	//////////////////////２：やられました//////////////////////////////////
	private void damaging() {
		update();

		starUpdate();
		explosionUpdate();
		bulletUpdate();
		enemyUpdate();

		soundManager.stopSound(SOUND_BGM);

		boolean explodeEnd;
		explodeEnd = true;
		//すべてのグループのすべての敵がスクリーンからでているか？
		boolean br = true;
		for (int i=0; i<group.size(); i++){
			br = EnemyGroup.isAllScreenOut(group.get(i));
			if (!br) explodeEnd = false;
		}
		//自分のロケットの爆発はすべて終わっているか？
		for (int i=0; i<explosion.size(); i++){
			if (explosion.get(i).life > 0) {
				explodeEnd = false;
			}
		}
		if (explodeEnd){//爆発がすべて終わり、敵がすべて画面の外へでたら・・・
			myRocketNum --;
			if (myRocketNum ==0 ){
				game = Game.GAMEOVER;//残機が０なら「４：ゲームオーバー」にする。
			}else game = Game.STARTING;//ゲームを「３：戦闘開始」にする。
		}

		render();
		renderEnemies();
		renderExplosion();
		renderBullets();
		renderStars();
		renderText();

	}
	//////////////////////１：ゲーム中//////////////////////////////////
	private void playing() throws IOException {
		//F2キー(STARTキー)でポーズする
		if (controller.isPressing(Input.START)) {
			keyOn = true;
		}//押されて離したらポーズを切り替える
		if (!((controller.isPressing(Input.START))) && keyOn ){
			pauseOn = !pauseOn;
			keyOn = false;
			if ( soundManager.isPlayingSound() ){
				soundManager.pauseSound(SOUND_BGM);
			}else soundManager.playSound(SOUND_BGM);
		}

		update();//ポーズ中でもこれとrender()は呼び出しかけないとだめ。

		if (pauseOn){
			//各種オブジェクトの描画位置を計算する。
			starUpdate();
			explosionUpdate();
			bulletUpdate();
			enemyUpdate();
			rocketUpdate();
			groupUpdate();
			bonusUpdate();

			if ( !(soundManager.isPlayingSound()) ){
				soundManager.playSound(SOUND_BGM);
			}
			//ゲーム開始時
			//createNum = 5;
			//groupLife = 500;
			//maxSpeed = 4;
			//maxGroup = 1;
			if ( score > 500){
				maxGroup = 2;
			}
			if ( score > 1000){
				enemyCreNum = 5;
				groupLife = 400;
				maxSpeed = 5;
				maxGroup = 3;
			}
			if ( score > 2000){
				enemyCreNum = 6;
				groupLife = 350;
				maxSpeed = 6;
				maxGroup = 3;
			}
			if ( score > 3000){
				enemyCreNum = 7;
				groupLife = 300;
				maxSpeed = 7;
				maxGroup = 3;
			}
			if ( score > 4000){
				enemyCreNum = 7;
				groupLife = 300;
				maxSpeed = 7;
				maxGroup = 4;
			}
			if ( score > 5000){
				enemyCreNum = 7;
				groupLife = 200;
				maxSpeed = 9;
				maxGroup = 4;
			}
		}
		//  オフスクリーンに描画する
		render();
		renderBullets();
		renderMyRocket();
		renderEnemies();
		renderExplosion();
		renderBonus();
		renderStars();
		renderText();
	}// end of playing
	//////////////////////敵のグループの計算処理////////////////////////////
	private void groupUpdate() {
		int cnum, lnum, life;
		//そのグループにまだ活動中な敵が残っているのかを調べたい。
		for (int i=0; i<group.size(); i++){
			cnum = group.get(i).createNum;
			lnum = group.get(i).enemy.size();
			life = group.get(i).getLife();
			if (cnum == 0 && lnum == 0 && life < 0){
				group.remove(i);
			}else group.get(i).decLife();
			if (life < 0 && group.size() < maxGroup ){
					group.add(new EnemyGroup(enemyCreNum, groupLife, maxSpeed));
			}
		}//for i
	}
	/////////////////MyRocketの移動（計算）処理////////////////////////
	private void rocketUpdate() {

		long now;//エルロンロールのための時間測定に使用。

		

		//  移動の方向と大きさを判定する
		int moveSize = 5;
		int moveX = 0;
		int moveY = 0;

		//上下移動
		if (controller.isPressing(Input.UP)) {
			moveY = 1;
			pitch = pitch - pitchInc;
			if (pitch < -10) pitch = -10;

		} else if (controller.isPressing(Input.DOWN)) {
			moveY = -1;
			pitch = pitch + pitchInc;
			if (pitch > 10) pitch = 10;

		} else {
			if (pitch <0){
				pitch = pitch + pitchInc;
			}else if (pitch >0){
				pitch = pitch - pitchInc;
			}
		}

		//左右移動
		//右キー入力があった
		if (controller.isPressing(Input.RIGHT)) {
			moveX = 1; 
			roll = roll + rollInc;//通常のロール
			if ( roll > 80 && aileronRoll != 3 ) roll = 80;

			now = getMillisecond();
			if (aileronRoll == 0) aileronRoll = 1;//一度目のキー入力
			if (aileronRoll == 2 && now - keyRepeatTime < repeatLimit ){//右エルロンロール開始
				aileronRoll = 3;
			}
			if (aileronRoll == 3){//右エルロンロールしている。
				moveX = 2;
				roll = roll + rollInc * 3;
				if (roll > 90) roll = -roll;
				if ( rocketScale < 40) rocketScale = rocketScale + 2;
			}
			if (aileronRoll < 0) {
				aileronRoll = 0;//左キーのロールは解除する。
			}

			//左キー入力があった。	
		} else if (controller.isPressing(Input.LEFT)) {
			moveX = -1;
			roll = roll - rollInc;
			if ( roll < -80 && aileronRoll != -3 ) roll = -80;

			now = getMillisecond();
			if (aileronRoll == 0) aileronRoll = -1;//一度目のキー入力
			if (aileronRoll == -2 && now - keyRepeatTime < repeatLimit ){//左エルロンロール開始
				aileronRoll = -3;
			}
			if (aileronRoll == -3){//左エルロンロールしている。
				moveX = -2;
				roll = roll - rollInc * 3;
				if (roll < -90)roll = -roll;
				if ( rocketScale < 40) rocketScale = rocketScale + 2;
			}
			if (aileronRoll > 0) {
				aileronRoll = 0;//右キーのロールは解除する。
			}
			//キーがおされていない
		} else {
			if (Math.abs(aileronRoll) == 3){//２度めのキーが離されたのでエルロンロールが終了したと判断
				aileronRoll = 0;
			}

			if (Math.abs(aileronRoll) == 1 ){//一度目のキーが離されたと判断
				aileronRoll = aileronRoll * 2;
				keyRepeatTime = getMillisecond();//時間を測り始める
			}
			now = getMillisecond();
			if (now - keyRepeatTime > repeatLimit ) aileronRoll = 0;

			if (roll <0) {
				roll = roll + rollInc;
			}else if (roll >0) {
				roll = roll - rollInc;	
			}
		}
		if (rocketScale > 25 && Math.abs(aileronRoll) != 3 ) rocketScale = rocketScale -2;//スケールを元に戻そうとする。
		///////弾丸発射////////
		//circleOn によってボタンのおしっぱなしができないようにしている。
		//エルロンロールしているときは弾が撃てない。
		if (controller.isPressing(Input.CIRCLE) && !circleOn && Math.abs(aileronRoll) != 3 ) {//キーボードでは「ｚ」
			for (int i=0; i<bulletNum; i++){
				if (!bullet[i].bulletState && bulletIntervalCount > bulletInterval){
					bullet[i].Shoot();
					bulletIntervalCount = 0;
					soundManager.playEffect(SOUND_SHOT);
					circleOn = true;
				}
			}
		}
		if (!controller.isPressing(Input.CIRCLE)) {
			circleOn = false;
		}
		bulletIntervalCount++;
		if (x + (moveX * move * moveSize) >0 && x + (moveX * move * moveSize) < width ){
			x += (moveX * move * moveSize);
		}
		if (y + (moveY * move * moveSize) >0 && y + (moveY * move * moveSize) < height){
			y += (moveY * move * moveSize);
		}
	}
	/////////////////////エイリアンの移動処理/////////////////////////////
	private void enemyUpdate() {

		for (int j=0; j<group.size(); j++){
			for (int i=0; i<group.get(j).enemy.size(); i++){

				switch (group.get(j).enemy.get(i).state){
				case NOTAPPEAR:
					break;
				case APPEAR://活動中である。
					//所属するグループのxをgxとして引数として渡す。
					//もしグループの最後尾の敵が画面下に消えた時は再度出現するｘ座標を乱数で変更する。
					//列を組んで出現する時に適応。
					float gx = group.get(j).x;
					group.get(j).enemy.get(i).update(gx);
					if (group.get(j).enemy.get(i).t == -1){
						group.get(j).enemy.get(i).t = 0;
						if (i == group.get(j).enemy.size() -1 ){//最後尾の敵である。
							group.get(j).x = (float)(Math.random()*Main.width);
							group.get(j).firstShot = false;
						}	
					}
					break;

				case HIT://たまに当たった
					soundManager.playEffect(SOUND_HIT);
					score = score + group.get(j).enemy.get(i).score;

					/////////爆発を発生させる///////
					int m, n;
					n = explosionStandardNum;
					for (int k=0; k<n; k++){
						m = (int)(Math.random()*30)+10;
						explosion.add(new Explosion(group.get(j).enemy.get(i).x, group.get(j).enemy.get(i).y, 
								group.get(j).enemy.get(i).vx, group.get(j).enemy.get(i).vy, m , 0));
					}//for k
					
					//////所属するグループが最初に出現して一度も画面下に消えずに全滅したか？/////////
					if (group.get(j).enemy.get(i).apperCount == 0){
						group.get(j).firstShotCount++;
						if (group.get(j).firstShotCount == group.get(j).num && group.get(j).firstShot ){
							int bo = 50;
							score = score + bo;
							bonus.add(new Bonus(group.get(j).enemy.get(i).x, group.get(j).enemy.get(i).y, bo));
							soundManager.playEffect(SOUND_BONUS);
						}
					}else{//そのグループの初出現ではないものを撃つとカウントを０にして条件を満たさないようにする。
						group.get(j).firstShotCount = 0;
						group.get(j).firstShot = false;
					}
					
					//破壊された敵を除去する。
					group.get(j).enemy.remove(i);
					break;

				case HITMYROCKET://自分のロケットと当たった
					soundManager.playEffect(SOUND_DAMAGED);
					game = Game.DESTORIED;//「やられました」の処理にする。

					/////////大爆発を発生させる///////
					n = explosionStandardNum + 20;

					for (int k=0; k<n; k++){
						m = (int)(Math.random()*60)+20;
						explosion.add(new Explosion(group.get(j).enemy.get(i).x, group.get(j).enemy.get(i).y, 0, 0, m , 100));
					}
					//ロケットの座標をマイナスにしてロケットが爆発している時は衝突しないようにする。
					x = -100;
					y = -100;

					group.get(j).enemy.remove(i);
					break;

				case SCREENOUT://ロケットが破壊されたときは画面の外へでたらエイリアンは消滅する
					group.get(j).enemy.remove(i);
					break;
				}//end of switch
			}//end of for i

			//このグループに新たな敵を追加するか？
			int creNum = group.get(j).createNum;
			if (group.get(j).Appear(creNum)){ 
				group.get(j).enemy.add(new Enemy(group.get(j)));
				group.get(j).createNum--;
			}
		}//for j


	}
	//////////////////////弾丸の移動処理///////////////////////
	private void bulletUpdate() {
		for (int i=0; i<bulletNum; i++){
			if (bullet[i].bulletState){
				bullet[i].Update();
			}
		}

	}
	///////////////////////爆発の移動処理////////////////////////////
	private void explosionUpdate() {
		for (int i=0; i<explosion.size(); i++){
			if (explosion.get(i).life > 0 ){
				explosion.get(i).update();
			}
			else{
				explosion.remove(i);
			}
		}// for i
	}
	///////////////////////ボーナス表示の移動処理////////////////////////////
	private void bonusUpdate() {
		for (int i=0; i<bonus.size(); i++){
			if (bonus.get(i).life > 0 ){
				bonus.get(i).update();
			}
			else{
				bonus.remove(i);
			}
		}// for i
	}
	///////////////////////背景の星の移動処理////////////////////////
	private void starUpdate() {

		for (int i=0; i<starNum; i++){
			star[i].updateStar();
		}
	}
	///////////////////////////////////////////////////////////////////////////
	//////////////////////////////画面を更新する////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	private void render() {
		//  設定を初期化する
		glLoadIdentity();
		lightManager.light();
	}
	////////////////////ゲームタイトルの描画////////////////////////
	private void renderTitle() {
		// フォントの色を設定する
		font.setColor(1f, 1f, 1f);
		glTranslatef(0, 0, depth / -2f);
		glColor4f(1f, 1f, 1f, 0f);
		// LWJGFont で文字列を表示する
		try {
			String string;
			int wid;
			String inputName;
			
			glPushMatrix();

				if (titleRoll > 360) {
					titleCount ++;
					if (titleCount >500 ){
						titleCount = 0;
						titleRoll = 220;
					}
				}
				else{
					titleRoll ++;
				}
				//これから描画する物体は自分で発光する
				lightManager.emissionOn();
				
				glRotatef(titleRoll, 1, 0, 0);
				wid = titleTexture.getTextureWidth();
				drawPicture(titleTexture, width/2 -275, height/2 + 200);
				
				//自分で発光するのをやめる
				lightManager.emissionOff();
				
			glPopMatrix();
			
			if (controller.getName() == "Keyboard"){
				inputName = "F2";
			}else{
				inputName = "STARTキー";
			}
			string = inputName + "を押してください";
			wid = font.stringWidth(string);
			font.drawString(string, width/2 - wid/2,height/2 -150, 0);
			
			if (controllers.size() > 1 ){
				string = "入力デバイス:" + controller.getName();
				wid = font.stringWidth(string);
				font.drawString(string, width/2 - wid/2, height/2 -180, 0);
				string = "入力デバイスを変更するにはF1を押してください";
				wid = font.stringWidth(string);
				font.drawString(string, width/2 - wid/2, height/2 -210, 0);
			}
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	///////////////////ゲームオーバーの描画///////////////////
	private void renderGameOver() {

		try {
			String string;
			int wid;

			// フォントの色を設定する
			font.setColor(1f, 1f, 1f);
			glTranslatef(0, 0, depth / -2f);
			glColor4f(1f, 1f, 1f, 1f);

			glPushMatrix();
			//これから描画する物体は自分で発光する
			lightManager.emissionOn();

			wid = gameOver.getTextureWidth();
			drawPicture(gameOver, width/2 -275, height/2 + 200);

			//自分で発光するのをやめる
			lightManager.emissionOff();
			glPopMatrix();

			// LWJGFont で文字列を表示する
			string = "スコア："+ score+ "点でした";
			wid = font.stringWidth(string);
			font.drawString(string, width/2 - wid/2,height/2 -150, 0);
			string = "F5を押してください";
			wid = font.stringWidth(string);
			font.drawString(string, width/2 - wid/2,height/2 - 200, 0);

		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	///////////////////////スコアなどテキスト描画///////////////////////
	private void renderText() {
		// フォントの色を設定する
		font.setColor(1f, 1f, 1f);
		glTranslatef(0, 0, depth / -2f);
		glColor4f(1f, 1f, 1f, 1f);
		// LWJGFont で文字列を表示する
		try {
			String scoreString;
			scoreString = "スコア："+ Integer.toString(score)+"  ロケット："+ Integer.toString(myRocketNum) ;
			font.drawString(scoreString, 10, 10, 0);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	///////////////////////////星を描く/////////////////////////////////
	private void renderStars() {

		for (int i=0; i<starNum; i++){
			glPushMatrix();

			glTranslatef(0, 0, depth / -2f);
			glTranslatef(star[i].starX, star[i].starY,10);
			glRotatef(0, 1, 0, 0);
			scale = 2f;
			glScalef(scale, scale, scale);
			glColor4f(1f, 1f, 1f, 1f);
			starTile[star[i].starColorNum].render();

			glPopMatrix();
		}
	}
	//////////////////////////弾丸を描く/////////////////////////////////
	private void renderBullets() {
		//これから描画する物体は自分で発光する
		lightManager.emissionOn();

		for(int i=0; i<bulletNum; i++){
			if (bullet[i].bulletState){
				glPushMatrix();

				glTranslatef(0, 0, depth / -2f);
				glTranslatef(bullet[i].bulletX, bullet[i].bulletY,100);
				glRotatef(0, 1, 0, 0);
				scale = 10f;
				glScalef(scale, scale, scale);
				glColor4f(1f, 1f, 1f, 1f);
				bulletModel.render();

				glPopMatrix();
			}
		}
		//自分で発光するのをやめる
		lightManager.emissionOff();
	}
	///////////////////////////爆発を描く/////////////////////////////////////
	private void renderExplosion() {

		//これから描画する物体は自分で発光する
		lightManager.emissionOn();

		for (int i=0; i<explosion.size(); i++){
			//  行列スタックに現在の行列を退避させ、新しい行列に対してモデルビュー変換を開始する
			glPushMatrix();

			//  画面中央の座標を (0, 0, 0) とするよう座標系を移動する
			glTranslatef(0, 0, depth / -2f);

			glTranslatef(explosion.get(i).x
					,explosion.get(i).y
					,100);

			scale = explosion.get(i).size;
			glScalef(scale, scale, scale);

			glColor4f(1f, 1f, 1f, 1f);

			explosionModel[explosion.get(i).color].render();

			//  行列スタックからもとの行列を取り出す
			glPopMatrix();
		}
		//自分で発光するのをやめる
		lightManager.emissionOff();
	}
	//////////////////////ボーナスを描く////////////////////
	private void renderBonus() {
		for (int i=0; i<bonus.size(); i++){
			//  行列スタックに現在の行列を退避させ、新しい行列に対してモデルビュー変換を開始する
			glPushMatrix();

			//  画面中央の座標を (0, 0, 0) とするよう座標系を移動する
			glTranslatef(0, 0, depth / -2f);
			
			// LWJGFont で文字列を表示する
			try {
				String str;
				str = "+"+bonus.get(i).addBonus;
				int wid = font.stringWidth(str);
				float strx = bonus.get(i).x - wid/2;
				font.drawString(str, strx, bonus.get(i).y, 0);

			} catch (IOException e) {
				e.printStackTrace();
			}
			//  行列スタックからもとの行列を取り出す
			glPopMatrix();
		}	
	}
	/////////////////////////////エイリアンを描く//////////////////////////////////////
	private void renderEnemies() {
		for (int j=0; j< group.size(); j++){
			for (int i=0; i< group.get(j).enemy.size(); i++){
				if (group.get(j).enemy.get(i).state == State.APPEAR){//活動中であるなら描画する
					//  行列スタックに現在の行列を退避させ、新しい行列に対してモデルビュー変換を開始する
					glPushMatrix();

					//  画面中央の座標を (0, 0, 0) とするよう座標系を移動する
					glTranslatef(0, 0, depth / -2f);
					glTranslatef(group.get(j).enemy.get(i).x, group.get(j).enemy.get(i).y, 100);

					glRotatef(group.get(j).enemy.get(i).direction , 0, 0, 1);
					glRotatef(group.get(j).enemy.get(i).roll, 0, 1, 0);
					glRotatef(group.get(j).enemy.get(i).yaw, 0, 0, 1);

					scale = 25f;
					glScalef(scale, scale, scale);

					glColor4f(1f, 1f, 1f, 1f);

					int id = group.get(j).enemy.get(i).type.getId();
					enemyModel[id].render();

					//  行列スタックからもとの行列を取り出す
					glPopMatrix();
				}//end if
			}//for i
		}//for j

	}
	////////////////////////////////////自分のロケットを描く///////////////////////////////
	private void renderMyRocket() {

		//  行列スタックに現在の行列を退避させ、新しい行列に対してモデルビュー変換を開始する
		glPushMatrix();

		//  画面左下の座標を (0, 0, 0) とするよう座標系を移動する
		glTranslatef(0, 0, depth / -2f);
		glTranslatef(x,y,100);

		glRotatef(roll, 0, 1, 0);
		glRotatef(pitch, 1, 0, 0);

		scale = rocketScale;
		glScalef(scale, scale, scale);

		glColor4f(1f, 1f, 1f, 1f);

		myRocket.render();
		//  行列スタックからもとの行列を取り出す
		glPopMatrix();


	}
	///////////////////////////絵を配置する////////////////////////////
	private void drawPicture(Texture texture, float x, float y) {
        //  テクスチャをバインドする
        texture.bind();
 
        glBegin(GL_QUADS);
 
        float   x2 = x + texture.getWidth();
        float   y2 = y - texture.getHeight();
        
        texture.point(texture.getWidth(), 0);
        glVertex3f(x2, y, 100);
 
        texture.point(0, 0);
        glVertex3f(x, y, 100);
 
        texture.point(0, texture.getHeight());
        glVertex3f(x, y2, 100);
     
        texture.point(texture.getWidth(), texture.getHeight());
        glVertex3f(x2, y2, 100);
         
        glEnd();
    }
	///////////////////////FPSを計算する////////////////////////
	private void calcFps() {
		long    now = getMillisecond();

		//  前のフレームからの経過時間を求め、timeDelta に足す
		timeDelta += now - time;
		time = now;

		if (1000 <= timeDelta) {
			//  timeDelta が 1 秒を上回ったら、FPS をリセットする
			timeDelta -= 1000;
			calcedFps = fps;
			fps = 1;
		} else {
			fps++;
		}
	}
	////////////////////////コントローラーの状況をアップデート///////////////////
	private void updateControllers() {
		//  すべてのジョイパッドの入力を取得する
		Controllers.poll();

		while (Controllers.next()) {
			//  現在利用しているジョイパッドのイベントであれば、入力状況を更新する
			if (controller.isOwner(Controllers.getEventSource())) {
				controller.update();
			}
		}

		//  キーボードは常に入力状況を更新する
		keyboard.update();
	}
	//////////////////////////各３Dモデルを破棄する//////////////////////
	private void terminate() {
		if (myRocket != null) myRocket.dispose();
		for (int i=0; i<enemyTypeNum; i++){
			if (enemyModel[i] != null) enemyModel[i].dispose();
		}
		for (int i=0; i<4 ; i++){
			if (starTile[i] != null ) starTile[i].dispose();
		}
		for (int i=0; i<3 ; i++){
			if (explosionModel[i] != null) explosionModel[i].dispose();
		}
		soundManager.destroy();
	}
	////////////////////////現在の時間をミリ秒で返す///////////////////////////
	public static long getMillisecond() {

		return (Sys.getTime() * 1000) / Sys.getTimerResolution();
	}
	/////////////////////////main////////////////////////////////
	public static void main(String[] args) throws Exception {

		new Main().start();
	}
}