package shooting;

import static org.lwjgl.opengl.GL11.GL_AMBIENT;
import static org.lwjgl.opengl.GL11.GL_DIFFUSE;
import static org.lwjgl.opengl.GL11.GL_FRONT;
import static org.lwjgl.opengl.GL11.GL_LIGHT0;
import static org.lwjgl.opengl.GL11.GL_LIGHTING;
import static org.lwjgl.opengl.GL11.GL_NORMALIZE;
import static org.lwjgl.opengl.GL11.GL_POSITION;
import static org.lwjgl.opengl.GL11.GL_SPECULAR;
import static org.lwjgl.opengl.GL11.GL_EMISSION;
import static org.lwjgl.opengl.GL11.glEnable;
import static org.lwjgl.opengl.GL11.glLight;
import static org.lwjgl.opengl.GL11.glMaterial;
import static org.lwjgl.opengl.GL11.glDisable;

import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;

public class LightManager {
	enum Function {
		Ambient, Diffuse, Specular
	}

	private Function    function = Function.Ambient;
	private float       ambient = 0f;//(環境光)
	private float       diffuse = 0.9f;//(拡散反射光)
	private float       specular = 0.9f;//(鏡面反射光)
	//　position=0の時は無限遠方にライトが位置する。
	//　position=1の時は(x,y,z)にライトが位置する。
	private float       position = 1;
	private float       positionX = -100f;
	private float       positionY = 800f;
	private float       positionZ = 10f;

	public void initLight() {
		//  ライティングを有効にする
		glEnable(GL_LIGHTING);

		//  光源0 を有効にする
		glEnable(GL_LIGHT0);

		//  法線の正規化を強制する
		glEnable(GL_NORMALIZE);
	}

	public void light() {
		//  光源を設定する

		//  位置を指定する
		glLight(GL_LIGHT0, GL_POSITION, toFloarBuffer(new float[] {positionX, positionY, positionZ, position}));

		//  環境光・モデル全体が均一に明るくなっていく
		glLight(GL_LIGHT0, GL_AMBIENT, toFloarBuffer(new float[] {ambient, ambient, ambient, ambient}));

		//  拡散光・光の当たっている部分が中心から明るくなっていく
		glLight(GL_LIGHT0, GL_DIFFUSE, toFloarBuffer(new float[] {diffuse, diffuse, diffuse, diffuse}));

		//  鏡面光・光のあたっている部分が均一に明るくなっていく
		glLight(GL_LIGHT0, GL_SPECULAR, toFloarBuffer(new float[] {specular, specular, specular, specular}));

		//  鏡面光のみ、デフォルトでは色が設定されていないので、反映されるように色を設定する
		glMaterial(GL_FRONT, GL_SPECULAR, toFloarBuffer(new float[] {0.3f, 0.3f, 0.3f, 1f}));
	}
	public void setLight(float x,float y,float z, float w){
		//  位置を指定する
		//　引数として、(x,y,z,w)を与える。
	    //　w = 0 → 「無限遠方」　→　「太陽のような光源(並行光源)」
	    //　それ以外 → 「位置が決まる」　→　「点光源」
		//　通常は w=1 を指定すれば(x,y,z)の位置に光源が位置することになる。
		positionX = x;
		positionY = y;
		positionZ = z;
		position  = w;
	}
	public void turnOff(){
		//  ライティングを無効にする。
		glDisable(GL_LIGHT0);
		//glDisable(GL_LIGHTING);
	}
	public void turnOn(){
		//  ライティングを有効にする
		glEnable(GL_LIGHT0);
		//glEnable(GL_LIGHTING);
	}
	/**
	 *  長さ 4 の float 配列を FloatBuffer に変換して返す
	 */
	public FloatBuffer toFloarBuffer(float[] values) {
		FloatBuffer     floats = BufferUtils.createFloatBuffer(4).put(values);

		floats.flip();

		return floats;
	}

	public String getLabel() {
		return String.format("%s, ambient: %.3f, diffuse: %.3f, specular: %.3f, position: %.0f (%.0f, %.0f, %.0f)",
				function.name(), ambient, diffuse, specular, position, positionX, positionY, positionZ);
	}
	public void emissionOn(){
		glMaterial(GL_FRONT, GL_EMISSION, toFloarBuffer(new float[] {1f, 1f, 1f, 1f}));
	}
	public void emissionOff(){
		glMaterial(GL_FRONT, GL_EMISSION, toFloarBuffer(new float[] {0f, 0f, 0f, 0f}));
	}

}