#! /usr/bin/env ruby
# coding: utf-8

require "open3"


# ==============================================================================
# Get date, mozcver, utdicdate, sha256sum
# ==============================================================================

# Get date
date = Open3.capture3('date +"%Y-%m-%d"')[0].chomp

# Get mozcver
mozcver = Dir.glob("../mozc/mozc-*.*.*.102.tar.bz2")[0]
mozcver = mozcver.split("../mozc/mozc-")[1]
mozcver = mozcver.split(".tar.bz2")[0]
puts "mozcver = " + mozcver

# Get utdicdate
file = File.new("make-dictionaries.sh", "r")
	utdicdate = file.read.split("UTDICDATE=\"")[1]
file.close

utdicdate = utdicdate.split("\"")[0]
puts "utdicdate = " + utdicdate

# Get sha256sum of Mozc
sha256 = Open3.capture3("sha256sum ../mozc/mozc-" + mozcver + ".tar.bz2")[0].split(" ")[0]
puts "mozc sha256sum = " + sha256


# ==============================================================================
# Update README.md
# ==============================================================================

file = File.new("../README.md", "r")
	lines = file.read
file.close

lines = lines.sub(/date:\ \d{4}-\d{2}-\d{2}/, "date: " + date)
lines = lines.gsub(/mozc-\d\.\d{2}\.\d{4}\.102/, "mozc-" + mozcver)
lines = lines.gsub(/mozcdic-ut-\d{8}/, "mozcdic-ut-" + utdicdate)
lines = lines.gsub(/fcitx5-mozc-ut-\d{8}/, "fcitx5-mozc-ut-" + utdicdate)

file = File.new("../README.md", "w")
	file.puts lines
file.close


# ==============================================================================
# Update PKGBUILD
# ==============================================================================

pkgbuild = Dir.glob("../pkgbuild/*.PKGBUILD")

pkgbuild.length.times do |i|
	file = File.new(pkgbuild[i], "r")
		lines = file.read
	file.close

	# Update filenames
	newfile = pkgbuild[i].split("-2")[0]
	newfile = pkgbuild[i].split("-2")[0] + "-" + utdicdate + ".PKGBUILD" 

	File.rename(pkgbuild[i], newfile)
	pkgbuild[i] = newfile

	# Update mozcver
	lines = lines.sub(/_mozcver=\d\.\d{2}\.\d{4}\.102/, "_mozcver=" + mozcver)

	# Update utdicver
	lines = lines.sub(/_utdicver=\d{8}/, "_utdicver=" + utdicdate)

	# Update sha256sum
	lines = lines.sub(/\ \ \'.{64}\'\n/, "  '" + sha256 + "'\n")

	file = File.new(pkgbuild[i], "w")
		file.puts lines
	file.close
end
