/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.logger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.reflect.ClassLoaderUtil;
import org.dyndns.nuda.tools.util.StringUtil;

public class SLF4JLoggerAdaptor
implements LoggerAdaptor {
    private static Class<?> loggerClass = null;
    private static Class<?> loggerFactoryClass = null;
    private static Method getLogger = null;
    private static Method debug = null;
    private static Method debugT = null;
    private static Method info = null;
    private static Method infoT = null;
    private static Method warn = null;
    private static Method warnT = null;
    private static Method error = null;
    private static Method errorT = null;
    private Object logger = null;

    public SLF4JLoggerAdaptor() {
        if (loggerClass == null && loggerFactoryClass == null) {
            loggerClass = this.getLoggerClass();
            loggerFactoryClass = this.getLoggerFactoryClass();
            if (loggerClass == null) {
                String message = StringUtil.format("\u4ee5\u4e0b\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f[{}]", this.getLoggerClassName());
                IllegalStateException e = new IllegalStateException(message);
                throw e;
            }
            if (loggerFactoryClass == null) {
                String message = StringUtil.format("\u4ee5\u4e0b\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f[{}]", "org.slf4j.LoggerFactory");
                IllegalStateException e = new IllegalStateException(message);
                throw e;
            }
            this.initLoggerContainer();
        }
        this.createLoggerObject("default");
    }

    public SLF4JLoggerAdaptor(String loggerName) {
        if (loggerClass == null && loggerFactoryClass == null) {
            loggerClass = this.getLoggerClass();
            loggerFactoryClass = this.getLoggerFactoryClass();
            if (loggerClass == null) {
                String message = StringUtil.format("\u4ee5\u4e0b\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f[{}]", this.getLoggerClassName());
                IllegalStateException e = new IllegalStateException(message);
                throw e;
            }
            if (loggerFactoryClass == null) {
                String message = StringUtil.format("\u4ee5\u4e0b\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f[{}]", "org.slf4j.LoggerFactory");
                IllegalStateException e = new IllegalStateException(message);
                throw e;
            }
            this.initLoggerContainer();
        }
        this.createLoggerObject(loggerName);
    }

    private void initLoggerContainer() {
        if (loggerClass != null && loggerFactoryClass != null) {
            try {
                getLogger = loggerFactoryClass.getDeclaredMethod("getLogger", String.class);
                debug = loggerClass.getMethod("debug", String.class);
                debugT = loggerClass.getDeclaredMethod("debug", String.class, Throwable.class);
                info = loggerClass.getDeclaredMethod("info", String.class);
                infoT = loggerClass.getDeclaredMethod("info", String.class, Throwable.class);
                error = loggerClass.getDeclaredMethod("error", String.class);
                errorT = loggerClass.getDeclaredMethod("error", String.class, Throwable.class);
                warn = loggerClass.getDeclaredMethod("warn", String.class);
                warnT = loggerClass.getDeclaredMethod("warn", String.class, Throwable.class);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getRecommendVersion() {
        return "1.7.5";
    }

    @Override
    public String getLoggerClassName() {
        return "org.slf4j.Logger";
    }

    @Override
    public Class<?> getLoggerClass() {
        boolean isValid = ClassLoaderUtil.isClassDefined(this.getLoggerClassName());
        if (isValid) {
            try {
                Class<?> loggerClass = Class.forName(this.getLoggerClassName());
                return loggerClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private Class<?> getLoggerFactoryClass() {
        boolean isValid = ClassLoaderUtil.isClassDefined("org.slf4j.LoggerFactory");
        if (isValid) {
            try {
                Class<?> loggerFactoryClass = Class.forName("org.slf4j.LoggerFactory");
                return loggerFactoryClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private void createLoggerObject(String loggerName) {
        try {
            if (getLogger != null) {
                this.logger = getLogger.invoke(null, loggerName);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public LoggerAdaptor getLogger(String loggerName) {
        return new SLF4JLoggerAdaptor(loggerName);
    }

    @Override
    public LoggerAdaptor getLogger(Class<?> targetClass) {
        String className = targetClass.getCanonicalName();
        return this.getLogger(className);
    }

    @Override
    public void trace(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                debug.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                debugT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                debug.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                debugT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                info.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                infoT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                warn.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                warnT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                error.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                errorT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fatal(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                error.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                errorT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

