/*
 * Decompiled with CFR 0.152.
 */
package org.dyndns.nuda.logger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.dyndns.nuda.logger.LoggerAdaptor;
import org.dyndns.nuda.reflect.ClassLoaderUtil;
import org.dyndns.nuda.tools.util.StringUtil;

public class LOG4JLoggerAdaptor
implements LoggerAdaptor {
    private static Class<?> loggerClass = null;
    private static Method getLogger = null;
    private static Method debug = null;
    private static Method debugT = null;
    private static Method info = null;
    private static Method infoT = null;
    private static Method error = null;
    private static Method errorT = null;
    private static Method warn = null;
    private static Method warnT = null;
    private static Method fatal = null;
    private static Method fatalT = null;
    private Object logger = null;

    public LOG4JLoggerAdaptor() {
        if (loggerClass == null) {
            loggerClass = this.getLoggerClass();
            if (loggerClass == null) {
                String message = StringUtil.format("\u4ee5\u4e0b\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f[{}]", this.getLoggerClassName());
                IllegalStateException e = new IllegalStateException(message);
                throw e;
            }
            this.initLoggerContainer();
        }
        this.getLogger("default");
    }

    public LOG4JLoggerAdaptor(String loggerName) {
        if (loggerClass == null) {
            loggerClass = this.getLoggerClass();
            if (loggerClass == null) {
                String message = StringUtil.format("\u4ee5\u4e0b\u306e\u30af\u30e9\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f[{}]", this.getLoggerClassName());
                IllegalStateException e = new IllegalStateException(message);
                throw e;
            }
            this.initLoggerContainer();
            this.createLoggerObject(loggerName);
        }
    }

    private void initLoggerContainer() {
        if (loggerClass != null) {
            try {
                getLogger = loggerClass.getDeclaredMethod("getLogger", String.class);
                Class<?> category = Class.forName("org.apache.log4j.Category");
                debug = category.getMethod("debug", Object.class);
                debugT = category.getDeclaredMethod("debug", Object.class, Throwable.class);
                info = category.getDeclaredMethod("info", Object.class);
                infoT = category.getDeclaredMethod("info", Object.class, Throwable.class);
                error = category.getDeclaredMethod("error", Object.class);
                errorT = category.getDeclaredMethod("error", Object.class, Throwable.class);
                warn = category.getDeclaredMethod("warn", Object.class);
                warnT = category.getDeclaredMethod("warn", Object.class, Throwable.class);
                fatal = category.getDeclaredMethod("fatal", Object.class);
                fatalT = category.getDeclaredMethod("fatal", Object.class, Throwable.class);
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getRecommendVersion() {
        return "1.3";
    }

    @Override
    public String getLoggerClassName() {
        return "org.apache.log4j.Logger";
    }

    @Override
    public Class<?> getLoggerClass() {
        if (ClassLoaderUtil.isClassDefined(this.getLoggerClassName())) {
            try {
                Class<?> loggerClass = Class.forName(this.getLoggerClassName());
                return loggerClass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public LoggerAdaptor getLogger(String loggerName) {
        LOG4JLoggerAdaptor adaptor = new LOG4JLoggerAdaptor(loggerName);
        adaptor.createLoggerObject(loggerName);
        return adaptor;
    }

    private void createLoggerObject(String loggerName) {
        Object result = null;
        try {
            this.logger = result = getLogger.invoke(null, loggerName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public LoggerAdaptor getLogger(Class<?> targetClass) {
        String className = targetClass.getCanonicalName();
        LoggerAdaptor adaptor = this.getLogger(className);
        return adaptor;
    }

    @Override
    public void trace(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                debug.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                debugT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                debug.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                debugT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                info.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void info(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                infoT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                warn.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void warn(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                warnT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                error.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void error(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                errorT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fatal(String format, Object ... params) {
        if (getLogger != null && this.logger != null) {
            String message = StringUtil.format(format, params);
            try {
                fatal.invoke(this.logger, message);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fatal(String message, Throwable t) {
        if (getLogger != null && this.logger != null) {
            try {
                fatalT.invoke(this.logger, message, t);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

