/*
 * Decompiled with CFR 0.152.
 */
package v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import v1.BDDConstraintHandler;
import v1.ConstraintHandler;
import v1.Main;
import v1.Node;
import v1.PList;
import v1.Parameter;
import v1.Testcase;
import v1.VONode;
import v1.VariableAndBDD;

class NewBDDConstraintHandler
extends BDDConstraintHandler
implements ConstraintHandler {
    List<VariableAndBDD> parameterToVariablesAndBDD = null;

    NewBDDConstraintHandler(PList parameterList, List<Node> constraintList, TreeSet<Integer> constrainedParametersArg, VONode ast) {
        super(parameterList, constraintList, constrainedParametersArg, ast);
        this.parameterToVariablesAndBDD = this.setBDDforConstrainedParameter(parameterList);
        this.bddConstraint = this.setBddConstraint(constraintList);
    }

    void printConstraintBDD() {
        this.bdd.printSet(this.bddConstraint);
    }

    private List<VariableAndBDD> setBDDforConstrainedParameter(PList parameterList) {
        ArrayList<VariableAndBDD> res = new ArrayList<VariableAndBDD>();
        this.numOfBDDvariables = 0;
        for (Integer constrainedParameter : this.constrainedParameters) {
            int tmp;
            Parameter p = (Parameter)parameterList.get(constrainedParameter);
            int num_vars = 1;
            for (int levels = 2; p.value_name.size() >= levels; levels *= 2) {
                ++num_vars;
            }
            this.numOfBDDvariables += num_vars;
            int[] var = new int[num_vars];
            int i = num_vars - 1;
            while (i >= 0) {
                var[i] = this.bdd.createVar();
                --i;
            }
            int f = this.bdd.getZero();
            this.bdd.ref(f);
            int i2 = var.length - 1;
            while (i2 >= 0) {
                if ((p.value_name.size() - 1 & 1 << i2) > 0) {
                    int g = this.bdd.getOne();
                    this.bdd.ref(g);
                    int j = var.length - 1;
                    while (j > i2) {
                        int tmp2;
                        if ((p.value_name.size() - 1 & 1 << j) > 0) {
                            tmp2 = this.bdd.ref(this.bdd.and(g, var[j]));
                            this.bdd.deref(g);
                            g = tmp2;
                        } else {
                            tmp2 = this.bdd.ref(this.bdd.and(g, this.bdd.not(var[j])));
                            this.bdd.deref(g);
                            g = tmp2;
                        }
                        --j;
                    }
                    tmp = this.bdd.ref(this.bdd.and(g, this.bdd.not(var[i2])));
                    this.bdd.deref(g);
                    g = tmp;
                    tmp = this.bdd.ref(this.bdd.or(f, g));
                    this.bdd.deref(g);
                    this.bdd.deref(f);
                    f = tmp;
                }
                --i2;
            }
            int g = this.bdd.getOne();
            this.bdd.ref(g);
            int i3 = var.length - 1;
            while (i3 >= 0) {
                if ((p.value_name.size() - 1 & 1 << i3) > 0) {
                    tmp = this.bdd.ref(this.bdd.and(g, var[i3]));
                    this.bdd.deref(g);
                    g = tmp;
                } else {
                    tmp = this.bdd.ref(this.bdd.and(g, this.bdd.not(var[i3])));
                    this.bdd.deref(g);
                    g = tmp;
                }
                --i3;
            }
            int d = this.bdd.or(f, g);
            this.bdd.ref(d);
            this.bdd.deref(f);
            this.bdd.deref(g);
            res.add(new VariableAndBDD(var, d));
        }
        return res;
    }

    private int setBddConstraint(List<Node> constraintList) {
        int f = this.bdd.getOne();
        this.bdd.ref(f);
        for (VariableAndBDD vb : this.parameterToVariablesAndBDD) {
            int tmp = this.bdd.ref(this.bdd.and(f, vb.constraint));
            this.bdd.deref(f);
            f = tmp;
        }
        for (Node n : constraintList) {
            int g = n.buildBDD(this.bdd, this.parameterToVariablesAndBDD, this.constrainedParameters);
            int tmp = this.bdd.ref(this.bdd.and(f, g));
            this.bdd.deref(f);
            this.bdd.deref(g);
            f = tmp;
        }
        long middle = System.currentTimeMillis();
        f = this.extendBddConstraint(f);
        long end = System.currentTimeMillis();
        if (Main.verbose > 0) {
            System.out.println("BDD quantification " + (end - middle) + "ms");
        }
        return f;
    }

    private int extendBddConstraint(int constraint) {
        int f = constraint;
        if (Main.handler == Main.Handler.UP) {
            Collections.reverse(this.parameterToVariablesAndBDD);
        }
        for (VariableAndBDD p : this.parameterToVariablesAndBDD) {
            int tmp;
            int cube = p.var[0];
            this.bdd.ref(cube);
            int i = 1;
            while (i < p.var.length) {
                tmp = this.bdd.ref(this.bdd.and(cube, p.var[i]));
                this.bdd.deref(cube);
                cube = tmp;
                ++i;
            }
            int tmp0 = this.bdd.ref(this.bdd.exists(f, cube));
            tmp = this.bdd.ref(this.bdd.and(tmp0, cube));
            this.bdd.deref(cube);
            this.bdd.deref(tmp0);
            int newf = this.bdd.ref(this.bdd.or(f, tmp));
            this.bdd.deref(tmp);
            this.bdd.deref(f);
            f = newf;
        }
        if (Main.handler == Main.Handler.UP) {
            Collections.reverse(this.parameterToVariablesAndBDD);
        }
        return f;
    }

    @Override
    public boolean isPossible(Testcase test) {
        int node = this.bddConstraint;
        boolean[] bv = this.binarizeReduced(test);
        while (node != 0) {
            if (node == 1) {
                return true;
            }
            if (bv[this.bdd.getVar(node)]) {
                node = this.bdd.getHigh(node);
                continue;
            }
            node = this.bdd.getLow(node);
        }
        return false;
    }

    @Override
    public boolean isPossible(int[] test) {
        int node = this.bddConstraint;
        boolean[] bv = this.binarizeReduced(test);
        while (node != 0) {
            if (node == 1) {
                return true;
            }
            if (bv[this.bdd.getVar(node)]) {
                node = this.bdd.getHigh(node);
                continue;
            }
            node = this.bdd.getLow(node);
        }
        return false;
    }

    private boolean[] binarizeReduced(Testcase test) {
        boolean[] res = new boolean[this.numOfBDDvariables];
        int pos = 0;
        int i = 0;
        for (Integer factor : this.constrainedParameters) {
            VariableAndBDD p = this.parameterToVariablesAndBDD.get(i);
            int lv = test.get(factor);
            if (lv < 0) {
                int j = 0;
                while (j < p.var.length) {
                    res[pos + j] = true;
                    ++j;
                }
            } else {
                int j0 = 0;
                int j = p.var.length - 1;
                while (j >= 0) {
                    res[pos + j0] = (lv & 1 << j) > 0;
                    ++j0;
                    --j;
                }
            }
            pos += p.var.length;
            ++i;
        }
        return res;
    }

    private boolean[] binarizeReduced(int[] test) {
        boolean[] res = new boolean[this.numOfBDDvariables];
        int pos = 0;
        int i = 0;
        for (Integer factor : this.constrainedParameters) {
            VariableAndBDD p = this.parameterToVariablesAndBDD.get(i);
            int lv = test[factor];
            if (lv < 0) {
                int j = 0;
                while (j < p.var.length) {
                    res[pos + j] = true;
                    ++j;
                }
            } else {
                int j0 = 0;
                int j = p.var.length - 1;
                while (j >= 0) {
                    res[pos + j0] = (lv & 1 << j) > 0;
                    ++j0;
                    --j;
                }
            }
            pos += p.var.length;
            ++i;
        }
        return res;
    }
}

